/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.app.mda.cp;

import com.modeliosoft.modelio.app.mda.cp.IModuleConfigurationPoint;
import com.modeliosoft.modelio.app.mda.plugin.AppMda;
import com.modeliosoft.modelio.platform.expertises.core.expertise.IExpertise;
import com.modeliosoft.modelio.platform.expertises.core.workbench.IWorkbenchService;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.di.extensions.EventTopic;
import org.modelio.platform.mda.infra.service.IModuleManagementService;
import org.modelio.platform.mda.infra.service.IRTModule;
import org.modelio.platform.preferences.IGProjectPreferenceStore;
import org.modelio.platform.project.services.IProjectService;

@Creatable
public abstract class AbstractPersistentModuleConfigurationPoint
implements IModuleConfigurationPoint {
    private static final String ACTIVATED_MODULES = ".ActivatedModules";
    private static final String DEACTIVATED_MODULES = ".DeactivatedModules";
    private boolean isActive;
    @Inject
    @Optional
    private IProjectService projectService;
    @Inject
    @Optional
    private IModuleManagementService moduleService;
    protected IExpertise provider;
    @Inject
    @Optional
    private IWorkbenchService workbenchService;

    public void initializeProvider(IExpertise vp) {
        this.provider = vp;
    }

    public void activate() {
        this.isActive = true;
    }

    public void deactivate() {
        this.isActive = false;
    }

    public String getId() {
        return this.getClass().getName();
    }

    public IExpertise getProvider() {
        return this.provider;
    }

    public abstract List<String> getDefaultActivatedModules();

    @Override
    public final List<String> getActivatedModules() {
        List<String> deactivatedModules;
        List<String> activatedModules = this.loadLastActivatedModules();
        if (activatedModules == null) {
            activatedModules = new ArrayList<String>(this.getDefaultActivatedModules());
        }
        if ((deactivatedModules = this.loadLastDeactivatedModules()) == null) {
            deactivatedModules = Collections.emptyList();
        }
        activatedModules.removeAll(deactivatedModules);
        for (IRTModule iModule : this.moduleService.getModuleRegistry().getModules()) {
            String moduleName = iModule.getName();
            if (activatedModules.contains(moduleName) || deactivatedModules.contains(moduleName)) continue;
            AppMda.LOG.debug("%s config point: Add '%s' unknown module to activated modules", new Object[]{this, moduleName});
            activatedModules.add(moduleName);
        }
        return activatedModules;
    }

    private List<String> loadLastActivatedModules() {
        String key;
        IGProjectPreferenceStore projectPreferences = this.projectService.getProjectPreferences("com.modeliosoft.modelio.app.mda");
        if (projectPreferences.contains(key = this.computeKey(ACTIVATED_MODULES))) {
            return new ArrayList<String>(Arrays.asList(projectPreferences.getString(key).split("\\|")));
        }
        return null;
    }

    private List<String> loadLastDeactivatedModules() {
        String key;
        IGProjectPreferenceStore projectPreferences = this.projectService.getProjectPreferences("com.modeliosoft.modelio.app.mda");
        if (projectPreferences.contains(key = this.computeKey(DEACTIVATED_MODULES))) {
            return new ArrayList<String>(Arrays.asList(projectPreferences.getString(key).split("\\|")));
        }
        return null;
    }

    private void saveModulesState() {
        IGProjectPreferenceStore projectPreferences = this.projectService.getProjectPreferences("com.modeliosoft.modelio.app.mda");
        StringBuilder activatedModules = new StringBuilder();
        StringBuilder deactivatedModules = new StringBuilder();
        List startedModules = this.moduleService.getModuleRegistry().getStartedModules();
        for (IRTModule iModule : this.moduleService.getModuleRegistry().getModules()) {
            String moduleName = iModule.getName();
            if (startedModules.contains(iModule)) {
                activatedModules.append(moduleName);
                activatedModules.append("|");
                continue;
            }
            deactivatedModules.append(moduleName);
            deactivatedModules.append("|");
        }
        projectPreferences.setValue(this.computeKey(ACTIVATED_MODULES), activatedModules.toString());
        projectPreferences.setValue(this.computeKey(DEACTIVATED_MODULES), deactivatedModules.toString());
    }

    @Inject
    @Optional
    void onModulechange(@EventTopic(value="org/modelio/app/module/*") Object moduleEvent) {
        if (this.isActive) {
            this.saveModulesState();
        }
    }

    private String computeKey(String suffix) {
        return this.workbenchService.getCurrentWorkbench().getId() + suffix;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[expertise=" + this.getProvider().getId() + "]";
    }
}

