/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.app.mda.impl;

import com.modeliosoft.modelio.app.mda.cp.IModuleConfigurationPoint;
import com.modeliosoft.modelio.app.mda.plugin.AppMda;
import com.modeliosoft.modelio.platform.expertises.core.expertise.IExpertise;
import com.modeliosoft.modelio.platform.expertises.core.expertise.IExpertiseListener;
import com.modeliosoft.modelio.platform.expertises.core.expertise.IExpertiseService;
import jakarta.inject.Inject;
import java.util.HashMap;
import java.util.List;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.eclipse.e4.core.di.annotations.Optional;
import org.modelio.api.module.lifecycle.ModuleException;
import org.modelio.gproject.core.IGProject;
import org.modelio.gproject.parts.module.GModule;
import org.modelio.platform.mda.infra.service.IModuleManagementService;
import org.modelio.platform.project.services.IProjectService;

@Creatable
public class ExpertiseListener
implements IExpertiseListener {
    @Inject
    @Optional
    private IModuleManagementService moduleService;
    @Inject
    @Optional
    private IProjectService projectService;

    public void expertisesChanged(IExpertiseService expertiseService, List<IExpertise> activatedExpertises, List<IExpertise> deactivatedExpertises) {
        IGProject openedProject = this.projectService.getOpenedProject();
        if (openedProject == null) {
            return;
        }
        AppMda.LOG.info("Expertises changed:\n\t- removed = %s\n\tadded=%s", new Object[]{deactivatedExpertises, activatedExpertises});
        int priority = 0;
        HashMap<String, Integer> priorizedModules = new HashMap<String, Integer>();
        boolean activateAll = true;
        for (IExpertise ex : expertiseService.getActiveExpertises()) {
            List<String> modules;
            IModuleConfigurationPoint cp = (IModuleConfigurationPoint)ex.getConfigurationPoint(IModuleConfigurationPoint.class);
            if (cp == null || (modules = cp.getActivatedModules()) == null) continue;
            AppMda.LOG.info("  '%s' expertise activates modules: %s", new Object[]{ex.getId(), modules});
            for (String m : modules) {
                priorizedModules.putIfAbsent(m, priority++);
            }
            activateAll = false;
        }
        for (GModule gModule : openedProject.getParts(GModule.class)) {
            String moduleName = gModule.getName();
            if (activateAll || priorizedModules.containsKey(moduleName)) {
                try {
                    this.moduleService.activateModule(gModule);
                    this.moduleService.getModuleRegistry().getModule(gModule).setPriority(priorizedModules.getOrDefault(moduleName, Integer.MAX_VALUE).intValue());
                }
                catch (ModuleException e) {
                    AppMda.LOG.error("Unable to activate '%s' module: %s", new Object[]{moduleName, e.toString()});
                    AppMda.LOG.debug((Throwable)e);
                }
                continue;
            }
            try {
                AppMda.LOG.info("  Disabling '%s' module", new Object[]{moduleName});
                this.moduleService.getModuleRegistry().getModule(gModule).setPriority(Integer.MAX_VALUE);
                this.moduleService.deactivateModule(gModule);
            }
            catch (ModuleException e) {
                AppMda.LOG.error("Unable to deactivate '%s' module: %s", new Object[]{moduleName, e.toString()});
                AppMda.LOG.debug((Throwable)e);
            }
        }
    }

    public void expertiseAdded(IExpertiseService expertiseService, IExpertise expertise) {
    }

    public void expertiseRemoved(IExpertiseService expertiseService, IExpertise expertise) {
    }
}

