/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.cms.api;

import com.modeliosoft.modelio.cms.api.ICmsServices;
import com.modeliosoft.modelio.cms.api.NoCmsEngineException;
import java.util.Map;
import java.util.WeakHashMap;
import org.modelio.gproject.core.IGProject;
import org.modelio.gproject.project.AbstractGProject;
import org.modelio.vcore.session.api.ICoreSession;
import org.modelio.vcore.smkernel.mapi.MObject;

public class Cms {
    public static ICmsServices get(IGProject project) throws NoCmsEngineException {
        ICmsServices ret = Registry.get(project);
        if (ret == null) {
            throw new NoCmsEngineException(project);
        }
        return ret;
    }

    public static ICmsServices get(ICoreSession session) {
        IGProject project = AbstractGProject.getProject((ICoreSession)session);
        if (project == null) {
            throw new IllegalArgumentException(String.valueOf(session) + " is not managed by a GProject.");
        }
        return Cms.get(project);
    }

    public static ICmsServices get(MObject obj) throws IllegalArgumentException {
        IGProject proj = AbstractGProject.getProject((MObject)obj);
        if (proj == null) {
            throw new IllegalArgumentException(String.valueOf(obj) + " is not in a GProject.");
        }
        return Cms.get(proj);
    }

    public static class Registry {
        private static final Map<IGProject, ICmsServices> engines = new WeakHashMap<IGProject, ICmsServices>();

        public static void add(IGProject proj, ICmsServices svc) {
            engines.put(proj, svc);
        }

        public static void remove(IGProject proj) {
            engines.remove(proj);
        }

        public static ICmsServices get(IGProject project) {
            return engines.get(project);
        }
    }
}

