/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.cms.api;

import com.modeliosoft.modelio.cms.api.ICmsUnlockResult;
import com.modeliosoft.modelio.cms.api.IRefResultEntry;
import java.util.Collection;
import org.modelio.vcore.smkernel.mapi.MRef;

public class CmsUnlockException
extends Exception {
    private static final long serialVersionUID = 1L;
    private ICmsUnlockResult unlockResult;

    public CmsUnlockException(ICmsUnlockResult unlockResult) {
        this.unlockResult = unlockResult;
    }

    public ICmsUnlockResult getUnlockResult() {
        return this.unlockResult;
    }

    @Override
    public String getMessage() {
        Collection<MRef> lockedElse;
        StringBuilder s = new StringBuilder();
        s.append("Unlock operation failed :");
        Collection<IRefResultEntry> lockFailures = this.unlockResult.getLockFailures();
        if (!lockFailures.isEmpty()) {
            s.append("\n The following elements couldn't be unlocked:");
            for (IRefResultEntry f : lockFailures) {
                s.append("\n - ").append(f.getRef()).append(": ").append(f.getMessage());
            }
        }
        if (!(lockedElse = this.unlockResult.getLockedElseWhereElements()).isEmpty()) {
            s.append("\n The following elements are locked elsewhere:");
            for (MRef f : lockedElse) {
                s.append("\n - ").append(f);
            }
        }
        return s.toString();
    }
}

