/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.cms.driver.parse;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.modelio.vcore.smkernel.mapi.MRef;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class CmsNodeStruct {
    final List<MRef> components = new ArrayList<MRef>();
    final List<MRef> references = new ArrayList<MRef>();
    MRef parent = null;
    MRef myRef = null;
    final List<MRef> localcomponents = new ArrayList<MRef>();

    public CmsNodeStruct() {
    }

    public CmsNodeStruct(File exmlFile, File localFile) throws IOException, FileNotFoundException {
        this.readFrom(exmlFile, localFile);
    }

    public List<MRef> getComponents() {
        return this.components;
    }

    public List<MRef> getReferences() {
        return this.references;
    }

    public List<MRef> getLocalComponents() {
        return this.localcomponents;
    }

    public MRef getParent() {
        return this.parent;
    }

    public String getName() {
        return this.myRef.name;
    }

    public MRef getSelfRef() {
        return this.myRef;
    }

    public CmsNodeStruct readFrom(File exmlFile, File localFile) throws IOException, FileNotFoundException {
        new Reader().read(exmlFile);
        new LocalReader().read(localFile);
        return this;
    }

    public CmsNodeStruct readFrom(InputStream is) throws IOException {
        new Reader().read(is);
        return this;
    }

    static MRef readRef(Attributes attributes) {
        return new MRef(attributes.getValue("mc"), attributes.getValue("uid"), attributes.getValue("name"));
    }

    private class LocalReader {
        DefaultHandler initialState = new InitialHandler();
        DefaultHandler depState = new DepsState();
        SAXParser parser = null;

        public void read(File file) throws IOException, FileNotFoundException {
            if (file == null || !file.isFile()) {
                return;
            }
            Throwable throwable = null;
            Object var3_4 = null;
            try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));){
                this.read(is);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }

        private void read(InputStream is) throws IOException {
            try {
                this.parser = SAXParserFactory.newInstance().newSAXParser();
                this.parser.parse(is, this.initialState);
            }
            catch (ParseFinished parseFinished) {
            }
            catch (ParserConfigurationException | SAXException e) {
                throw new IOException(e.getLocalizedMessage(), e);
            }
        }

        private class DepsState
        extends DefaultHandler {
            @Override
            public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
                if (name.equals("COMPID")) {
                    ((LocalReader)LocalReader.this).CmsNodeStruct.this.localcomponents.add(CmsNodeStruct.readRef(attributes));
                }
            }

            @Override
            public void endElement(String uri, String localName, String name) throws SAXException {
                if (name.equals("DEPS")) {
                    LocalReader.this.parser.getXMLReader().setContentHandler(LocalReader.this.initialState);
                }
            }
        }

        private class InitialHandler
        extends DefaultHandler {
            @Override
            public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
                if (name.equals("DEPS")) {
                    LocalReader.this.parser.getXMLReader().setContentHandler(LocalReader.this.depState);
                }
            }
        }
    }

    private static class ParseFinished
    extends SAXException {
        private static final long serialVersionUID = 1L;
    }

    private class Reader {
        DefaultHandler initialState = new InitialHandler();
        DefaultHandler objState = new ObjState();
        SAXParser parser = null;
        DefaultHandler refObjState = new RefObjState();
        Collection<MRef> containedObjs = new HashSet<MRef>();

        public void read(File file) throws IOException, FileNotFoundException {
            Throwable throwable = null;
            Object var3_4 = null;
            try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));){
                this.read(is);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }

        public void read(InputStream is) throws IOException {
            try {
                this.parser = SAXParserFactory.newInstance().newSAXParser();
                this.parser.parse(is, this.initialState);
                this.cleanContainedCompositions();
            }
            catch (ParserConfigurationException e) {
                throw new IOException(e.getLocalizedMessage(), e);
            }
            catch (ParseFinished parseFinished) {
            }
            catch (SAXParseException e) {
                throw new IOException(e.getLocalizedMessage(), e);
            }
            catch (SAXException e) {
                throw new IOException(e.getLocalizedMessage(), e);
            }
        }

        private void cleanContainedCompositions() {
            Iterator<MRef> it = CmsNodeStruct.this.components.iterator();
            while (it.hasNext()) {
                MRef ref = it.next();
                if (!this.containedObjs.contains(ref)) continue;
                it.remove();
            }
        }

        private class InitialHandler
        extends DefaultHandler {
            @Override
            public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
                if (name.equals("OBJECT")) {
                    Reader.this.parser.getXMLReader().setContentHandler(Reader.this.objState);
                }
            }
        }

        private class ObjState
        extends DefaultHandler {
            private boolean inLink;

            @Override
            public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
                switch (name) {
                    case "COMPID": {
                        MRef ref = CmsNodeStruct.readRef(attributes);
                        if (Reader.this.containedObjs.contains(ref)) break;
                        ((Reader)Reader.this).CmsNodeStruct.this.components.add(ref);
                        break;
                    }
                    case "PID": {
                        if (((Reader)Reader.this).CmsNodeStruct.this.parent != null) break;
                        ((Reader)Reader.this).CmsNodeStruct.this.parent = CmsNodeStruct.readRef(attributes);
                        break;
                    }
                    case "ID": {
                        if (this.inLink) {
                            MRef readRef = CmsNodeStruct.readRef(attributes);
                            ((Reader)Reader.this).CmsNodeStruct.this.references.add(readRef);
                            break;
                        }
                        if (((Reader)Reader.this).CmsNodeStruct.this.myRef == null) {
                            ((Reader)Reader.this).CmsNodeStruct.this.myRef = CmsNodeStruct.readRef(attributes);
                            break;
                        }
                        MRef readRef = CmsNodeStruct.readRef(attributes);
                        Reader.this.containedObjs.add(readRef);
                        break;
                    }
                    case "FOREIGNID": {
                        MRef readRef = CmsNodeStruct.readRef(attributes);
                        ((Reader)Reader.this).CmsNodeStruct.this.references.add(readRef);
                        break;
                    }
                    case "LINK": {
                        this.inLink = true;
                        break;
                    }
                    case "REFOBJ": {
                        Reader.this.parser.getXMLReader().setContentHandler(Reader.this.refObjState);
                    }
                }
            }

            @Override
            public void endElement(String uri, String localName, String qName) throws SAXException {
                if (qName.equals("LINK")) {
                    this.inLink = false;
                }
            }
        }

        private class RefObjState
        extends DefaultHandler {
            @Override
            public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
                if (name.equals("ID")) {
                    ((Reader)Reader.this).CmsNodeStruct.this.references.add(CmsNodeStruct.readRef(attributes));
                }
            }

            @Override
            public void endElement(String uri, String localName, String name) throws SAXException {
                if (name.equals("REFOBJ")) {
                    Reader.this.parser.getXMLReader().setContentHandler(Reader.this.objState);
                }
            }
        }
    }
}

