/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.cms.driver.parse;

import com.modeliosoft.modelio.cms.driver.parse.CmsNodeStruct;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import org.modelio.vcore.smkernel.mapi.MRef;
import org.modelio.vstore.exml.resource.ExmlFileAccess;

public class StructureSnapshot {
    private boolean isValid = true;
    private final HashMap<MRef, CmsNodeStruct> cache = new HashMap();
    private final ExmlFileAccess geometry;

    public void dispose() {
        this.isValid = false;
    }

    public StructureSnapshot(ExmlFileAccess geometry) {
        this.geometry = geometry;
    }

    public CmsNodeStruct getNode(File f, File localFile) throws IOException {
        if (!this.isValid) {
            throw new IllegalStateException("The snapshot is disposed.");
        }
        MRef ref = this.geometry.getObRef(f);
        CmsNodeStruct ret = this.cache.get(ref);
        if (ret != null) {
            return ret;
        }
        if (f.isFile()) {
            ret = new CmsNodeStruct(f, localFile);
            this.cache.put(ref, ret);
            return ret;
        }
        return null;
    }

    public CmsNodeStruct getNode(MRef ref) throws IOException {
        if (!this.isValid) {
            throw new IllegalStateException("The snapshot is disposed.");
        }
        CmsNodeStruct ret = this.cache.get(ref);
        if (ret != null) {
            return ret;
        }
        File f = this.geometry.getExmlFile(ref);
        File localF = this.geometry.getLocalExmlFile(ref);
        if (f.isFile()) {
            ret = new CmsNodeStruct(f, localF);
            this.cache.put(ref, ret);
            return ret;
        }
        return null;
    }

    private static String getSimpleName(String qname) {
        int i = qname.lastIndexOf(46);
        if (i == -1) {
            return qname;
        }
        return qname.substring(i + 1);
    }

    public static MRef getSimpleRef(MRef aref) {
        String simpleMc = StructureSnapshot.getSimpleName(aref.mc);
        if (aref.mc != simpleMc) {
            return new MRef(simpleMc, aref.uuid, aref.name);
        }
        return aref;
    }
}

