/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.cms.engine;

import com.modeliosoft.modelio.cms.api.IAddCommand;
import com.modeliosoft.modelio.cms.api.ICancelAddCommand;
import com.modeliosoft.modelio.cms.api.ICodeReverser;
import com.modeliosoft.modelio.cms.api.ICommitCommand;
import com.modeliosoft.modelio.cms.api.IGetLockCommand;
import com.modeliosoft.modelio.cms.api.IMergeCommand;
import com.modeliosoft.modelio.cms.api.IProcessExtension;
import com.modeliosoft.modelio.cms.api.IRemoveCommand;
import com.modeliosoft.modelio.cms.api.IRepairCommand;
import com.modeliosoft.modelio.cms.api.IRevertCommand;
import com.modeliosoft.modelio.cms.api.IUpdateCommand;
import com.modeliosoft.modelio.cms.api.IUserLabelProvider;
import com.modeliosoft.modelio.cms.api.ModelChangesLoadingFailedException;
import com.modeliosoft.modelio.cms.api.TransactionStillOpenException;
import com.modeliosoft.modelio.cms.api.admin.IBreakLockCommand;
import com.modeliosoft.modelio.cms.api.admin.ICleanupWorkingCopyCommand;
import com.modeliosoft.modelio.cms.api.admin.IConnectDirToRepositoryCommand;
import com.modeliosoft.modelio.cms.api.admin.ICreateBranchCommand;
import com.modeliosoft.modelio.cms.api.admin.ICreateTagCommand;
import com.modeliosoft.modelio.cms.api.admin.IRepositoryProperties;
import com.modeliosoft.modelio.cms.api.admin.ISynchronizeStateCommand;
import com.modeliosoft.modelio.cms.api.contrib.ICmsContributor;
import com.modeliosoft.modelio.cms.api.contrib.ICmsContributorHolder;
import com.modeliosoft.modelio.cms.api.files.IFileChangesRecorder;
import com.modeliosoft.modelio.cms.api.mmextension.ICmsDependencyAnalyser;
import com.modeliosoft.modelio.cms.api.mmextension.ICmsMetamodelExtensionPoints;
import com.modeliosoft.modelio.cms.driver.ICmsDriver;
import com.modeliosoft.modelio.cms.engine.ICmsEngine;
import com.modeliosoft.modelio.cms.engine.ModelHandler;
import com.modeliosoft.modelio.cms.engine.SubversionRepositoryProperties;
import com.modeliosoft.modelio.cms.engine.SymbolService;
import com.modeliosoft.modelio.cms.engine.commands.add.AddCommand;
import com.modeliosoft.modelio.cms.engine.commands.add.CancelAddCommand;
import com.modeliosoft.modelio.cms.engine.commands.admin.CleanupWorkingCopyCommand;
import com.modeliosoft.modelio.cms.engine.commands.admin.ConnectDirToRepositoryCommand;
import com.modeliosoft.modelio.cms.engine.commands.admin.SynchronizeStateCommand;
import com.modeliosoft.modelio.cms.engine.commands.branch.CreateBranchCommand;
import com.modeliosoft.modelio.cms.engine.commands.branch.CreateTagCommand;
import com.modeliosoft.modelio.cms.engine.commands.commit.CodeReversers;
import com.modeliosoft.modelio.cms.engine.commands.commit.CommitCommand;
import com.modeliosoft.modelio.cms.engine.commands.commit.RepairCommand;
import com.modeliosoft.modelio.cms.engine.commands.lock.BreakLockCommand;
import com.modeliosoft.modelio.cms.engine.commands.lock.GetLockCommand;
import com.modeliosoft.modelio.cms.engine.commands.merge.MergeCommand;
import com.modeliosoft.modelio.cms.engine.commands.remove.RemoveCommand;
import com.modeliosoft.modelio.cms.engine.commands.revert.RevertCommand;
import com.modeliosoft.modelio.cms.engine.commands.update.UpdateCommand;
import com.modeliosoft.modelio.cms.engine.recorder.ModelChangeKeeper;
import com.modeliosoft.modelio.cms.utils.TransactionChecker;
import com.modeliosoft.modelio.gproject.svn.fragment.GSvnFragment;
import com.modeliosoft.modelio.gproject.svn.plugin.ProjectSvn;
import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.modelio.gproject.core.IGModelFragment;
import org.modelio.gproject.core.IGProject;
import org.modelio.gproject.data.project.DefinitionScope;
import org.modelio.gproject.data.project.GProperties;
import org.modelio.vbasic.progress.IModelioProgress;
import org.modelio.vcore.session.api.ICoreSession;
import org.modelio.vcore.session.api.model.change.IModelChangeHandler;
import org.modelio.vcore.session.api.model.change.IModelChangeListener;
import org.modelio.vcore.session.api.model.change.IModelChangeSupport;
import org.modelio.vcore.smkernel.mapi.MObject;
import org.modelio.vcore.smkernel.mapi.services.MetamodelExtensionPoint;

final class CmsEngine
implements ICmsEngine {
    private boolean isStarted = false;
    private static final String PEM_CONF_PREFIX = "svn.pem.holder.";
    private ModelChangeKeeper changeKeeper;
    private CodeReversers codeReversers;
    private final IProcessExtension defaultPem;
    private ModelHandler modelChangeHandler;
    private IProcessExtension processExtension;
    private ICoreSession coreSession;
    private IGProject project;
    private WeakReference<ICmsDriver> firstDriver = new WeakReference<Object>(null);
    private final IFileChangesRecorder fileChangesProxy = new FileChangesRecorderProxy();
    private ICmsMetamodelExtensionPoints mmExtensions;
    private IUserLabelProvider userLabelProvider;

    public CmsEngine(IGProject gProject, IProcessExtension defaultPem) {
        this.project = gProject;
        this.coreSession = gProject.getSession();
        this.processExtension = defaultPem;
        this.codeReversers = new CodeReversers();
        this.defaultPem = defaultPem;
        this.processExtension = defaultPem;
        this.mmExtensions = new CmsMetamodelExtensionPoints();
        this.loadPemContributionsOrder();
    }

    @Override
    public void saveModelChangeKeeper() throws IOException {
        if (this.changeKeeper != null) {
            this.changeKeeper.save();
        }
    }

    @Override
    public void checkTransactionStack() throws TransactionStillOpenException {
        if (TransactionChecker.isActiveTransaction(this.getCoreSession())) {
            throw new TransactionStillOpenException();
        }
    }

    @Override
    public SymbolService createSymbolService() {
        return new SymbolService(this.getCoreSession().getModel());
    }

    @Override
    public CodeReversers getCodeReversers() {
        return this.codeReversers;
    }

    public IProcessExtension getDefaultHook() {
        return this.defaultPem;
    }

    @Override
    public ModelChangeKeeper getModelChangeKeeper() {
        if (this.changeKeeper == null) {
            Path note = this.project.getPfs().getProjectDataPath().resolve("modelchanges.conf");
            try {
                this.changeKeeper = ModelChangeKeeper.load(this.getCoreSession(), note);
            }
            catch (ModelChangesLoadingFailedException e) {
                ProjectSvn.LOG.error(e);
                this.getHook().onModelChangeKeeperError(e);
                ProjectSvn.LOG.warning("Reseting the local model change history...");
                this.changeKeeper = ModelChangeKeeper.createEmpty(this.getCoreSession(), note);
                ProjectSvn.LOG.warning("Reseting the local model change history done.");
            }
        }
        return this.changeKeeper;
    }

    @Override
    public final ICoreSession getCoreSession() {
        return this.coreSession;
    }

    public void setHook(IProcessExtension hook) {
        List cl = this.processExtension.getPemContributorHolder().getPreContributors(ICmsContributorHolder.Action.add);
        this.processExtension = hook;
        this.loadPemContributionsOrder();
        for (ICmsContributor c : cl) {
            hook.getPemContributorHolder().addContributor(c);
        }
    }

    public IUserLabelProvider getUserLabelProvider() {
        return this.userLabelProvider;
    }

    public void setUserLabelProvider(IUserLabelProvider userLabelProvider) {
        this.userLabelProvider = userLabelProvider;
    }

    void startEngine() {
        if (this.isStarted) {
            throw new IllegalStateException("Engine already strated.");
        }
        this.modelChangeHandler = new ModelHandler(this, this);
        this.isStarted = true;
        this.setUserLabelProvider(svnId -> svnId);
        this.enableModelListeners();
        this.loadPemContributionsOrder();
    }

    void stopEngine() {
        if (this.modelChangeHandler != null) {
            this.disableModelListeners();
            this.modelChangeHandler = null;
        }
        this.isStarted = false;
    }

    @Override
    public void unloadChangeKeeper() {
        this.changeKeeper = null;
    }

    @Override
    public void enableModelListeners() {
        if (this.isStarted) {
            IModelChangeSupport modelChangeSupport = this.coreSession.getModelChangeSupport();
            modelChangeSupport.addModelChangeHandler((IModelChangeHandler)this.modelChangeHandler);
            modelChangeSupport.addModelChangeListener((IModelChangeListener)this.modelChangeHandler);
        }
    }

    public IProcessExtension getHook() {
        return this.processExtension;
    }

    @Override
    public void disableModelListeners() {
        this.coreSession.getModelChangeSupport().removeModelChangeHandler((IModelChangeHandler)this.modelChangeHandler);
        this.coreSession.getModelChangeSupport().removeModelChangeListener((IModelChangeListener)this.modelChangeHandler);
    }

    public IAddCommand createAddCommand() {
        return new AddCommand(this);
    }

    public IUpdateCommand createUpdateCommand() {
        return new UpdateCommand(this);
    }

    public ICommitCommand createCommitCommand() {
        return new CommitCommand(this);
    }

    public IRevertCommand createRevertCommand() {
        return new RevertCommand(this);
    }

    public IRepairCommand createRepairCommand(IGModelFragment fragment) {
        GSvnFragment cmsFrag = (GSvnFragment)fragment;
        return new RepairCommand(this, cmsFrag);
    }

    public IRemoveCommand createRemoveCommand() {
        return new RemoveCommand(this);
    }

    public IGetLockCommand createGetLockCommand() {
        return new GetLockCommand(this);
    }

    public IRepositoryProperties getAdminProperties(IGModelFragment fragment) throws IOException {
        return new SubversionRepositoryProperties(((GSvnFragment)fragment).getCmsDriver());
    }

    public ICancelAddCommand createCancelAddCommand() {
        return new CancelAddCommand((MetamodelExtensionPoint<ICmsDependencyAnalyser>)this.getMetamodelExtensions().getDependencyAnalyser());
    }

    public IBreakLockCommand createBreakLockCommand() {
        return new BreakLockCommand();
    }

    public ICleanupWorkingCopyCommand createCleanUpCommand() {
        return new CleanupWorkingCopyCommand();
    }

    public void addCodeReverser(ICodeReverser reverser) throws IllegalArgumentException {
        this.codeReversers.addReverser(reverser);
    }

    public void removeCodeReverser(ICodeReverser reverser) throws IllegalArgumentException {
        this.codeReversers.removeReverser(reverser);
    }

    public ISynchronizeStateCommand createSynchronizeStateCommand() {
        return new SynchronizeStateCommand();
    }

    @Override
    public IGProject getProject() {
        return this.project;
    }

    public IMergeCommand createMergeCommand() {
        return new MergeCommand(this);
    }

    @Override
    public ICmsDriver getCmsDriver(File f) {
        Iterator iterator;
        if (this.firstDriver.get() == null && (iterator = this.project.getParts(GSvnFragment.class).iterator()).hasNext()) {
            GSvnFragment frag = (GSvnFragment)((Object)iterator.next());
            this.firstDriver = new WeakReference<ICmsDriver>(frag.getCmsDriver());
        }
        return (ICmsDriver)this.firstDriver.get();
    }

    public CompletableFuture<Void> getBackgroundStatusProgress(IGModelFragment fragment, IModelioProgress progressListener) {
        return ((GSvnFragment)fragment).getCmsDriver().getStatusDriver().getBackgroundStatusProgress(progressListener, false).thenRun(() -> {});
    }

    public IConnectDirToRepositoryCommand createConnectDirToRepositoryCommand() {
        return new ConnectDirToRepositoryCommand();
    }

    @Override
    public void loadPemContributionsOrder() {
        GProperties projProperties = this.project.getProperties();
        HashMap<String, String> props = new HashMap<String, String>();
        for (GProperties.Entry en : projProperties.entries()) {
            if (!en.getName().startsWith(PEM_CONF_PREFIX)) continue;
            String key = en.getName().substring(PEM_CONF_PREFIX.length());
            props.put(key, en.getValue());
        }
        this.getHook().getPemContributorHolder().loadFrom(props);
    }

    @Override
    public void savePemContributionsOrder() {
        HashMap props = new HashMap();
        this.getHook().getPemContributorHolder().saveTo(props);
        GProperties projProperties = this.project.getProperties();
        for (Map.Entry en : props.entrySet()) {
            String key = PEM_CONF_PREFIX + (String)en.getKey();
            GProperties.Entry existing = projProperties.getProperty(key);
            if (existing != null && existing.getScope() != DefinitionScope.LOCAL) continue;
            projProperties.setProperty(key, (String)en.getValue(), DefinitionScope.LOCAL);
        }
    }

    public IFileChangesRecorder getFileChangeRecorder() {
        return this.fileChangesProxy;
    }

    public ICreateBranchCommand createCreateBranchCommand() {
        return new CreateBranchCommand(this);
    }

    public ICreateTagCommand createCreateTagCommand() {
        return new CreateTagCommand(this);
    }

    @Override
    public ICmsEngine.ILEnabler suspendModelListeners() {
        this.disableModelListeners();
        return new ICmsEngine.ILEnabler(){

            @Override
            public void close() {
                CmsEngine.this.enableModelListeners();
            }
        };
    }

    public ICmsMetamodelExtensionPoints getMetamodelExtensions() {
        return this.mmExtensions;
    }

    private class CmsMetamodelExtensionPoints
    implements ICmsMetamodelExtensionPoints {
        private final MetamodelExtensionPoint<ICmsDependencyAnalyser> depAnalyser = new MetamodelExtensionPoint();

        private CmsMetamodelExtensionPoints() {
        }

        public MetamodelExtensionPoint<ICmsDependencyAnalyser> getDependencyAnalyser() {
            return this.depAnalyser;
        }
    }

    private class FileChangesRecorderProxy
    implements IFileChangesRecorder {
        private FileChangesRecorderProxy() {
        }

        private IFileChangesRecorder getChained() {
            return CmsEngine.this.getModelChangeKeeper().getFilesRecorder();
        }

        public File recordFile(MObject related, String key, File file) {
            return this.getChained().recordFile(related, key, file);
        }

        public void recordDeletedFile(MObject related, String key, File file) {
            this.getChained().recordDeletedFile(related, key, file);
        }

        public File getRecordedFile(MObject related, String key) {
            return this.getChained().getRecordedFile(related, key);
        }

        public File recordFileMove(MObject related, String key, File oldFile, File newFile) {
            return this.getChained().recordFileMove(related, key, oldFile, newFile);
        }
    }
}

