/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.cms.engine;

import com.modeliosoft.modelio.cms.api.Cms;
import com.modeliosoft.modelio.cms.api.ICmsServices;
import com.modeliosoft.modelio.cms.api.IProcessExtension;
import com.modeliosoft.modelio.cms.api.NoCmsEngineException;
import com.modeliosoft.modelio.cms.api.mmextension.ICmsDependencyAnalyser;
import com.modeliosoft.modelio.cms.engine.CmsEngine;
import com.modeliosoft.modelio.cms.engine.ICmsEngine;
import com.modeliosoft.modelio.cms.model.ModelGroups;
import java.util.Collection;
import org.modelio.gproject.core.IGProject;
import org.modelio.gproject.project.AbstractGProject;
import org.modelio.vcore.model.spi.IGMetamodelExtension;
import org.modelio.vcore.smkernel.mapi.MObject;
import org.modelio.vcore.smkernel.mapi.services.MetamodelExtensionPoint;

public final class CmsEngines {
    private CmsEngines() {
    }

    public static ICmsEngine start(IGProject project, IProcessExtension aDefaultPem) throws IllegalArgumentException {
        if (Cms.Registry.get((IGProject)project) != null) {
            throw new IllegalArgumentException(String.format("'%s' project already has a ICmsEngine engine.", project.getName()));
        }
        CmsEngine e = new CmsEngine(project, aDefaultPem);
        e.startEngine();
        MetamodelExtensionPoint depAnalyserMmExtPoint = e.getMetamodelExtensions().getDependencyAnalyser();
        for (IGMetamodelExtension mmext : project.getProjectEnvironment().getDefaultMetamodelExtensions()) {
            ICmsDependencyAnalyser ext = (ICmsDependencyAnalyser)mmext.createExtension(ICmsDependencyAnalyser.class, project.getSession());
            if (ext == null) continue;
            depAnalyserMmExtPoint.registerExtension((Object)ext, mmext.getMmFragment().getClass());
        }
        Cms.Registry.add((IGProject)project, (ICmsServices)e);
        return e;
    }

    public static void stop(IGProject project) {
        CmsEngine cmsEngine = (CmsEngine)Cms.Registry.get((IGProject)project);
        if (cmsEngine != null) {
            cmsEngine.stopEngine();
            Cms.Registry.remove((IGProject)project);
        }
    }

    public static ICmsEngine get(MObject obj) throws IllegalArgumentException, NoCmsEngineException {
        IGProject proj = AbstractGProject.getProject((MObject)obj);
        if (proj == null) {
            throw new IllegalArgumentException(String.valueOf(obj) + " is not in a GProject.");
        }
        return CmsEngines.get(proj);
    }

    public static ICmsEngine get(IGProject proj) throws NoCmsEngineException {
        return (ICmsEngine)Cms.get((IGProject)proj);
    }

    public static ICmsEngine get(Collection<MObject> list) throws IllegalArgumentException, NoCmsEngineException {
        IGProject theProject = null;
        for (MObject obj : list) {
            IGProject proj = AbstractGProject.getProject((MObject)obj);
            if (proj == null) {
                throw new IllegalArgumentException(String.valueOf(obj) + " is not in a GProject.");
            }
            if (theProject == null) {
                theProject = proj;
                continue;
            }
            if (theProject == proj) continue;
            throw new IllegalArgumentException("All model objects are not in the same project.");
        }
        return CmsEngines.get(theProject);
    }

    public static boolean areConnected(Collection<MObject> list) throws IllegalArgumentException {
        IGProject ret = null;
        for (MObject obj : list) {
            IGProject proj = AbstractGProject.getProject((MObject)obj);
            if (ret == null) {
                ret = proj;
                continue;
            }
            if (ret == proj) continue;
            throw new IllegalArgumentException("All model objects are not in the same project.");
        }
        if (ret == null) {
            return false;
        }
        if (Cms.Registry.get(ret) != null) {
            return new ModelGroups(list).areAllSvn();
        }
        return false;
    }
}

