/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.cms.engine;

import com.modeliosoft.modelio.cms.api.CmsException;
import com.modeliosoft.modelio.cms.api.IAddCommand;
import com.modeliosoft.modelio.cms.api.ICommitCommand;
import com.modeliosoft.modelio.cms.api.ICommitResult;
import com.modeliosoft.modelio.cms.api.ISymbolService;
import com.modeliosoft.modelio.cms.api.ModelChangesLoadingFailedException;
import com.modeliosoft.modelio.cms.api.OutdatedElementsException;
import com.modeliosoft.modelio.cms.api.ReverseFailedException;
import com.modeliosoft.modelio.cms.driver.CmsDriverException;
import com.modeliosoft.modelio.cms.driver.ICmsDriver;
import com.modeliosoft.modelio.cms.driver.ICmsStatus;
import com.modeliosoft.modelio.cms.engine.ICmsEngine;
import com.modeliosoft.modelio.cms.engine.IModelChangeKeeperFactory;
import com.modeliosoft.modelio.cms.engine.recorder.ModelChangeKeeper;
import com.modeliosoft.modelio.cms.repository.CmsVersionedRepository;
import com.modeliosoft.modelio.cms.utils.CmsNodeUtils;
import com.modeliosoft.modelio.gproject.svn.fragment.recorder.RemovalRecorder;
import com.modeliosoft.modelio.gproject.svn.plugin.ProjectSvn;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.modelio.vbasic.log.Log;
import org.modelio.vbasic.progress.IModelioProgress;
import org.modelio.vcore.session.api.model.change.ChangeCause;
import org.modelio.vcore.session.api.model.change.IElementMovedEvent;
import org.modelio.vcore.session.api.model.change.IModelChangeEvent;
import org.modelio.vcore.session.api.model.change.IModelChangeHandler;
import org.modelio.vcore.session.api.model.change.IModelChangeListener;
import org.modelio.vcore.session.api.repository.IRepository;
import org.modelio.vcore.smkernel.SmObjectImpl;
import org.modelio.vcore.smkernel.mapi.MObject;
import org.modelio.vcore.smkernel.mapi.MRef;
import org.modelio.vcore.smkernel.mapi.MStatus;

class ModelHandler
implements IModelChangeListener,
IModelChangeHandler {
    private boolean handleModelChangeCalled = false;
    public static final boolean TRACE = false;
    private static Action[][] moveActionsTable = new Action[][]{{Action.Nothing, Action.Nothing, Action.Nothing, Action.Nothing, Action.Nothing}, {Action.Nothing, Action.Nothing, Action.Nothing, Action.Nothing, Action.Nothing}, {Action.Error, Action.Error, Action.Error, Action.Error, Action.Error}, {Action.Record, Action.Record, Action.Error, Action.Record, Action.Record}, {Action.Record, Action.Record, Action.Record, Action.Record, Action.Record}};
    private IModelChangeKeeperFactory changesKeeperFactory;
    private ICmsEngine engine;
    private ISymbolService symb;

    public ModelHandler(IModelChangeKeeperFactory changesKeeperFactory, ICmsEngine engine) {
        this.changesKeeperFactory = changesKeeperFactory;
        this.engine = engine;
    }

    public void handleModelChange(IModelChangeEvent event) {
        this.handleModelChangeCalled = true;
        this.handleCreatedElementsState(event.getCreationEvents());
        this.recordChanges(event);
    }

    public void modelChanged(IModelChangeEvent event) {
        if (this.handleModelChangeCalled) {
            this.handleModelChangeCalled = false;
        } else {
            this.recordChanges(event);
        }
        try {
            ModelChangeKeeper changeKeeper = this.changesKeeperFactory.getModelChangeKeeper();
            changeKeeper.save();
        }
        catch (IOException e) {
            this.engine.getHook().onModelChangeKeeperError(new ModelChangesLoadingFailedException((Throwable)e, "", 0));
            ProjectSvn.LOG.error(e);
        }
        this.handleDeletedRoots(event);
    }

    private static State getState(MStatus s) {
        if (s.isCmsToAdd()) {
            return State.CMS_ADDED;
        }
        if (s.isCmsToDelete()) {
            return State.CMS_DELETED;
        }
        if (!s.isCmsManaged()) {
            return State.NON_VERSIONED;
        }
        if (s.isCmsReadOnly()) {
            return State.CHECKIN;
        }
        return State.CHECKOUT;
    }

    private boolean recordChanges(IModelChangeEvent event) {
        if (!(event.getMoveEvents().isEmpty() && event.getDeleteEvents().isEmpty() && event.getCreationEvents().isEmpty())) {
            ModelChangeKeeper changeKeeper = this.changesKeeperFactory.getModelChangeKeeper();
            this.symb = this.changesKeeperFactory.createSymbolService();
            for (IElementMovedEvent ev : event.getMoveEvents()) {
                this.recordMove(changeKeeper, event, ev);
            }
            for (IElementMovedEvent ev : event.getDeleteEvents()) {
                MObject deleted = ev.getDeletedElement();
                changeKeeper.recordDeleted(deleted, CmsNodeUtils.getCmsNode(ev.getOldParent()));
                for (MObject child : CmsNodeUtils.getAllChildren(Collections.singleton(deleted))) {
                    changeKeeper.recordDeleted(child, CmsNodeUtils.getParentCmsNode(child));
                }
            }
            for (MObject createdEl : event.getCreationEvents()) {
                if (!createdEl.getMClass().isCmsNode()) continue;
                changeKeeper.removeDeleted(new MRef(createdEl), true);
            }
            for (MObject child : CmsNodeUtils.getAllChildren(event.getCreationEvents())) {
                changeKeeper.removeDeleted(new MRef(child), true);
            }
            return true;
        }
        return false;
    }

    private void handleCreatedElementsState(Set<MObject> creationEvents) {
        HashSet<MObject> elementsToAdd = new HashSet<MObject>();
        for (MObject newEl : creationEvents) {
            MObject parent;
            if (!newEl.getMClass().isCmsNode() || (parent = CmsNodeUtils.getParentCmsNode(newEl)) == null) continue;
            MStatus parentStatus = parent.getStatus();
            if (parentStatus.isCmsManaged()) {
                if (parentStatus.isCmsReadOnly()) continue;
                elementsToAdd.add(newEl);
                continue;
            }
            if (!parentStatus.isCmsToAdd()) continue;
            elementsToAdd.add(newEl);
        }
        if (!elementsToAdd.isEmpty()) {
            try {
                IAddCommand cmd = this.engine.createAddCommand();
                cmd.addElements(elementsToAdd);
                cmd.execute(null);
            }
            catch (IllegalStateException illegalStateException) {
            }
            catch (CmsException e) {
                ProjectSvn.LOG.warning(e);
            }
        }
    }

    private void recordMove(ModelChangeKeeper changeKeeper, IModelChangeEvent event, IElementMovedEvent ev) {
        MObject oldStateHolder;
        MObject moved = ev.getMovedElement();
        MObject oldCmsParent = CmsNodeUtils.getCmsNode(ev.getOldParent());
        MObject newCmsParent = CmsNodeUtils.getCmsNode(ev.getNewParent());
        boolean isMovedCmsNode = moved.getMClass().isCmsNode();
        MObject mObject = oldStateHolder = isMovedCmsNode ? moved : oldCmsParent;
        if (oldStateHolder == null) {
            oldStateHolder = event.getDeleteEvents().stream().filter(v -> v.getDeletedElement().equals(ev.getOldParent())).map(v -> v.getOldParent()).findFirst().orElse(null);
        }
        if (oldStateHolder == null) {
            ProjectSvn.LOG.info("trace: MObject move detected:");
            ProjectSvn.LOG.info("trace:  moved : " + this.symb.getFullName(moved) + " " + ModelHandler.getMClassName(moved));
            ProjectSvn.LOG.info("trace:  from : " + this.symb.getFullName(ev.getOldParent()) + " " + ModelHandler.getMClassName(ev.getOldParent()) + " (" + this.symb.getFullName(oldCmsParent) + ")");
            ProjectSvn.LOG.info("trace:  to : " + this.symb.getFullName(ev.getNewParent()) + " " + ModelHandler.getMClassName(ev.getNewParent()) + " (" + this.symb.getFullName(newCmsParent) + ")");
        }
        if (newCmsParent == null) {
            ProjectSvn.LOG.warning("Suspicious element move detected:");
            ProjectSvn.LOG.warning("  moved : " + this.symb.getFullName(moved) + " " + ModelHandler.getMClassName(moved));
            ProjectSvn.LOG.warning("  from : " + this.symb.getFullName(ev.getOldParent()) + " " + ModelHandler.getMClassName(ev.getOldParent()) + " (" + this.symb.getFullName(oldCmsParent) + ")");
            ProjectSvn.LOG.warning("  to : " + this.symb.getFullName(ev.getNewParent()) + " " + ModelHandler.getMClassName(ev.getNewParent()) + " (owned by no CMS node)");
        } else if (oldCmsParent == null || !oldCmsParent.equals(newCmsParent)) {
            State newParentState = ModelHandler.getState(newCmsParent.getStatus());
            State movedOldState = this.getState((SmObjectImpl)oldStateHolder, (SmObjectImpl)oldCmsParent);
            Action action = moveActionsTable[movedOldState.ordinal()][newParentState.ordinal()];
            if (action == Action.Nothing && changeKeeper.hasMoved(new MRef(moved))) {
                action = Action.Record;
            }
            switch (action) {
                case Nothing: {
                    break;
                }
                case Record: {
                    changeKeeper.recordMove(moved, oldCmsParent, newCmsParent);
                    break;
                }
                default: {
                    assert (false) : action;
                    break;
                }
            }
        }
    }

    private static String getMClassName(MObject obj) {
        if (obj != null) {
            return obj.getMClass().getName();
        }
        return "";
    }

    private Collection<String> getBlobs(MObject o) {
        return this.engine.getCoreSession().getBlobSupport().getRelatedBlobs(o);
    }

    private State getState(SmObjectImpl cmsNode, SmObjectImpl oldCmsParent) {
        if (oldCmsParent == null || cmsNode.getRepositoryObject().getRepositoryId() == oldCmsParent.getRepositoryObject().getRepositoryId()) {
            return ModelHandler.getState(cmsNode.getStatus());
        }
        CmsVersionedRepository initialRepo = RemovalRecorder.get(this.engine.getProject()).getInitialRepository(new MRef((MObject)cmsNode));
        if (initialRepo != null) {
            return this.getState(cmsNode, (IRepository)initialRepo);
        }
        IRepository cmsNodeRepo = this.engine.getCoreSession().getRepositorySupport().getRepository((MObject)cmsNode);
        return this.getState(cmsNode, cmsNodeRepo);
    }

    private State getState(SmObjectImpl cmsNode, IRepository repository) {
        if (!(repository instanceof CmsVersionedRepository)) {
            return State.NON_VERSIONED;
        }
        CmsVersionedRepository cmsRepo = (CmsVersionedRepository)repository;
        ICmsDriver driver = cmsRepo.getDriver();
        try {
            ICmsStatus cmsStat = driver.getStatusDriver().getStatus(driver.getFilesGeometry().getExmlFile((MObject)cmsNode), false);
            if (cmsStat.isToAdd()) {
                return State.CMS_ADDED;
            }
            if (!cmsStat.isVersioned()) {
                return State.NON_VERSIONED;
            }
            if (cmsStat.isSelfLocked() || !cmsStat.isLockingNeeded()) {
                return State.CHECKOUT;
            }
            if (cmsStat.isToDelete()) {
                return State.CMS_DELETED;
            }
            return State.CHECKIN;
        }
        catch (CmsDriverException e) {
            IOException ex = new IOException("Failed reading CMS state of " + String.valueOf(cmsNode) + ": " + e.getLocalizedMessage(), (Throwable)((Object)e));
            Log.error((Throwable)ex);
            repository.getErrorSupport().fireWarning((Throwable)ex);
            return State.CHECKOUT;
        }
    }

    private void handleDeletedRoots(IModelChangeEvent event) {
        Set deletedRoots = event.getRootDeletionEvents();
        if (!deletedRoots.isEmpty() && event.getCause() == ChangeCause.TRANSACTION) {
            ArrayList<MObject> toCmsRemove = new ArrayList<MObject>();
            for (MObject o : deletedRoots) {
                MStatus status = o.getStatus();
                if (!status.isCmsManaged() && !status.isCmsToDelete()) continue;
                toCmsRemove.add(o);
            }
            if (!toCmsRemove.isEmpty()) {
                this.engine.getCoreSession().getTransactionSupport().asyncExec(() -> {
                    IModelioProgress monitor = null;
                    ICommitCommand commitCmd = this.engine.createCommitCommand();
                    try {
                        commitCmd.setKeepLocks(false);
                        commitCmd.setRecursive(true, monitor);
                        commitCmd.addElements(toCmsRemove, monitor);
                        commitCmd.setUseProcessExtension(false);
                        commitCmd.setBatch(true);
                        commitCmd.callPemPreCommit(monitor);
                        commitCmd.setBatch(false);
                        ICommitResult result = commitCmd.execute(monitor);
                        this.engine.getHook().postCommit(result);
                    }
                    catch (CmsException | OutdatedElementsException | ReverseFailedException e) {
                        Log.error((Throwable)e);
                        this.engine.getHook().postCommitFailed(commitCmd, (Exception)e);
                    }
                });
            }
        }
    }

    private static enum Action {
        Nothing,
        Record,
        Error;

    }

    private static enum State {
        NON_VERSIONED,
        CMS_ADDED,
        CHECKIN,
        CHECKOUT,
        CMS_DELETED;

    }
}

