/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.cms.engine;

import com.modeliosoft.modelio.cms.api.ISymbolService;
import java.util.HashMap;
import java.util.Map;
import org.modelio.metamodel.uml.infrastructure.AbstractProject;
import org.modelio.metamodel.uml.infrastructure.MetaclassReference;
import org.modelio.vcore.session.api.model.IModel;
import org.modelio.vcore.smkernel.mapi.MObject;
import org.modelio.vcore.smkernel.mapi.MRef;

public class SymbolService
implements ISymbolService {
    private Map<MRef, String> fullNameCache = new HashMap<MRef, String>();
    private Map<MRef, String> nameCache = new HashMap<MRef, String>();
    private IModel iModel;

    public SymbolService(IModel session) {
        this.iModel = session;
    }

    public void cacheSymbol(MRef ref) {
        this.getName(ref);
        this.getFullName(ref);
    }

    public String getFullName(MRef obRef) {
        Object ret = this.fullNameCache.get(obRef);
        if (ret != null) {
            return ret;
        }
        try {
            MObject el = this.findByRef(obRef);
            if (el != null) {
                return this.getFullName(el);
            }
            ret = "<deleted " + String.valueOf(obRef) + ">";
            this.fullNameCache.put(obRef, (String)ret);
            return ret;
        }
        catch (RuntimeException e) {
            return "<" + e.getLocalizedMessage() + ">";
        }
    }

    public String getFullName(MObject el) {
        if (el == null) {
            return "<none>";
        }
        MRef ref = new MRef(el);
        Object ret = this.fullNameCache.get(ref);
        if (ret != null) {
            return ret;
        }
        String name = this.getName(el);
        MObject parent = el.getCompositionOwner();
        ret = parent == null ? (el.isShell() ? "<" + (el.isShell() ? "unresolved" : "") + (el.isDeleted() ? " deleted" : "") + " " + String.valueOf(ref) + ">" : (SymbolService.isRoot(el) ? name : "<" + (el.isDeleted() ? " deleted" : "") + " orphan '" + name + "'>")) : (SymbolService.isRoot(parent) ? name : this.getFullName(parent) + "." + name);
        this.fullNameCache.put(ref, (String)ret);
        return ret;
    }

    public String getName(MObject el) {
        if (el == null) {
            return "<none>";
        }
        if (el instanceof MetaclassReference) {
            MetaclassReference ref = (MetaclassReference)el;
            return ref.getReferencedClassName();
        }
        return el.getName();
    }

    public String getName(MRef ref) {
        Object ret = this.nameCache.get(ref);
        if (ret != null) {
            return ret;
        }
        MObject el = this.findByRef(ref);
        ret = el != null ? this.getName(el) : "<deleted " + String.valueOf(ref) + ">";
        this.nameCache.put(ref, (String)ret);
        return ret;
    }

    private MObject findByRef(MRef ref) {
        try {
            return this.iModel.findByRef(ref);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    private static boolean isRoot(MObject element) {
        return element instanceof AbstractProject;
    }

    private static boolean isRootChild(MObject element) {
        MObject parent = element.getCompositionOwner();
        if (parent == null) {
            return SymbolService.isRoot(element);
        }
        return SymbolService.isRoot(parent);
    }
}

