/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.cms.engine;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Properties;
import org.modelio.vbasic.version.Version;

public class VersionInfo {
    private int mmVersion;
    private int wcFormat;
    private static final int LATEST_FORMAT = 30;
    private static final String PROP_MMVERSION = "VersionInfo.mm";
    private static final String PROP_WCVERSION = "VersionInfo.wc";
    private static final String PROP_MODELIOVERSION = "VersionInfo.modelio";
    private static final String PROP_MODULEVERSION = "VersionInfo.module";
    private Version modelioVersion;
    private Version moduleVersion;

    private VersionInfo() {
    }

    public int getMmVersion() {
        return this.mmVersion;
    }

    public int getWcFormat() {
        return this.wcFormat;
    }

    public Version getModelioVersion() {
        return this.modelioVersion;
    }

    public Version getModuleVersion() {
        return this.moduleVersion;
    }

    public static VersionInfo read(Path versionFile) throws IOException {
        Properties props = new Properties();
        if (Files.isRegularFile(versionFile, new LinkOption[0])) {
            Throwable throwable = null;
            Object var3_4 = null;
            try (InputStream is = Files.newInputStream(versionFile, new OpenOption[0]);){
                props.load(is);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        return VersionInfo.read(props);
    }

    public static VersionInfo read(Properties props) {
        VersionInfo ret = new VersionInfo();
        if (props.getProperty(PROP_WCVERSION) != null) {
            ret.mmVersion = Integer.parseInt(props.getProperty(PROP_MMVERSION));
            ret.wcFormat = Integer.parseInt(props.getProperty(PROP_WCVERSION));
            ret.modelioVersion = new Version(props.getProperty(PROP_MODELIOVERSION));
            String p = props.getProperty(PROP_MODULEVERSION);
            ret.moduleVersion = p == null ? null : new Version(p);
        } else {
            ret.mmVersion = 0;
            ret.wcFormat = 0;
            ret.modelioVersion = null;
            ret.moduleVersion = null;
        }
        return ret;
    }

    public void write(Path to) throws IOException {
        Properties props = new Properties();
        this.write(props);
        Throwable throwable = null;
        Object var4_5 = null;
        try (OutputStream os = Files.newOutputStream(to, new OpenOption[0]);){
            props.store(os, null);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void write(Properties to) {
        to.setProperty(PROP_WCVERSION, Integer.toString(this.wcFormat));
        to.setProperty(PROP_MMVERSION, Integer.toString(this.mmVersion));
        to.setProperty(PROP_MODELIOVERSION, this.modelioVersion.toString());
        to.setProperty(PROP_MODULEVERSION, this.moduleVersion.toString());
    }

    public boolean isNull() {
        return this.wcFormat == 0;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.mmVersion;
        result = 31 * result + (this.modelioVersion == null ? 0 : this.modelioVersion.hashCode());
        result = 31 * result + this.wcFormat;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VersionInfo other = (VersionInfo)obj;
        if (this.mmVersion != other.mmVersion) {
            return false;
        }
        if (this.modelioVersion == null ? other.modelioVersion != null : !this.modelioVersion.equals((Object)other.modelioVersion)) {
            return false;
        }
        return this.wcFormat == other.wcFormat;
    }

    public String toString() {
        return String.valueOf(this.modelioVersion) + "/" + String.valueOf(this.moduleVersion) + "/" + this.wcFormat;
    }

    public static Path getRepositoryVersionPath(Path workingCopyPath) {
        return workingCopyPath.resolve("admin").resolve("version.conf");
    }
}

