/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.cms.engine.commands.add;

import com.modeliosoft.modelio.cms.api.CmsException;
import com.modeliosoft.modelio.cms.api.IAddCommand;
import com.modeliosoft.modelio.cms.api.IAddResult;
import com.modeliosoft.modelio.cms.api.IGetLockCommand;
import com.modeliosoft.modelio.cms.api.contrib.IAddConfig;
import com.modeliosoft.modelio.cms.api.mmextension.ICmsDependencyAnalyser;
import com.modeliosoft.modelio.cms.driver.ICmsDriver;
import com.modeliosoft.modelio.cms.engine.ICmsEngine;
import com.modeliosoft.modelio.cms.engine.commands.add.AddResult;
import com.modeliosoft.modelio.cms.utils.CmsNodeUtils;
import com.modeliosoft.modelio.gproject.svn.plugin.ProjectSvn;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.modelio.vbasic.progress.IModelioProgress;
import org.modelio.vbasic.progress.SubProgress;
import org.modelio.vcore.model.filter.IObjectFilter;
import org.modelio.vcore.session.api.transactions.ITransaction;
import org.modelio.vcore.smkernel.SmObjectImpl;
import org.modelio.vcore.smkernel.StatusState;
import org.modelio.vcore.smkernel.mapi.MObject;
import org.modelio.vcore.smkernel.mapi.MStatus;
import org.modelio.vcore.smkernel.mapi.services.MetamodelExtensionPoint;
import org.modelio.vstore.exml.common.ExmlStorageHandler;

public class AddCommand
implements IAddCommand,
IAddConfig {
    private boolean useProcessModel = true;
    private boolean batchMode = true;
    private final ICmsEngine engine;
    private final Collection<MObject> elementsToAdd = new ArrayList<MObject>();
    private final Map<File, Map<String, String>> filesToAdd = new HashMap<File, Map<String, String>>();
    private final MetamodelExtensionPoint<ICmsDependencyAnalyser> depAnalyserMmExt;

    public AddCommand(ICmsEngine engine) {
        this.engine = engine;
        this.engine.getCoreSession();
        this.depAnalyserMmExt = this.engine.getMetamodelExtensions().getDependencyAnalyser();
    }

    protected IAddResult doExecute(IModelioProgress iMonitor) throws CmsException, IllegalStateException {
        HashSet<MObject> filteredRoots = new HashSet<MObject>(this.elementsToAdd);
        MObject[] mObjectArray = this.elementsToAdd.toArray(new MObject[this.elementsToAdd.size()]);
        int n = mObjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            MObject rootToAdd = mObjectArray[n2];
            MStatus elementStatus = rootToAdd.getStatus();
            if (elementStatus.isRamc() || elementStatus.isCmsManaged()) {
                filteredRoots.remove(rootToAdd);
            }
            ++n2;
        }
        ArrayList<MObject> parentsToLock = new ArrayList<MObject>(filteredRoots.size());
        ArrayList<MObject> toAdd = new ArrayList<MObject>(filteredRoots.size());
        DepGraph depGraph = new DepGraph();
        this.computeDependencies(filteredRoots, parentsToLock, toAdd, depGraph);
        AddResult result = new AddResult(this.engine.createSymbolService(), this.isBatchMode());
        if (!parentsToLock.isEmpty()) {
            IGetLockCommand command = this.engine.createGetLockCommand();
            command.setRecursive(false);
            command.addElements(parentsToLock);
            command.setBatch(true);
            result.setLockResult(command.execute(iMonitor));
        }
        Throwable throwable = null;
        Object var8_11 = null;
        try (ITransaction t = this.engine.getCoreSession().getTransactionSupport().createTransaction("Add " + toAdd.size() + " elements to version");){
            for (MObject mObject : toAdd) {
                if (!mObject.isValid()) continue;
                boolean addable = this.isAddable(mObject, depGraph);
                if (addable) {
                    SmObjectImpl smObj = (SmObjectImpl)mObject;
                    if (smObj.getData().hasAllStatus(0x2000000000L) == StatusState.TRUE) {
                        smObj.setRStatus(0L, 0x2000000000L, 0L);
                        this.setDirty(smObj);
                        result.undeleted.add(mObject);
                    } else {
                        smObj.setRStatus(0x1000000000L, 0L, 0L);
                        this.setDirty(smObj);
                        result.added.add(mObject);
                    }
                    MObject parent = CmsNodeUtils.getParentCmsNode(mObject);
                    if (parent == null) continue;
                    SmObjectImpl smParent = (SmObjectImpl)parent;
                    smParent.setRStatus(0x800000000L, 0L, 0L);
                    this.setDirty(smParent);
                    continue;
                }
                result.notAdded.add(mObject);
            }
            for (Map.Entry entry : this.filesToAdd.entrySet()) {
                File f = (File)entry.getKey();
                ICmsDriver cmsDriver = this.engine.getCmsDriver(f);
                if (entry.getValue() != null) {
                    cmsDriver.addFile(f, (Map)entry.getValue());
                    continue;
                }
                cmsDriver.addFile(f);
            }
            t.commit();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return result;
    }

    public void addElements(Collection<MObject> toAdd) {
        this.elementsToAdd.addAll(toAdd);
    }

    public Collection<MObject> getElements() {
        return this.elementsToAdd;
    }

    private void computeDependencies(Collection<MObject> selectedRoots, Collection<MObject> parentsToLock, Collection<MObject> toAdd, DepGraph depGraph) {
        SelectNonVersionedFilter nonVersionedFilter = new SelectNonVersionedFilter();
        for (MObject aRoot : selectedRoots) {
            boolean isRootParentToLock;
            toAdd.add(aRoot);
            MObject rootParent = CmsNodeUtils.getParentCmsNode(aRoot);
            if (rootParent != null) {
                MStatus rootParentStatus = rootParent.getStatus();
                boolean bl = isRootParentToLock = rootParentStatus.isCmsManaged() && rootParentStatus.isCmsReadOnly();
                if (isRootParentToLock) {
                    parentsToLock.add(rootParent);
                    depGraph.add(aRoot, rootParent);
                }
            } else {
                isRootParentToLock = false;
            }
            Set<MObject> allChildren = CmsNodeUtils.collectAll(Collections.singleton(aRoot), nonVersionedFilter, o -> CmsNodeUtils.getChildren(o), this::getMetamodelDependencies);
            for (MObject child : allChildren) {
                MObject parentNode;
                MStatus parentStatus;
                toAdd.add(child);
                if (isRootParentToLock) {
                    depGraph.add(child, rootParent);
                }
                if (!(parentStatus = (parentNode = CmsNodeUtils.getParentCmsNode(child)).getStatus()).isCmsManaged() || !parentStatus.isCmsReadOnly()) continue;
                parentsToLock.add(parentNode);
                depGraph.add(child, parentNode);
            }
        }
    }

    private void setDirty(SmObjectImpl smObj) {
        ((ExmlStorageHandler)smObj.getRepositoryObject()).setDirty(true);
    }

    private boolean isAddable(MObject toTest, DepGraph depGraph) {
        for (MObject dep : depGraph.get(toTest)) {
            MStatus depStatus = dep.getStatus();
            if (!depStatus.isCmsReadOnly() && (depStatus.isCmsManaged() || depStatus.isCmsToAdd() || depGraph.get(dep) != null && this.isAddable(dep, depGraph))) continue;
            return false;
        }
        return true;
    }

    public IAddResult execute(IModelioProgress iMonitor) throws CmsException, IllegalStateException {
        if (!this.useProcessExtension()) {
            return this.doExecute(iMonitor);
        }
        SubProgress monitor = SubProgress.convert((IModelioProgress)iMonitor, (String)ProjectSvn.I18N.getString("Monitor.Add"), (int)4);
        if (!this.engine.getHook().preAdd((IModelioProgress)monitor.newChild(1), (IAddCommand)this)) {
            return null;
        }
        try {
            IAddResult result = this.doExecute((IModelioProgress)monitor);
            this.engine.getHook().postAdd(result);
            return result;
        }
        catch (CmsException | RuntimeException e) {
            this.engine.getHook().postAddFailed((IAddCommand)this, (Exception)e);
            throw e;
        }
    }

    public IAddConfig getConfiguration() {
        return this;
    }

    public void addFiles(Collection<File> files) {
        for (File f : files) {
            this.filesToAdd.put(f, null);
        }
    }

    public void setUseProcessExtension(boolean val) {
        this.useProcessModel = val;
    }

    public boolean useProcessExtension() {
        return this.useProcessModel;
    }

    public void setBatch(boolean batchMode) {
        this.batchMode = batchMode;
    }

    public boolean isBatchMode() {
        return this.batchMode;
    }

    public void addFiles(Collection<File> files, Map<String, String> cmsProps) {
        HashMap<String, String> propsCopy = new HashMap<String, String>(cmsProps);
        for (File f : files) {
            this.filesToAdd.put(f, propsCopy);
        }
    }

    private Collection<? extends MObject> getMetamodelDependencies(MObject el) {
        ICmsDependencyAnalyser svc = (ICmsDependencyAnalyser)this.depAnalyserMmExt.findService(el.getMClass());
        if (svc == null) {
            return CmsNodeUtils.getAutomaticChildren(el);
        }
        return svc.getAddToVersionDependencies(el, true);
    }

    public void addElement(MObject toAdd) {
        this.elementsToAdd.add(toAdd);
    }

    private static class DepGraph {
        private HashMap<MObject, ArrayList<MObject>> map = new HashMap();

        public void add(MObject node, MObject dep) {
            ArrayList<Object> a = this.map.get(node);
            if (a == null) {
                a = new ArrayList();
                this.map.put(node, a);
            }
            a.add(dep);
        }

        public List<MObject> get(MObject node) {
            ArrayList<MObject> a = this.map.get(node);
            if (a == null) {
                return Collections.emptyList();
            }
            return a;
        }
    }

    private static final class SelectNonVersionedFilter
    implements IObjectFilter,
    Predicate<MObject> {
        public boolean accept(MObject e) {
            MStatus elementStatus = e.getStatus();
            if (elementStatus.isRamc()) {
                return false;
            }
            if (!elementStatus.isCmsManaged()) {
                return true;
            }
            return elementStatus.isCmsToDelete();
        }

        @Override
        public boolean test(MObject t) {
            return this.accept(t);
        }
    }
}

