/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.cms.engine.commands.add;

import com.modeliosoft.modelio.cms.api.CmsException;
import com.modeliosoft.modelio.cms.api.ICancelAddCommand;
import com.modeliosoft.modelio.cms.api.mmextension.ICmsDependencyAnalyser;
import com.modeliosoft.modelio.cms.driver.CmsDriverException;
import com.modeliosoft.modelio.cms.driver.ICmsDriver;
import com.modeliosoft.modelio.cms.driver.ICmsStatus;
import com.modeliosoft.modelio.cms.model.ModelGroup;
import com.modeliosoft.modelio.cms.model.ModelGroups;
import com.modeliosoft.modelio.cms.utils.CmsNodeUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.function.Predicate;
import org.modelio.vbasic.progress.IModelioProgress;
import org.modelio.vbasic.progress.SubProgress;
import org.modelio.vcore.session.api.transactions.ITransaction;
import org.modelio.vcore.smkernel.SmObjectImpl;
import org.modelio.vcore.smkernel.mapi.MObject;
import org.modelio.vcore.smkernel.mapi.MRef;
import org.modelio.vcore.smkernel.mapi.MStatus;
import org.modelio.vcore.smkernel.mapi.services.MetamodelExtensionPoint;

public class CancelAddCommand
implements ICancelAddCommand {
    private Collection<MObject> elementsToCancel = new ArrayList<MObject>();
    private final MetamodelExtensionPoint<ICmsDependencyAnalyser> depAnalyserMmExt;

    public void addElements(Collection<MObject> toCancel) {
        this.elementsToCancel.addAll(toCancel);
    }

    public Collection<MObject> getElements() {
        return this.elementsToCancel;
    }

    public boolean canExecute() {
        ModelGroups sel = new ModelGroups(this.elementsToCancel);
        return sel.areAllSvn();
    }

    public void execute(IModelioProgress iMonitor) throws CmsException {
        ModelGroups sel = new ModelGroups(this.elementsToCancel);
        SubProgress mainMon = SubProgress.convert((IModelioProgress)iMonitor, (int)sel.getGroups().size());
        sel.assertAllSvn();
        Predicate<MObject> isToCancelFilter = new Predicate<MObject>(){

            @Override
            public boolean test(MObject e) {
                MStatus elementStatus = e.getStatus();
                return elementStatus.isCmsToAdd() || elementStatus.isCmsManaged();
            }
        };
        for (ModelGroup group : sel) {
            Collection<File> files;
            SubProgress mon = mainMon.newChild(1);
            ICmsDriver cmsDriver = group.getSvnFragment().getCmsDriver();
            ArrayList<MRef> toRevert = new ArrayList<MRef>(group.getElements().size() * 2);
            ArrayList<MObject> nonVersioned = new ArrayList<MObject>(group.getElements().size() * 2);
            ArrayList<MObject> toRemove = new ArrayList<MObject>(group.getElements().size());
            for (MObject el : group.getElements()) {
                if (this.isFileToAdd(cmsDriver, el)) {
                    toRevert.add(new MRef(el));
                } else {
                    nonVersioned.add(el);
                }
                Set<MObject> allChildren = CmsNodeUtils.collectAll(Collections.singleton(el), isToCancelFilter, o -> CmsNodeUtils.getChildren(o), this::getMetamodelDependencies);
                Iterator iterator = allChildren.iterator();
                while (iterator.hasNext()) {
                    MObject c = (MObject)iterator.next();
                    MStatus elementStatus = c.getStatus();
                    if (elementStatus.isCmsToAdd()) {
                        if (this.isFileToAdd(cmsDriver, c)) {
                            toRevert.add(new MRef(c));
                            continue;
                        }
                        nonVersioned.add(c);
                        continue;
                    }
                    if (elementStatus.isCmsToDelete()) continue;
                    toRemove.add(c);
                }
            }
            if (!toRevert.isEmpty()) {
                mon.setWorkRemaining(2);
                files = cmsDriver.getFilesGetter().getRelatedRefFiles(toRevert);
                cmsDriver.revert((IModelioProgress)mon.newChild(1), files);
            }
            if (!toRemove.isEmpty()) {
                mon.setWorkRemaining(2);
                files = cmsDriver.getFilesGetter().getRelatedFiles(toRemove);
                cmsDriver.delete((IModelioProgress)mon.newChild(1), files);
                for (MObject o2 : toRemove) {
                    ((SmObjectImpl)o2).setRStatus(0x2000000000L, 0x1000000000L, 0L);
                }
            }
            if (nonVersioned.isEmpty()) continue;
            Throwable throwable = null;
            Iterator<MObject> iterator = null;
            try (ITransaction t = group.getSvnFragment().getProject().getSession().getTransactionSupport().createTransaction("Remove 'add to version' flag on " + nonVersioned.size() + " elements");){
                for (MObject o3 : nonVersioned) {
                    ((SmObjectImpl)o3).setRStatus(0L, 0x1000000000L, 0L);
                    SmObjectImpl parent = (SmObjectImpl)CmsNodeUtils.getParentCmsNode(o3);
                    long oldFlags = parent.getSmStatusFlags();
                    parent.setRStatus(0x800000000L, 0L, 0L);
                    parent.getRepositoryObject().attModified(parent, parent.getClassOf().statusAtt(), (Object)oldFlags);
                }
                t.commit();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        iMonitor.done();
    }

    private boolean isFileToAdd(ICmsDriver cmsDriver, MObject o) throws CmsDriverException {
        File f = cmsDriver.getFilesGeometry().getExmlFile(o);
        ICmsStatus status = cmsDriver.getStatusDriver().getStatus(f, false);
        return status != null && status.isToAdd();
    }

    public CancelAddCommand(MetamodelExtensionPoint<ICmsDependencyAnalyser> depAnalyserMmExt) {
        this.depAnalyserMmExt = depAnalyserMmExt;
    }

    private Collection<? extends MObject> getMetamodelDependencies(MObject el) {
        ICmsDependencyAnalyser svc = (ICmsDependencyAnalyser)this.depAnalyserMmExt.findService(el.getMClass());
        if (svc == null) {
            return CmsNodeUtils.getAutomaticChildren(el);
        }
        return svc.getAddToVersionDependencies(el, true);
    }

    public void addElement(MObject toCancel) {
        this.elementsToCancel.add(toCancel);
    }
}

