/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.cms.engine.commands.admin;

import com.modeliosoft.modelio.cms.api.CmsException;
import com.modeliosoft.modelio.cms.api.admin.IConnectDirToRepositoryCommand;
import com.modeliosoft.modelio.cms.model.ModelGroup;
import com.modeliosoft.modelio.cms.model.ModelGroups;
import com.modeliosoft.modelio.gproject.svn.plugin.ProjectSvn;
import java.io.File;
import java.util.Collections;
import org.modelio.vbasic.auth.IAuthData;
import org.modelio.vbasic.progress.IModelioProgress;
import org.modelio.vbasic.progress.SubProgress;
import org.modelio.vcore.smkernel.mapi.MObject;

public class ConnectDirToRepositoryCommand
implements IConnectDirToRepositoryCommand {
    private String url;
    private File dir;
    private MObject element;
    private IAuthData authData;

    public void setDirectory(File dir) {
        this.dir = dir;
    }

    public void setRepositoryUrl(String url) {
        this.url = url;
    }

    public void setElement(MObject element) {
        this.element = element;
    }

    public void execute(IModelioProgress monitor) throws CmsException {
        ModelGroups sel = ModelGroups.makeSvnGroups(Collections.singleton(this.element));
        String taskName = ProjectSvn.I18N.getMessage("Monitor.Connect", new Object[]{sel.size()});
        SubProgress mon = SubProgress.convert((IModelioProgress)monitor, (String)taskName, (int)sel.size());
        for (ModelGroup group : sel) {
            taskName = ProjectSvn.I18N.getMessage("Monitor.Connect.frag", new Object[]{group.getFragment().getId()});
            mon.setTaskName(taskName);
            mon.subTask(taskName);
            group.getSvnFragment().getCmsDriver().checkout(this.url, this.dir, this.getAuthData(), (IModelioProgress)mon.newChild(1));
        }
    }

    public IAuthData getAuthData() {
        return this.authData;
    }

    public void setAuthData(IAuthData authData) {
        this.authData = authData;
    }
}

