/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.cms.engine.commands.branch;

import com.modeliosoft.modelio.cms.api.CmsException;
import com.modeliosoft.modelio.cms.api.admin.ICreateBranchCommand;
import com.modeliosoft.modelio.cms.driver.ICmsDriver;
import com.modeliosoft.modelio.cms.engine.ICmsEngine;
import com.modeliosoft.modelio.cms.model.ModelGroups;
import com.modeliosoft.modelio.gproject.svn.fragment.GSvnFragment;
import java.util.ArrayList;
import java.util.Collection;
import org.modelio.gproject.core.IGModelFragment;
import org.modelio.vbasic.progress.IModelioProgress;
import org.modelio.vcore.smkernel.mapi.MObject;

public class CreateBranchCommand
implements ICreateBranchCommand {
    private String commitMessage;
    private String branchSpec;
    private ICmsEngine cmsEngine;
    private Collection<MObject> selectedElements = new ArrayList<MObject>();

    public CreateBranchCommand(ICmsEngine cmsEngine) {
        this.cmsEngine = cmsEngine;
    }

    public ICreateBranchCommand addElement(MObject el) {
        this.selectedElements.add(el);
        return this;
    }

    public ICreateBranchCommand setBranchSpec(String tagSpec) {
        this.branchSpec = tagSpec;
        return this;
    }

    public ICreateBranchCommand setFragment(IGModelFragment fragment) {
        this.selectedElements.clear();
        this.selectedElements.addAll(fragment.getRoots());
        return this;
    }

    public ICreateBranchCommand setCommitMessage(String commitMessage) {
        this.commitMessage = commitMessage;
        return this;
    }

    public void execute(IModelioProgress monitor) throws CmsException {
        ModelGroups sel = new ModelGroups(this.selectedElements);
        sel.assertAllSvn();
        sel.assertSingle();
        GSvnFragment fragment = sel.first().getSvnFragment();
        ICmsDriver driver = fragment.getCmsDriver();
        driver.createBranch(this.branchSpec, this.commitMessage);
    }
}

