/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.cms.engine.commands.commit;

import com.modeliosoft.modelio.cms.api.ICodeReverser;
import com.modeliosoft.modelio.cms.api.ReverseFailedException;
import com.modeliosoft.modelio.cms.engine.commands.commit.RichNoteReverser;
import com.modeliosoft.modelio.gproject.svn.plugin.ProjectSvn;
import java.util.ArrayList;
import java.util.List;
import org.modelio.vcore.smkernel.mapi.MObject;

public class CodeReversers
implements ICodeReverser {
    private List<ICodeReverser> reversers = new ArrayList<ICodeReverser>();

    public CodeReversers() {
        this.addReverser(new RichNoteReverser());
    }

    public void addReverser(ICodeReverser reverser) throws IllegalArgumentException {
        if (reverser == null) {
            throw new IllegalArgumentException("reverser must not be null.");
        }
        this.reversers.add(reverser);
    }

    public void removeReverser(ICodeReverser reverser) throws IllegalArgumentException {
        if (reverser == null) {
            throw new IllegalArgumentException("reverser must not be null.");
        }
        this.reversers.remove(reverser);
    }

    public void beginReverseSession() throws RuntimeException {
        for (ICodeReverser reverser : this.reversers) {
            reverser.beginReverseSession();
        }
    }

    public void endReverseSession() {
        for (ICodeReverser reverser : this.reversers) {
            try {
                reverser.endReverseSession();
            }
            catch (RuntimeException e) {
                ProjectSvn.LOG.warning(e);
            }
        }
    }

    public void reverseCode(MObject cmsNode) throws ReverseFailedException {
        try {
            for (ICodeReverser reverser : this.reversers) {
                reverser.reverseCode(cmsNode);
            }
        }
        catch (ReverseFailedException e) {
            if (e.getFailureLocation() == null) {
                e.setFailureLocation(cmsNode);
            }
            throw e;
        }
        catch (RuntimeException e) {
            throw new ReverseFailedException((Throwable)e).setFailureLocation(cmsNode);
        }
        catch (LinkageError e) {
            throw new ReverseFailedException((Throwable)e).setFailureLocation(cmsNode);
        }
    }
}

