/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.cms.engine.commands.commit;

import com.modeliosoft.modelio.cms.api.ICommitDetailFragment;
import com.modeliosoft.modelio.cms.driver.CmsDriverException;
import com.modeliosoft.modelio.cms.driver.ICmsDriver;
import com.modeliosoft.modelio.cms.driver.ICmsStatus;
import com.modeliosoft.modelio.cms.engine.commands.commit.CommitConfigFragment;
import com.modeliosoft.modelio.cms.engine.commands.commit.CommitConfiguration;
import com.modeliosoft.modelio.cms.engine.recorder.AssociatedFileChangeRecorder;
import com.modeliosoft.modelio.gproject.svn.fragment.GSvnFragment;
import java.io.File;
import java.util.Map;
import org.modelio.vcore.smkernel.mapi.MObject;
import org.modelio.vcore.smkernel.mapi.MRef;

class CommitAssociatedFilesAnalyser {
    private AssociatedFileChangeRecorder recorder;

    public CommitAssociatedFilesAnalyser(AssociatedFileChangeRecorder recorder) {
        this.recorder = recorder;
    }

    public void run(CommitConfiguration conf) throws CmsDriverException {
        for (final CommitConfigFragment fragDetail : conf.getFragments()) {
            MRef ref;
            AssociatedFileChangeRecorder.MoveHandler creationHandler = new AssociatedFileChangeRecorder.MoveHandler(){

                @Override
                public void handle(MRef ref, String key, File oldFile, File newFile) throws CmsDriverException {
                    CommitAssociatedFilesAnalyser.this.addToDeleted(ref, fragDetail, key, oldFile);
                    CommitAssociatedFilesAnalyser.this.addCreatedOrModified(ref, fragDetail, key, newFile);
                }
            };
            AssociatedFileChangeRecorder.MoveHandler deletionHandler = new AssociatedFileChangeRecorder.MoveHandler(){

                @Override
                public void handle(MRef ref, String key, File oldFile, File newFile) throws CmsDriverException {
                    CommitAssociatedFilesAnalyser.this.addToDeleted(ref, fragDetail, key, oldFile);
                }
            };
            for (MObject obj : fragDetail.getCreatedElements()) {
                ref = new MRef(obj);
                this.addToDeleted(ref, this.recorder.getAllFileDeletions(ref), fragDetail);
                this.addToCreatedOrModified(ref, this.recorder.getAllFileModifs(ref), fragDetail);
                this.recorder.forAllFileMoves(ref, creationHandler);
            }
            for (MRef ref2 : fragDetail.getDeletedElements()) {
                this.addToDeleted(ref2, this.recorder.getAllFileDeletions(ref2), fragDetail);
                this.recorder.forAllFileMoves(ref2, deletionHandler);
            }
            for (MObject obj : fragDetail.getModifiedElements()) {
                ref = new MRef(obj);
                this.addToDeleted(ref, this.recorder.getAllFileDeletions(ref), fragDetail);
                this.addToCreatedOrModified(ref, this.recorder.getAllFileModifs(ref), fragDetail);
                fragDetail.addMovedAssociated(this.recorder.getAllFileMoves(ref));
            }
        }
    }

    private void addToDeleted(MRef ref, Map<String, File> m, CommitConfigFragment conf) throws CmsDriverException {
        for (Map.Entry<String, File> entry : m.entrySet()) {
            this.addToDeleted(ref, conf, entry.getKey(), entry.getValue());
        }
    }

    private void addToCreatedOrModified(MRef ref, Map<String, File> m, CommitConfigFragment conf) throws CmsDriverException {
        for (Map.Entry<String, File> entry : m.entrySet()) {
            this.addCreatedOrModified(ref, conf, entry.getKey(), entry.getValue());
        }
    }

    protected void addCreatedOrModified(MRef ref, CommitConfigFragment conf, String key, File file) throws CmsDriverException {
        ICmsDriver cmsDriver = ((GSvnFragment)conf.getProjectFragment()).getCmsDriver();
        ICmsStatus st = cmsDriver.getStatusDriver().getStatus(file, false);
        if (st == null || st.isToAdd() || !st.isVersioned()) {
            conf.addCreatedAssociated(ref, key, file);
        } else {
            conf.addModifiedAssociated(ref, key, file);
        }
    }

    protected void addToDeleted(MRef ref, CommitConfigFragment conf, String key, File file) throws CmsDriverException {
        ICmsDriver cmsDriver = ((GSvnFragment)conf.getProjectFragment()).getCmsDriver();
        ICmsStatus st = cmsDriver.getStatusDriver().getStatus(file, false);
        if (st != null && (st.isToAdd() || st.isVersioned())) {
            conf.addDeletedAssociated(ref, key, file);
        }
    }

    public void cleanAssociatedFilesRecorder(ICommitDetailFragment fragAnalysis) {
        MRef ref;
        for (MObject obj : fragAnalysis.getCreatedElements()) {
            ref = new MRef(obj);
            this.recorder.popAllFileDeletions(ref);
            this.recorder.popAllFileModifs(ref);
            this.recorder.popAllFileMoves(ref);
        }
        for (MRef ref2 : fragAnalysis.getDeletedElements()) {
            this.recorder.popAllFileDeletions(ref2);
            this.recorder.popAllFileMoves(ref2);
        }
        for (MObject obj : fragAnalysis.getModifiedElements()) {
            ref = new MRef(obj);
            this.recorder.popAllFileDeletions(ref);
            this.recorder.popAllFileModifs(ref);
            this.recorder.popAllFileMoves(ref);
        }
    }
}

