/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.cms.engine.commands.commit;

import com.modeliosoft.modelio.cms.api.CmsException;
import com.modeliosoft.modelio.cms.api.ICommitCommand;
import com.modeliosoft.modelio.cms.api.ICommitDetail;
import com.modeliosoft.modelio.cms.api.ICommitDetailFragment;
import com.modeliosoft.modelio.cms.api.ICommitResult;
import com.modeliosoft.modelio.cms.api.ICommitResultFragment;
import com.modeliosoft.modelio.cms.api.IGetLockResult;
import com.modeliosoft.modelio.cms.api.ISymbolService;
import com.modeliosoft.modelio.cms.api.InvalidCmsStateException;
import com.modeliosoft.modelio.cms.api.OutdatedElementsException;
import com.modeliosoft.modelio.cms.api.ReverseFailedException;
import com.modeliosoft.modelio.cms.api.TransactionStillOpenException;
import com.modeliosoft.modelio.cms.api.contrib.ICommitConfig;
import com.modeliosoft.modelio.cms.api.files.IAssociatedFile;
import com.modeliosoft.modelio.cms.api.files.IAssociatedFileMove;
import com.modeliosoft.modelio.cms.api.mmextension.ICmsDependencyAnalyser;
import com.modeliosoft.modelio.cms.driver.CmsDriverException;
import com.modeliosoft.modelio.cms.driver.ElementNotVersionedException;
import com.modeliosoft.modelio.cms.driver.ICmsCommitResult;
import com.modeliosoft.modelio.cms.driver.ICmsDriver;
import com.modeliosoft.modelio.cms.driver.ICmsStatus;
import com.modeliosoft.modelio.cms.engine.ICmsEngine;
import com.modeliosoft.modelio.cms.engine.ICmsFilesGetter;
import com.modeliosoft.modelio.cms.engine.commands.commit.CommitAssociatedFilesAnalyser;
import com.modeliosoft.modelio.cms.engine.commands.commit.CommitConfiguration;
import com.modeliosoft.modelio.cms.engine.commands.commit.CommitDependenciesAnalyser;
import com.modeliosoft.modelio.cms.engine.commands.commit.CommitResult;
import com.modeliosoft.modelio.cms.engine.commands.commit.CommitResultFragment;
import com.modeliosoft.modelio.cms.engine.commands.lock.GetLockCommand;
import com.modeliosoft.modelio.cms.engine.recorder.ModelChangeKeeper;
import com.modeliosoft.modelio.cms.model.ModelGroups;
import com.modeliosoft.modelio.cms.utils.SubversionUtils;
import com.modeliosoft.modelio.cms.utils.TransactionChecker;
import com.modeliosoft.modelio.gproject.svn.fragment.GSvnFragment;
import com.modeliosoft.modelio.gproject.svn.fragment.recorder.RemovalRecorder;
import com.modeliosoft.modelio.gproject.svn.plugin.ProjectSvn;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.modelio.vbasic.log.Log;
import org.modelio.vbasic.progress.IModelioProgress;
import org.modelio.vbasic.progress.SubProgress;
import org.modelio.vcore.session.api.ICoreSession;
import org.modelio.vcore.smkernel.mapi.MObject;
import org.modelio.vcore.smkernel.mapi.MRef;
import org.modelio.vcore.smkernel.mapi.services.MetamodelExtensionPoint;

public class CommitCommand
implements ICommitCommand,
ICommitConfig {
    private boolean batchMode;
    private boolean isRecursive;
    private boolean keepLocks = false;
    private String message = "";
    private boolean useProcessExtension = true;
    private final CommitAssociatedFilesAnalyser associatedFilesAnalyser;
    private CommitConfiguration commitDetails = null;
    private ICoreSession coreSession;
    private CommitDependenciesAnalyser dependenciesAnalyser;
    private ICmsEngine engine;
    private Map<ICommitDetailFragment, Collection<File>> fileCommitMap;
    private Map<File, Map<String, String>> otherFilesToAdd = new HashMap<File, Map<String, String>>();
    private Collection<File> otherFilesToDelete = new HashSet<File>();
    private Collection<File> otherFilesToModify = new HashSet<File>();
    private Collection<MObject> selection = new HashSet<MObject>();
    private final ISymbolService symbolService;

    public CommitCommand(ICmsEngine engine) {
        this.engine = engine;
        this.coreSession = this.engine.getCoreSession();
        this.symbolService = this.engine.createSymbolService();
        this.dependenciesAnalyser = new CommitDependenciesAnalyser(this.engine, this.symbolService, this.engine.getCodeReversers(), this.engine.getProject(), (MetamodelExtensionPoint<ICmsDependencyAnalyser>)this.engine.getMetamodelExtensions().getDependencyAnalyser());
        this.associatedFilesAnalyser = new CommitAssociatedFilesAnalyser(this.engine.getModelChangeKeeper().getFilesRecorder());
    }

    public void addElements(Collection<MObject> elementsToAdd, IModelioProgress monitor) throws ReverseFailedException, InvalidCmsStateException {
        this.selection.addAll(elementsToAdd);
        this.runDependencyAnalysis(monitor);
        this.updateCommitMessage();
    }

    public void addFileToModify(File toAdd) {
        try {
            if (this.isExternalToAdd(toAdd)) {
                this.otherFilesToAdd.put(toAdd, null);
            } else {
                this.otherFilesToModify.add(toAdd);
            }
        }
        catch (CmsDriverException cmsDriverException) {
            this.otherFilesToAdd.put(toAdd, null);
        }
    }

    public void addFileToRemove(File toDelete) {
        this.otherFilesToDelete.add(toDelete);
    }

    public void addFilesToAdd(Collection<File> files) {
        for (File f : files) {
            this.otherFilesToAdd.put(f, null);
        }
    }

    public void addFilesToAdd(Collection<File> files, Map<String, String> cmsProps) {
        HashMap<String, String> propsCopy = new HashMap<String, String>(cmsProps);
        for (File f : files) {
            this.otherFilesToAdd.put(f, propsCopy);
        }
    }

    public boolean callPemPreCommit(IModelioProgress monitor) {
        boolean ret = false;
        try {
            ret = this.engine.getHook().preCommit(monitor, (ICommitCommand)this);
        }
        finally {
            if (!ret) {
                this.engine.unloadChangeKeeper();
            }
        }
        return ret;
    }

    public ICommitResult execute(IModelioProgress iMonitor) throws CmsException, OutdatedElementsException {
        if (!this.useProcessExtension()) {
            return this.doExecute(iMonitor);
        }
        SubProgress monitor = SubProgress.convert((IModelioProgress)iMonitor, (String)ProjectSvn.I18N.getString("Monitor.Commit"), (int)4);
        if (!this.callPemPreCommit((IModelioProgress)monitor.newChild(1))) {
            return null;
        }
        try {
            ICommitResult result = this.doExecute((IModelioProgress)monitor);
            this.engine.getHook().postCommit(result);
            return result;
        }
        catch (CmsException | RuntimeException e) {
            this.engine.getHook().postCommitFailed((ICommitCommand)this, (Exception)e);
            throw e;
        }
    }

    public ICommitDetail getCommitAnalysis() {
        return this.commitDetails;
    }

    public ICommitConfig getConfiguration() {
        return this;
    }

    public Collection<MObject> getElements() {
        return this.getSelection();
    }

    public Collection<File> getFilesToCommit() {
        return Collections.unmodifiableCollection(this.otherFilesToModify);
    }

    public boolean getKeepLocks() {
        return this.keepLocks;
    }

    public String getMessage() {
        return this.message;
    }

    public Collection<MObject> getSelection() {
        return Collections.unmodifiableCollection(this.selection);
    }

    public boolean isBatchMode() {
        return this.batchMode;
    }

    public boolean isRecursive() {
        return this.isRecursive;
    }

    public void setBatch(boolean batchMode) {
        this.batchMode = batchMode;
    }

    public void setKeepLocks(boolean keepLocks) {
        this.keepLocks = keepLocks;
    }

    public void setMessage(String comment) {
        this.message = comment.replaceAll("\r\n", "\n");
        this.updateCommitMessage();
    }

    public void setRecursive(boolean isRecursive, IModelioProgress monitor) throws ReverseFailedException, InvalidCmsStateException {
        if (this.isRecursive != isRecursive) {
            this.isRecursive = isRecursive;
            this.runDependencyAnalysis(monitor);
            this.updateCommitMessage();
        }
    }

    public void setUseProcessExtension(boolean val) {
        this.useProcessExtension = val;
    }

    public String toString() {
        return "CommitCommand: " + this.commitDetails.toString(this.symbolService);
    }

    public boolean useProcessExtension() {
        return this.useProcessExtension;
    }

    protected ICommitResult doExecute(IModelioProgress iMonitor) throws CmsException, OutdatedElementsException {
        ModelGroups sel = new ModelGroups(this.selection);
        sel.assertAllSvn();
        this.checkValidity();
        if (this.getCommitAnalysis().isEmpty()) {
            return new CommitResult(this.getCommitAnalysis(), Collections.emptyList(), this.isBatchMode());
        }
        CommitResult result = null;
        ArrayList<ICommitResultFragment> cmsResults = new ArrayList<ICommitResultFragment>();
        try {
            this.checkTransactionStack();
            int nbFrags = this.getCommitAnalysis().getFragments().size();
            SubProgress monitor = SubProgress.convert((IModelioProgress)iMonitor, (String)ProjectSvn.I18N.getString("Monitor.Commit"), (int)710);
            this.fileCommitMap = new HashMap<ICommitDetailFragment, Collection<File>>(nbFrags);
            for (ICommitDetailFragment fragAnalysis : this.getCommitAnalysis().getFragments()) {
                ArrayList toCommit = new ArrayList(100);
                this.fileCommitMap.put(fragAnalysis, toCommit);
            }
            this.scheduleDeletions(monitor, 200);
            this.scheduleModifications();
            monitor.setWorkRemaining(500);
            this.coreSession.save((IModelioProgress)monitor.newChild(200));
            this.scheduleAdditions(monitor, 200);
            this.scheduleExternalFiles(monitor, 100);
            this.doCommit(monitor, cmsResults);
            this.commitExternalFiles((IModelioProgress)monitor);
            result = new CommitResult(this.getCommitAnalysis(), cmsResults, this.isBatchMode());
            this.cleanModelChangeKeeper(result);
            this.coreSession.save((IModelioProgress)monitor.newChild(10));
            CommitResult commitResult = result;
            return commitResult;
        }
        catch (IOException e) {
            throw new CmsException(e.getLocalizedMessage(), (Throwable)e);
        }
        catch (TransactionStillOpenException e) {
            throw new CmsException(ProjectSvn.I18N.getString("Error.TransactionStillOpenException.detail"), (Throwable)e);
        }
        finally {
            this.fileCommitMap = null;
            if (result == null) {
                this.unloadChangeKeeper();
            }
        }
    }

    private void checkTransactionStack() throws TransactionStillOpenException {
        if (TransactionChecker.isActiveTransaction(this.coreSession)) {
            throw new TransactionStillOpenException();
        }
    }

    private void checkValidity() throws CmsException {
        StringBuilder content = new StringBuilder();
        if (this.getCommitAnalysis().hasNeededNonVersionedElements()) {
            content.append(ProjectSvn.I18N.getString("CommitCommand.Details.NonVersioned"));
            content.append("\n");
            for (File f : this.getCommitAnalysis().getFragments()) {
                for (Map.Entry el : f.getNeededNonVersionedElements().entrySet()) {
                    content.append(ProjectSvn.I18N.getMessage("CommitCommand.Details.NonVersioned.line", new Object[]{this.symbolService.getFullName((MObject)el.getKey()), ((MObject)el.getKey()).getMClass().getName(), this.symbolService.getFullName((MObject)el.getValue()), ((MObject)el.getValue()).getMClass().getName()}));
                    content.append("\n");
                }
            }
            content.append("\n");
        }
        if (this.getCommitAnalysis().hasConflictedElements()) {
            content.append(ProjectSvn.I18N.getString("CommitCommand.Details.Conflicted"));
            content.append("\n");
            for (File f : this.getCommitAnalysis().getFragments()) {
                for (Map.Entry el : f.getConflictedElements().entrySet()) {
                    content.append(ProjectSvn.I18N.getMessage("CommitCommand.Details.NonVersioned.line", new Object[]{this.symbolService.getFullName((MObject)el.getKey()), ((MObject)el.getKey()).getMClass().getName(), this.symbolService.getFullName((MObject)el.getValue()), ((MObject)el.getValue()).getMClass().getName()}));
                    content.append("\n");
                }
            }
            content.append("\n");
        }
        for (File f : this.otherFilesToModify) {
            ICmsDriver cmsDriver = this.engine.getCmsDriver(f);
            ICmsStatus st = cmsDriver.getStatusDriver().getStatus(f, false);
            if (!st.isConflicted()) continue;
            content.append(ProjectSvn.I18N.getMessage("CommitCommand.Details.ConflictedFile.line", new Object[]{f}));
            content.append("\n");
        }
        if (content.length() > 0) {
            throw new CmsException(content.toString());
        }
    }

    private void cleanModelChangeKeeper(CommitResult result) throws IOException {
        ModelChangeKeeper changeKeeper = this.engine.getModelChangeKeeper();
        changeKeeper.removeMoves(result.getMoveReferences());
        changeKeeper.removeAllDeletedRef(result.deletedElements());
        changeKeeper.save();
        RemovalRecorder rec = RemovalRecorder.get(this.engine.getProject());
        rec.removeRecords(result.deletedElements());
    }

    private ICmsCommitResult commitExternalFiles(IModelioProgress monitor) throws CmsDriverException, OutdatedElementsException {
        int nbFilesToCommit = this.otherFilesToAdd.size() + this.otherFilesToModify.size() + this.otherFilesToDelete.size();
        if (nbFilesToCommit > 0) {
            HashSet<File> filesToCommit = new HashSet<File>(nbFilesToCommit);
            filesToCommit.addAll(this.otherFilesToAdd.keySet());
            filesToCommit.addAll(this.otherFilesToModify);
            filesToCommit.addAll(this.otherFilesToDelete);
            ICmsDriver cmsDriver = this.engine.getCmsDriver((File)filesToCommit.iterator().next());
            return cmsDriver.commit(monitor, filesToCommit, this.getKeepLocks(), this.getMessage());
        }
        return null;
    }

    private int countFilesToDelete() {
        int ret = 0;
        for (ICommitDetailFragment fragAnalysis : this.getCommitAnalysis().getFragments()) {
            Set deletions = fragAnalysis.getDeletedElements();
            Set deletedBlobs = fragAnalysis.getDeletedBlobs();
            ret += deletions.size() + deletedBlobs.size() + fragAnalysis.getAssociatedFileDeletions().size();
        }
        return ret + this.otherFilesToDelete.size();
    }

    private void doCommit(SubProgress amonitor, Collection<ICommitResultFragment> results) throws CmsDriverException, OutdatedElementsException {
        amonitor.setWorkRemaining((int)((double)this.getCommitAnalysis().getFragments().size() * 1.2));
        for (ICommitDetailFragment fragAnalysis : this.getCommitAnalysis().getFragments()) {
            Collection<File> toCommit = this.fileCommitMap.get(fragAnalysis);
            SubProgress monitor = SubProgress.convert((IModelioProgress)amonitor.newChild(1), (int)3);
            ICmsDriver cmsDriver = ((GSvnFragment)fragAnalysis.getProjectFragment()).getCmsDriver();
            GetLockCommand keepAddedLock = this.getKeepNewElementsLockCommand(fragAnalysis);
            monitor.setWorkRemaining(keepAddedLock == null ? 2 : 3);
            monitor.subTask(ProjectSvn.I18N.getMessage("Monitor.Commit.SVNCommit", new Object[]{fragAnalysis.getProjectFragment().getId()}));
            ICmsCommitResult cmsResult = cmsDriver.commit((IModelioProgress)monitor.newChild(2), toCommit, this.getKeepLocks(), this.getMessage());
            this.associatedFilesAnalyser.cleanAssociatedFilesRecorder(fragAnalysis);
            IGetLockResult lockResult = null;
            if (keepAddedLock != null) {
                monitor.subTask(ProjectSvn.I18N.getMessage("Monitor.Commit.SVNCommit.getlocksOnAdded", new Object[]{fragAnalysis.getProjectFragment().getId(), keepAddedLock.getElements().size()}));
                try {
                    lockResult = keepAddedLock.execute((IModelioProgress)monitor.newChild(1));
                }
                catch (CmsException e) {
                    ProjectSvn.LOG.warning("Cannot keep added elements locked: " + SubversionUtils.getLocalizedMessage(e));
                    ProjectSvn.LOG.warning(e);
                }
            }
            CommitResultFragment resFrag = new CommitResultFragment(fragAnalysis, cmsResult, this.coreSession.getModel(), lockResult);
            results.add(resFrag);
        }
    }

    private GetLockCommand getKeepNewElementsLockCommand(ICommitDetailFragment fragAnalysis) {
        Set createdElements = fragAnalysis.getCreatedElements();
        ArrayList<File> filesToLock = new ArrayList<File>();
        boolean keepLockOnAddedElements = false;
        if (!createdElements.isEmpty()) {
            boolean bl = keepLockOnAddedElements = this.getKeepLocks() && ((MObject)createdElements.iterator().next()).getStatus().isLockingNeeded();
            if (keepLockOnAddedElements) {
                for (IAssociatedFile a : fragAnalysis.getAssociatedFileCreations()) {
                    filesToLock.add(a.getFile());
                }
            }
            if (keepLockOnAddedElements) {
                GetLockCommand lockCmd = new GetLockCommand(this.engine);
                lockCmd.setRecursive(false);
                lockCmd.addElements(fragAnalysis.getCreatedElements());
                lockCmd.addFiles(filesToLock);
                lockCmd.setComment(this.message);
                lockCmd.setStealLocks(false);
                lockCmd.setBatch(true);
                return lockCmd;
            }
        }
        return null;
    }

    private boolean isExternalToAdd(File f) throws CmsDriverException {
        ICmsStatus stat = this.engine.getCmsDriver(f).getStatusDriver().getStatus(f, false);
        return stat == null || !stat.isVersioned();
    }

    private void runDependencyAnalysis(IModelioProgress monitor) throws InvalidCmsStateException, ReverseFailedException {
        boolean ok = false;
        try {
            try {
                this.commitDetails = this.dependenciesAnalyser.execute(this.selection, this.isRecursive, monitor);
                this.associatedFilesAnalyser.run(this.commitDetails);
                ok = true;
            }
            catch (CmsDriverException e) {
                throw new InvalidCmsStateException(e.getLocalizedMessage(), (Throwable)((Object)e));
            }
            catch (InterruptedException e) {
                throw new ReverseFailedException(ProjectSvn.I18N.getString("CommitCommand.cancelled"), (Throwable)e);
            }
        }
        finally {
            if (!ok) {
                this.engine.unloadChangeKeeper();
            }
        }
    }

    private void scheduleAdditions(SubProgress amonitor, int monitorWork) throws CmsDriverException {
        ICmsDriver cmsDriver = null;
        int subMonQ = monitorWork / (this.getCommitAnalysis().getFragments().size() + 1);
        for (ICommitDetailFragment fragAnalysis : this.getCommitAnalysis().getFragments()) {
            Collection<File> toCommit = this.fileCommitMap.get(fragAnalysis);
            cmsDriver = ((GSvnFragment)fragAnalysis.getProjectFragment()).getCmsDriver();
            ICmsFilesGetter filesGetter = cmsDriver.getFilesGetter();
            ArrayList<File> filesToAdd = new ArrayList<File>();
            Set createdElements = fragAnalysis.getCreatedElements();
            filesToAdd.addAll(filesGetter.getRelatedFiles(createdElements));
            for (IAssociatedFile a : fragAnalysis.getAssociatedFileCreations()) {
                filesToAdd.add(a.getFile());
            }
            if (filesToAdd.isEmpty()) continue;
            SubProgress mon2 = SubProgress.convert((IModelioProgress)amonitor.newChild(subMonQ), (int)filesToAdd.size());
            mon2.subTask(ProjectSvn.I18N.getMessage("Monitor.Commit.AddingCount", new Object[]{String.valueOf(filesToAdd.size()), fragAnalysis.getProjectFragment().getId()}));
            for (File file : filesToAdd) {
                if (file.exists()) {
                    cmsDriver.addFile(file);
                    toCommit.add(file);
                } else {
                    Log.warning((String)"SVN commit: '%s' file to add does not exist.", (Object[])new Object[]{file});
                }
                mon2.worked(1);
            }
        }
    }

    private void scheduleDeletion(ICmsDriver cmsDriver, File f, Collection<File> toCommit) throws CmsDriverException {
        try {
            cmsDriver.delete(f);
            if (toCommit != null) {
                toCommit.add(f);
            }
        }
        catch (ElementNotVersionedException e) {
            ProjectSvn.LOG.warning(SubversionUtils.getLocalizedMessage((Throwable)((Object)e)));
        }
    }

    private void scheduleDeletions(SubProgress monitor, int monitorWork) throws CmsDriverException {
        int nbToDelete = this.countFilesToDelete();
        if (nbToDelete > 0) {
            SubProgress mon2 = SubProgress.convert((IModelioProgress)monitor.newChild(monitorWork), (int)nbToDelete);
            for (ICommitDetailFragment fragAnalysis : this.getCommitAnalysis().getFragments()) {
                Collection<File> toCommit = this.fileCommitMap.get(fragAnalysis);
                Set deletions = fragAnalysis.getDeletedElements();
                ICmsDriver cmsDriver = ((GSvnFragment)fragAnalysis.getProjectFragment()).getCmsDriver();
                if (!deletions.isEmpty()) {
                    File f;
                    Set deletedBlobs = fragAnalysis.getDeletedBlobs();
                    mon2.subTask(ProjectSvn.I18N.getMessage("Monitor.Commit.DeletingCount", new Object[]{String.valueOf(deletions.size())}));
                    for (MRef ref : deletions) {
                        this.getCommitAnalysis().getSymbolService().cacheSymbol(ref);
                        f = cmsDriver.getFilesGeometry().getExmlFile(ref);
                        this.scheduleDeletion(cmsDriver, f, toCommit);
                        mon2.worked(1);
                    }
                    mon2.subTask(ProjectSvn.I18N.getMessage("Monitor.Commit.DeletingCount", new Object[]{String.valueOf(deletedBlobs.size())}));
                    for (String blob : deletedBlobs) {
                        f = cmsDriver.getFilesGeometry().getBlobFile(blob);
                        this.scheduleDeletion(cmsDriver, f, toCommit);
                        mon2.worked(1);
                    }
                }
                for (IAssociatedFile af : fragAnalysis.getAssociatedFileDeletions()) {
                    File f = af.getFile();
                    this.scheduleDeletion(cmsDriver, f, toCommit);
                    mon2.worked(1);
                }
            }
        }
    }

    private void scheduleExternalFiles(SubProgress monitor, int monitorWork) throws CmsDriverException {
        if (!this.otherFilesToDelete.isEmpty() || !this.otherFilesToAdd.isEmpty()) {
            ICmsDriver cmsDriver = null;
            SubProgress mon2 = SubProgress.convert((IModelioProgress)monitor.newChild(monitorWork), (int)(this.otherFilesToDelete.size() + this.otherFilesToAdd.size()));
            if (!this.otherFilesToDelete.isEmpty()) {
                mon2.subTask(ProjectSvn.I18N.getMessage("Monitor.Commit.DeletingCount", new Object[]{String.valueOf(this.otherFilesToDelete.size())}));
                for (File f : this.otherFilesToDelete) {
                    cmsDriver = this.engine.getCmsDriver(f);
                    this.scheduleDeletion(cmsDriver, f, null);
                    mon2.worked(1);
                }
            }
            if (!this.otherFilesToAdd.isEmpty()) {
                if (cmsDriver == null) {
                    cmsDriver = this.engine.getCmsDriver(this.otherFilesToAdd.keySet().iterator().next());
                }
                for (Map.Entry<File, Map<String, String>> en : this.otherFilesToAdd.entrySet()) {
                    File f = en.getKey();
                    if (f.exists()) {
                        if (en.getValue() != null) {
                            cmsDriver.addFile(f, en.getValue());
                        } else {
                            cmsDriver.addFile(f);
                        }
                    } else {
                        Log.warning((String)"SVN commit: '%s' file to add with {%s} properties does not exist.", (Object[])new Object[]{f, en.getValue()});
                    }
                    mon2.worked(1);
                }
            }
        }
    }

    private void scheduleModifications() throws CmsDriverException {
        for (ICommitDetailFragment fragAnalysis : this.getCommitAnalysis().getFragments()) {
            Collection<File> toCommit = this.fileCommitMap.get(fragAnalysis);
            ICmsDriver cmsDriver = ((GSvnFragment)fragAnalysis.getProjectFragment()).getCmsDriver();
            ICmsFilesGetter filesGetter = cmsDriver.getFilesGetter();
            Collection<File> exmlFiles = filesGetter.getRelatedExmlFiles(fragAnalysis.getModifiedElements());
            toCommit.addAll(exmlFiles);
            Collection<File> blobFiles = filesGetter.getRelatedBlobFiles(fragAnalysis.getModifiedElements());
            for (File bf : blobFiles) {
                ICmsStatus st = cmsDriver.getStatusDriver().getStatus(bf, false);
                if (st.isVersioned() && !st.isToAdd()) continue;
                cmsDriver.addFile(bf);
            }
            toCommit.addAll(blobFiles);
            if (!this.getKeepLocks()) {
                toCommit.addAll(filesGetter.getRelatedFiles(fragAnalysis.getNonModifiedElementsToUnlock()));
            }
            for (IAssociatedFile af : fragAnalysis.getAssociatedFileModifications()) {
                toCommit.add(af.getFile());
            }
            for (IAssociatedFileMove fileMove : fragAnalysis.getAssociatedFileMoves()) {
                cmsDriver.moveFile(fileMove.getOriginalFile(), fileMove.getNewFile(), false);
                toCommit.add(fileMove.getOriginalFile());
                toCommit.add(fileMove.getNewFile());
            }
        }
    }

    private void unloadChangeKeeper() {
        this.engine.unloadChangeKeeper();
    }

    private void updateCommitMessage() {
        if (this.commitDetails != null) {
            this.commitDetails.setMessage(this.getMessage());
        }
    }
}

