/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.cms.engine.commands.commit;

import com.modeliosoft.modelio.cms.api.ICommitDetailFragment;
import com.modeliosoft.modelio.cms.api.ICommitEntry;
import com.modeliosoft.modelio.cms.api.ISymbolService;
import com.modeliosoft.modelio.cms.api.files.IAssociatedFile;
import com.modeliosoft.modelio.cms.api.files.IAssociatedFileMove;
import com.modeliosoft.modelio.cms.engine.commands.commit.AssociatedFile;
import com.modeliosoft.modelio.cms.engine.commands.commit.CommitEntry;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.modelio.gproject.core.IGModelFragment;
import org.modelio.vcore.smkernel.mapi.MObject;
import org.modelio.vcore.smkernel.mapi.MRef;

class CommitConfigFragment
implements ICommitDetailFragment {
    private final Set<String> deletedElementNames;
    private final Set<String> deletedBlobs;
    private String commitMessage;
    private final Set<MObject> createdElements;
    private final ISymbolService symbolService;
    private final Set<MObject> elementsToUnlock;
    private final Set<MRef> deletedElements;
    private final Map<MObject, MObject> nonVersionedElements;
    private final Set<MObject> modifiedElements;
    private final Map<MObject, MObject> conflictedElements;
    private IGModelFragment fragment;
    private final Collection<IAssociatedFile> createdAssociated;
    private final Collection<IAssociatedFile> modifiedAssociated;
    private final Collection<IAssociatedFile> deletedAssociated;
    private final Collection<IAssociatedFileMove> movedAssociated;
    private final Map<MObject, MObject> neededShellElements;

    public CommitConfigFragment(IGModelFragment fragment, ISymbolService symbolService) {
        this.fragment = fragment;
        this.createdElements = new HashSet<MObject>();
        this.deletedElementNames = new HashSet<String>();
        this.deletedElements = new HashSet<MRef>();
        this.deletedBlobs = new HashSet<String>();
        this.modifiedElements = new HashSet<MObject>();
        this.elementsToUnlock = new HashSet<MObject>();
        this.symbolService = symbolService;
        this.nonVersionedElements = new HashMap<MObject, MObject>();
        this.neededShellElements = new HashMap<MObject, MObject>();
        this.conflictedElements = new HashMap<MObject, MObject>();
        this.modifiedAssociated = new HashSet<IAssociatedFile>();
        this.deletedAssociated = new HashSet<IAssociatedFile>();
        this.createdAssociated = new HashSet<IAssociatedFile>();
        this.movedAssociated = new HashSet<IAssociatedFileMove>();
    }

    public void addConflictedElement(MObject el, MObject neededBy) {
        this.conflictedElements.put(el, neededBy);
    }

    public boolean isEmpty() {
        return this.createdElements.isEmpty() && this.deletedElements.isEmpty() && this.modifiedElements.isEmpty() && this.elementsToUnlock.isEmpty() && this.conflictedElements.isEmpty() && this.nonVersionedElements.isEmpty();
    }

    public void addDeletedElement(MRef ref) {
        this.deletedElements.add(ref);
        this.symbolService.cacheSymbol(ref);
    }

    public Set<MObject> getNonModifiedElementsToUnlock() {
        return this.elementsToUnlock;
    }

    public Set<MObject> getModifiedElements() {
        return this.modifiedElements;
    }

    void addElementToUnlock(MObject el) {
        this.elementsToUnlock.add(el);
    }

    void addModifiedElement(MObject el) {
        this.modifiedElements.add(el);
    }

    public void addDeletedBlob(String blob) {
        this.deletedBlobs.add(blob);
    }

    public Set<MObject> getCreatedElements() {
        return this.createdElements;
    }

    public Map<MObject, MObject> getConflictedElements() {
        return this.conflictedElements;
    }

    public Set<String> getDeletedBlobs() {
        return this.deletedBlobs;
    }

    void addCreatedElement(MObject el) {
        this.createdElements.add(el);
    }

    public void addNeededNonVersionedElement(MObject neededNode, MObject neededBy) {
        this.nonVersionedElements.put(neededNode, neededBy);
    }

    public Map<MObject, MObject> getNeededNonVersionedElements() {
        return this.nonVersionedElements;
    }

    public Set<MRef> getDeletedElements() {
        return this.deletedElements;
    }

    public ISymbolService getSymbolService() {
        return this.symbolService;
    }

    public IGModelFragment getProjectFragment() {
        return this.fragment;
    }

    public void setCommitMessage(String commitMessage) {
        this.commitMessage = commitMessage;
    }

    public String getMessage() {
        return this.commitMessage;
    }

    public Collection<ICommitEntry> getEntries() {
        ArrayList<ICommitEntry> modifs = new ArrayList<ICommitEntry>();
        for (MObject mObject : this.getCreatedElements()) {
            modifs.add(new CommitEntry(ICommitEntry.Type.ADD, mObject, null));
        }
        for (MObject mObject : this.getModifiedElements()) {
            modifs.add(new CommitEntry(ICommitEntry.Type.UPDATE, mObject, null));
        }
        for (MObject mObject : this.getNonModifiedElementsToUnlock()) {
            modifs.add(new CommitEntry(ICommitEntry.Type.UNLOCK, mObject, null));
        }
        for (MRef mRef : this.getDeletedElements()) {
            modifs.add(new CommitEntry(ICommitEntry.Type.REMOVE, null, mRef));
        }
        return modifs;
    }

    public void addModifiedAssociated(MRef ref, String key, File file) {
        this.modifiedAssociated.add(new AssociatedFile(ref, key, file));
    }

    public void addCreatedAssociated(MRef ref, String key, File file) {
        this.createdAssociated.add(new AssociatedFile(ref, key, file));
    }

    public void addDeletedAssociated(MRef ref, String key, File file) {
        this.deletedAssociated.add(new AssociatedFile(ref, key, file));
    }

    public Collection<IAssociatedFile> getAssociatedFileModifications() {
        return this.modifiedAssociated;
    }

    public Collection<IAssociatedFile> getAssociatedFileDeletions() {
        return this.deletedAssociated;
    }

    public Collection<IAssociatedFile> getAssociatedFileCreations() {
        return this.createdAssociated;
    }

    public Collection<IAssociatedFileMove> getAssociatedFileMoves() {
        return this.movedAssociated;
    }

    public void addMovedAssociated(Collection<? extends IAssociatedFileMove> moved) {
        this.movedAssociated.addAll(moved);
    }

    public Map<MObject, MObject> getNeededShellElements() {
        return this.neededShellElements;
    }

    public void addNeededShellElement(MObject neededNode, MObject neededBy) {
        this.neededShellElements.put(neededNode, neededBy);
    }
}

