/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.cms.engine.commands.commit;

import com.modeliosoft.modelio.cms.api.ICommitDetail;
import com.modeliosoft.modelio.cms.api.ICommitDetailFragment;
import com.modeliosoft.modelio.cms.api.IElementMove;
import com.modeliosoft.modelio.cms.api.IElementMoveRef;
import com.modeliosoft.modelio.cms.api.ISymbolService;
import com.modeliosoft.modelio.cms.engine.commands.commit.CommitConfigFragment;
import com.modeliosoft.modelio.cms.engine.recorder.ElementMove;
import com.modeliosoft.modelio.cms.utils.SorterByName;
import com.modeliosoft.modelio.gproject.svn.plugin.ProjectSvn;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.modelio.gproject.core.IGModelFragment;
import org.modelio.gproject.core.IGProject;
import org.modelio.vbasic.collections.CompoundCollection;
import org.modelio.vcore.session.api.model.IModel;
import org.modelio.vcore.smkernel.mapi.MObject;
import org.modelio.vcore.smkernel.mapi.MRef;

class CommitConfiguration
implements ICommitDetail {
    private String message = "";
    private final Set<IElementMoveRef> moveRefs;
    private final ISymbolService symbolService;
    private Map<IGModelFragment, CommitConfigFragment> fragments;
    private final IGProject gproject;
    private Set<IElementMove> moves;

    public CommitConfiguration(IGProject gproject, ISymbolService symbolService) {
        this.gproject = gproject;
        this.moveRefs = new HashSet<IElementMoveRef>();
        this.symbolService = symbolService;
        this.fragments = new HashMap<IGModelFragment, CommitConfigFragment>();
    }

    @Deprecated
    public Map<MObject, MObject> getConflictedElements() {
        HashMap<MObject, MObject> ret = new HashMap<MObject, MObject>();
        for (CommitConfigFragment f : this.fragments.values()) {
            ret.putAll(f.getConflictedElements());
        }
        return ret;
    }

    @Deprecated
    public Collection<MObject> getCreatedElements() {
        CompoundCollection ret = new CompoundCollection();
        for (CommitConfigFragment f : this.fragments.values()) {
            ret.addAll(f.getCreatedElements());
        }
        return ret;
    }

    @Deprecated
    public Collection<String> getDeletedBlobs() {
        CompoundCollection ret = new CompoundCollection();
        for (CommitConfigFragment f : this.fragments.values()) {
            ret.addAll(f.getDeletedBlobs());
        }
        return ret;
    }

    @Deprecated
    public Collection<MRef> getDeletedElements() {
        CompoundCollection ret = new CompoundCollection();
        for (CommitConfigFragment f : this.fragments.values()) {
            ret.addAll(f.getDeletedElements());
        }
        return ret;
    }

    public String getMessage() {
        return this.message;
    }

    @Deprecated
    public Collection<MObject> getModifiedElements() {
        CompoundCollection ret = new CompoundCollection();
        for (CommitConfigFragment f : this.fragments.values()) {
            ret.addAll(f.getModifiedElements());
        }
        return ret;
    }

    public Set<IElementMove> getMoves() {
        if (this.moves == null) {
            this.moves = new HashSet<IElementMove>();
            IModel model = this.gproject.getSession().getModel();
            for (IElementMoveRef moveRef : this.moveRefs) {
                ElementMove m = new ElementMove(model.findByRef(moveRef.getMoved()), model.findByRef(moveRef.getOldParent()), model.findByRef(moveRef.getNewParent()));
                this.moves.add(m);
            }
        }
        return this.moves;
    }

    @Deprecated
    public Map<MObject, MObject> getNeededNonVersionedElements() {
        HashMap<MObject, MObject> ret = new HashMap<MObject, MObject>();
        for (CommitConfigFragment f : this.fragments.values()) {
            ret.putAll(f.getNeededNonVersionedElements());
        }
        return ret;
    }

    @Deprecated
    public Collection<MObject> getNonModifiedElementsToUnlock() {
        CompoundCollection ret = new CompoundCollection();
        for (CommitConfigFragment f : this.fragments.values()) {
            ret.addAll(f.getNonModifiedElementsToUnlock());
        }
        return ret;
    }

    public ISymbolService getSymbolService() {
        return this.symbolService;
    }

    public boolean isEmpty() {
        return this.getFragments().isEmpty();
    }

    void addMoves(Collection<IElementMoveRef> elementMoves) {
        this.moveRefs.addAll(elementMoves);
        this.moves = null;
    }

    void setMessage(String message) {
        this.message = message;
    }

    CommitConfigFragment getFragment(IGModelFragment f) {
        CommitConfigFragment commitFragment = this.fragments.get(f);
        if (commitFragment == null) {
            commitFragment = new CommitConfigFragment(f, this.getSymbolService());
            commitFragment.setCommitMessage(this.getMessage());
            this.fragments.put(f, commitFragment);
        }
        return commitFragment;
    }

    CommitConfigFragment getFragment(MObject obj) {
        return this.getFragment(this.gproject.getFragment(obj));
    }

    public boolean hasNeededNonVersionedElements() {
        for (CommitConfigFragment f : this.fragments.values()) {
            if (f.getNeededNonVersionedElements().isEmpty()) continue;
            return true;
        }
        return false;
    }

    public boolean hasConflictedElements() {
        for (CommitConfigFragment f : this.fragments.values()) {
            if (f.getConflictedElements().isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Collection<CommitConfigFragment> getFragments() {
        Collection<CommitConfigFragment> values = this.fragments.values();
        Iterator<CommitConfigFragment> it = values.iterator();
        while (it.hasNext()) {
            CommitConfigFragment commitFrag = it.next();
            if (!commitFrag.isEmpty() && commitFrag.getProjectFragment() != null) continue;
            it.remove();
        }
        return values;
    }

    public Collection<IElementMoveRef> getMoveReferences() {
        return this.moveRefs;
    }

    public String toString(ISymbolService symbolService) {
        StringBuilder content = new StringBuilder();
        CommitConfiguration commitResult = this;
        SorterByName sorter = new SorterByName(symbolService);
        if (commitResult.hasNeededNonVersionedElements()) {
            content.append(ProjectSvn.I18N.getString("CommitConfiguration.Details.NonVersioned"));
            content.append("\n");
            for (ICommitDetailFragment commitFragment : commitResult.getFragments()) {
                for (Map.Entry el : commitFragment.getNeededNonVersionedElements().entrySet()) {
                    content.append(ProjectSvn.I18N.getMessage("CommitConfiguration.Details.NonVersioned.line", new Object[]{symbolService.getFullName((MObject)el.getKey()), ((MObject)el.getKey()).getMClass().getName(), symbolService.getFullName((MObject)el.getValue()), ((MObject)el.getValue()).getMClass().getName()}));
                    content.append("\n");
                }
            }
        }
        boolean hasUnresolved = false;
        for (ICommitDetailFragment commitFragment : commitResult.getFragments()) {
            for (Map.Entry el : commitFragment.getNeededShellElements().entrySet()) {
                if (!hasUnresolved) {
                    content.append(ProjectSvn.I18N.getString("CommitConfiguration.Details.Unresolved"));
                    content.append("\n");
                    hasUnresolved = true;
                }
                content.append(ProjectSvn.I18N.getMessage("CommitConfiguration.Details.NonVersioned.line", new Object[]{symbolService.getFullName((MObject)el.getKey()), ((MObject)el.getKey()).getMClass().getName(), symbolService.getFullName((MObject)el.getValue()), ((MObject)el.getValue()).getMClass().getName()}));
                content.append("\n");
            }
        }
        if (commitResult.hasConflictedElements()) {
            content.append(ProjectSvn.I18N.getString("CommitConfiguration.Details.Conflicted"));
            content.append("\n");
            for (ICommitDetailFragment commitFragment : commitResult.getFragments()) {
                for (Map.Entry el : commitFragment.getConflictedElements().entrySet()) {
                    content.append(ProjectSvn.I18N.getMessage("CommitConfiguration.Details.NonVersioned.line", new Object[]{symbolService.getFullName((MObject)el.getKey()), ((MObject)el.getKey()).getMClass().getName(), symbolService.getFullName((MObject)el.getValue()), ((MObject)el.getValue()).getMClass().getName()}));
                    content.append("\n");
                }
            }
            content.append("\n");
        }
        for (ICommitDetailFragment commitFragment : commitResult.getFragments()) {
            this.dumpCommitContent(content, commitFragment, symbolService, sorter);
        }
        if (!commitResult.getMoves().isEmpty()) {
            content.append(ProjectSvn.I18N.getString("CommitConfiguration.Details.Moved.header"));
            content.append("\n");
            for (IElementMove s : commitResult.getMoves()) {
                content.append(" - ");
                content.append(symbolService.getName(s.getMoved()));
                content.append(" :\n");
                content.append("      from : ");
                content.append(symbolService.getFullName(s.getOldParent()));
                content.append("\n");
                content.append("      to : ");
                content.append(symbolService.getFullName(s.getNewParent()));
                content.append("\n");
            }
            content.append("\n");
        }
        return content.toString();
    }

    private void dumpCommitContent(StringBuilder content, ICommitDetailFragment commitFragment, ISymbolService symbolService, SorterByName sorter) {
        IGModelFragment projectFragment = commitFragment.getProjectFragment();
        content.append(ProjectSvn.I18N.getMessage("CommitConfiguration.Details.Fragment", new Object[]{projectFragment != null ? projectFragment.getId() : "<none>"}));
        content.append("\n");
        if (!commitFragment.getCreatedElements().isEmpty()) {
            content.append("  ");
            content.append(ProjectSvn.I18N.getString("CommitConfiguration.Details.Added.header"));
            content.append("\n");
            for (MObject el : sorter.getSortedByName(commitFragment.getCreatedElements())) {
                content.append("  ");
                content.append(" - ");
                content.append(symbolService.getFullName(el));
                content.append("\n");
            }
            content.append("\n");
        }
        if (!commitFragment.getModifiedElements().isEmpty()) {
            content.append("  ");
            content.append(ProjectSvn.I18N.getString("CommitConfiguration.Details.Modified.header"));
            content.append("\n");
            for (MObject el : sorter.getSortedByName(commitFragment.getModifiedElements())) {
                content.append("  ");
                content.append(" - ");
                content.append(symbolService.getFullName(el));
                content.append("\n");
            }
            content.append("\n");
        }
        if (!commitFragment.getDeletedElements().isEmpty()) {
            content.append("  ");
            content.append(ProjectSvn.I18N.getString("CommitConfiguration.Details.Deleted.header"));
            content.append("\n");
            for (MRef ref : sorter.getSortedRefsByName(commitFragment.getDeletedElements())) {
                content.append("  ");
                content.append(" - ");
                content.append(symbolService.getFullName(ref));
                content.append("\n");
            }
            content.append("\n");
        }
    }
}

