/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.cms.engine.commands.commit;

import com.modeliosoft.modelio.cms.api.ICodeReverser;
import com.modeliosoft.modelio.cms.api.IElementMoveRef;
import com.modeliosoft.modelio.cms.api.ISymbolService;
import com.modeliosoft.modelio.cms.api.InvalidCmsStateException;
import com.modeliosoft.modelio.cms.api.ReverseFailedException;
import com.modeliosoft.modelio.cms.api.mmextension.ICmsDependencyAnalyser;
import com.modeliosoft.modelio.cms.driver.CmsDriverException;
import com.modeliosoft.modelio.cms.driver.ICmsDriver;
import com.modeliosoft.modelio.cms.driver.parse.CmsNodeStruct;
import com.modeliosoft.modelio.cms.engine.IModelChangeKeeperFactory;
import com.modeliosoft.modelio.cms.engine.commands.commit.CommitConfigFragment;
import com.modeliosoft.modelio.cms.engine.commands.commit.CommitConfiguration;
import com.modeliosoft.modelio.cms.engine.recorder.ModelChangeKeeper;
import com.modeliosoft.modelio.cms.repository.CmsVersionedRepository;
import com.modeliosoft.modelio.cms.utils.CmsNodeUtils;
import com.modeliosoft.modelio.gproject.svn.fragment.recorder.RemovalRecorder;
import com.modeliosoft.modelio.gproject.svn.plugin.ProjectSvn;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.modelio.gproject.core.IGModelFragment;
import org.modelio.gproject.core.IGProject;
import org.modelio.vbasic.files.FileUtils;
import org.modelio.vbasic.progress.IModelioProgress;
import org.modelio.vbasic.progress.SubProgress;
import org.modelio.vcore.session.api.ICoreSession;
import org.modelio.vcore.session.api.repository.IRepository;
import org.modelio.vcore.smkernel.SmObjectImpl;
import org.modelio.vcore.smkernel.mapi.MObject;
import org.modelio.vcore.smkernel.mapi.MRef;
import org.modelio.vcore.smkernel.mapi.MStatus;
import org.modelio.vcore.smkernel.mapi.services.MetamodelExtensionPoint;
import org.modelio.vstore.exml.versioned.VersionedNodeDependencies;

public final class CommitDependenciesAnalyser {
    private boolean changeKeeperModified = false;
    private final IModelChangeKeeperFactory changesKeeperFactory;
    private final ISymbolService symbolService;
    private final ICodeReverser codeReversers;
    private final Map<MObject, VersionedNodeDependencies> directDepsCache = new HashMap<MObject, VersionedNodeDependencies>();
    private final ICoreSession session;
    private final IGProject gproject;
    private final MetamodelExtensionPoint<ICmsDependencyAnalyser> depAnalyserMmExt;
    private final RemovalRecorder repositoryRemovalRecorder;

    private VersionedNodeDependencies getDirectDeps(MObject el) {
        VersionedNodeDependencies ret = this.directDepsCache.get(el);
        if (ret == null) {
            ret = new VersionedNodeDependencies((SmObjectImpl)el);
            this.directDepsCache.put(el, ret);
        }
        return ret;
    }

    CommitDependenciesAnalyser(IModelChangeKeeperFactory changesKeeperFactory, ISymbolService symbolService, ICodeReverser codeReversers, IGProject gproject, MetamodelExtensionPoint<ICmsDependencyAnalyser> depAnalyserMmExt) {
        this.changesKeeperFactory = changesKeeperFactory;
        this.symbolService = symbolService;
        this.codeReversers = codeReversers;
        this.gproject = gproject;
        this.session = gproject.getSession();
        this.depAnalyserMmExt = depAnalyserMmExt;
        this.repositoryRemovalRecorder = RemovalRecorder.get(gproject);
    }

    public CommitConfiguration execute(Collection<MObject> cmsNodes, boolean isHierarchic, IModelioProgress iMonitor) throws ReverseFailedException, InvalidCmsStateException, InterruptedException {
        CommitConfiguration commitDetail = new CommitConfiguration(this.gproject, this.symbolService);
        if (cmsNodes.isEmpty()) {
            return commitDetail;
        }
        SubProgress monitor = SubProgress.convert((IModelioProgress)iMonitor, (int)20);
        RunState runState = new RunState(commitDetail, (IModelioProgress)monitor, isHierarchic);
        if (this.changeKeeperModified) {
            this.changesKeeperFactory.unloadChangeKeeper();
        }
        this.beginReverseSession();
        try {
            if (isHierarchic) {
                runState.setMonitorPrefix(ProjectSvn.I18N.getString("CheckInDependenciesAnalyser.ComputingComponents"));
                Collection<MObject> components = this.computeComponents(cmsNodes);
                monitor.worked(10);
                runState.setMonitorPrefix(ProjectSvn.I18N.getString("CheckInDependenciesAnalyser.ComputingDependencies"));
                this.computeDependencies(components, runState);
            } else {
                ArrayList<MObject> components = new ArrayList<MObject>(cmsNodes);
                this.computeAutomaticComponents(cmsNodes, components);
                monitor.worked(10);
                runState.setMonitorPrefix(ProjectSvn.I18N.getString("CheckInDependenciesAnalyser.ComputingDependencies"));
                this.computeDependencies(components, runState);
            }
        }
        finally {
            monitor.done();
            this.endReverseSession();
        }
        this.changeKeeperModified = true;
        return commitDetail;
    }

    private boolean addDependencies(MObject cmsNode, MObject neededBy, RunState runState) throws ReverseFailedException, InvalidCmsStateException, InterruptedException {
        MStatus childStatus;
        if (!runState.walked.add(cmsNode)) {
            return false;
        }
        this.codeReversers.reverseCode(cmsNode);
        VersionedNodeDependencies directDeps = this.getDirectDeps(cmsNode);
        MStatus status = cmsNode.getStatus();
        CommitConfigFragment commitFragment = runState.commitDetail.getFragment(cmsNode);
        if (status.isCmsToAdd()) {
            commitFragment.addCreatedElement(cmsNode);
            MObject parentNode = directDeps.getParentNode();
            if (parentNode != null) {
                if (!this.isToCommit(parentNode, true)) {
                    throw new InvalidCmsStateException(ProjectSvn.I18N.getMessage("CheckInDependenciesAnalyser.WrongState.1", new Object[]{this.symbolService.getFullName(parentNode), this.symbolService.getFullName(cmsNode)}));
                }
                this.addDependencies(parentNode, cmsNode, runState);
            }
        } else if (status.isCmsToDelete()) {
            commitFragment.addDeletedElement(new MRef(cmsNode));
        } else if (status.isCmsConflict()) {
            commitFragment.addConflictedElement(cmsNode, neededBy);
        } else if (status.isCmsManaged()) {
            if (status.isDirty() || status.isCmsModified()) {
                commitFragment.addModifiedElement(cmsNode);
            } else if (status.isLockingNeeded() && !status.isCmsReadOnly()) {
                commitFragment.addElementToUnlock(cmsNode);
            } else if (status.isDeleted()) {
                commitFragment.addDeletedElement(new MRef(cmsNode));
            }
        } else {
            if (!CommitDependenciesAnalyser.isToScan(status)) {
                return false;
            }
            if (status.isShell()) {
                ProjectSvn.LOG.warning(this.getClass().getSimpleName() + ":" + String.valueOf(neededBy) + " needs " + String.valueOf(cmsNode) + " " + String.valueOf(status));
                commitFragment.addNeededShellElement(cmsNode, neededBy);
                return false;
            }
            if (status.isDeleted()) {
                ProjectSvn.LOG.warning(this.getClass().getSimpleName() + ":" + String.valueOf(neededBy) + " needs " + String.valueOf(cmsNode) + " " + String.valueOf(status));
                return false;
            }
            commitFragment.addNeededNonVersionedElement(cmsNode, neededBy);
        }
        runState.reportProgress();
        this.addDependenciesByMove(cmsNode, runState);
        this.addRepositoryRemoveDependencies(runState, new MRef(cmsNode), cmsNode);
        for (MObject child : directDeps.getCompManagedNodes()) {
            childStatus = child.getStatus();
            if (!childStatus.isCmsToAdd()) continue;
            this.addDependencies(child, cmsNode, runState);
        }
        for (MObject child : directDeps.getCompLocalNodes()) {
            childStatus = child.getStatus();
            if (!childStatus.isCmsToAdd()) continue;
            this.addDependencies(child, cmsNode, runState);
        }
        for (MObject neededNode : directDeps.getUsedNodes()) {
            if (!this.isToCommit(neededNode, true)) continue;
            this.addDependencies(neededNode, cmsNode, runState);
        }
        for (MObject foreignObj : directDeps.getExtDeps()) {
            MObject foreignNode = CmsNodeUtils.getCmsNode(foreignObj);
            if (foreignNode == null || !this.isToCommit(foreignNode, true)) continue;
            this.addDependencies(foreignNode, cmsNode, runState);
        }
        if (CommitDependenciesAnalyser.isToScan(status)) {
            Collection<? extends MObject> otherDeps = this.getMetamodelDependencies(cmsNode, runState);
            for (MObject mObject : otherDeps) {
                MObject depCmsNode = CmsNodeUtils.getCmsNode(mObject);
                if (depCmsNode == null || !this.isToCommit(depCmsNode, true)) continue;
                this.addDependencies(depCmsNode, cmsNode, runState);
            }
        }
        return true;
    }

    private void addDependenciesByMove(MObject aNode, RunState runState) throws ReverseFailedException, InvalidCmsStateException, InterruptedException {
        ModelChangeKeeper changesKeeper = this.changesKeeperFactory.getModelChangeKeeper();
        CommitConfigFragment commitFragment = runState.commitDetail.getFragment(aNode);
        MRef aNodeRef = new MRef(aNode);
        HashSet<MRef> deletedNodes = new HashSet<MRef>();
        HashSet<String> deletedBlobs = new HashSet<String>();
        changesKeeper.getAllDeleted(aNodeRef, deletedNodes, deletedBlobs);
        for (MRef delRef : deletedNodes) {
            commitFragment.addDeletedElement(delRef);
        }
        for (String blob : deletedBlobs) {
            commitFragment.addDeletedBlob(blob);
        }
        HashSet<IElementMoveRef> elementMoves = new HashSet<IElementMoveRef>();
        changesKeeper.getMovesFrom(aNodeRef, elementMoves);
        changesKeeper.getMovesTo(aNodeRef, elementMoves);
        changesKeeper.getMoves(aNodeRef, elementMoves);
        runState.commitDetail.addMoves(elementMoves);
        for (IElementMoveRef move : elementMoves) {
            MRef newParentRef = move.getNewParent();
            MRef oldParentRef = move.getOldParent();
            MRef movedNodeRef = move.getMoved();
            MObject newParent = this.findByRef(newParentRef);
            MObject oldParent = this.findByRef(oldParentRef);
            MObject movedNode = this.findByRef(movedNodeRef);
            if (!CommitDependenciesAnalyser.isValid(newParent)) {
                this.computeDeletedElementDependencies(newParentRef, aNode, runState);
            } else if (this.isToCommit(newParent, false)) {
                this.addDependencies(newParent, aNode, runState);
            }
            if (!CommitDependenciesAnalyser.isValid(oldParent)) {
                this.computeDeletedElementDependencies(oldParentRef, aNode, runState);
            } else if (this.isToCommit(oldParent, false)) {
                this.addDependencies(oldParent, aNode, runState);
            }
            if (!CommitDependenciesAnalyser.isValid(movedNode)) continue;
            boolean movedIsCmsNode = movedNode.getMClass().isCmsNode();
            if (movedIsCmsNode && this.isToCommit(movedNode, false)) {
                this.addDependencies(movedNode, aNode, runState);
            }
            for (MObject movedChild : this.computeComponents(CmsNodeUtils.getChildren(movedNode))) {
                this.addDependencies(movedChild, movedNode, runState);
            }
        }
    }

    private Collection<MObject> computeComponents(Collection<MObject> cmsNodes) throws ReverseFailedException {
        ArrayList<MObject> components = new ArrayList<MObject>(cmsNodes.size() * 10);
        for (MObject elem : cmsNodes) {
            this.computeComponents(elem, components);
        }
        return components;
    }

    private void computeComponents(MObject in, Collection<MObject> out) throws ReverseFailedException {
        boolean isToAddDelete;
        MStatus elementStatus = in.getStatus();
        boolean bl = isToAddDelete = elementStatus.isCmsToAdd() || elementStatus.isCmsToDelete();
        if (!elementStatus.isCmsReadOnly() && (elementStatus.isCmsManaged() || isToAddDelete)) {
            this.codeReversers.reverseCode(in);
        }
        if (this.isToCommit(elementStatus, false)) {
            out.add(in);
        }
        if (CommitDependenciesAnalyser.isToScan(elementStatus)) {
            Collection<MObject> children = CmsNodeUtils.getChildren(in);
            for (MObject elem : children) {
                this.computeComponents(elem, out);
            }
        }
    }

    private void computeAutomaticComponents(Collection<MObject> ins, Collection<MObject> out) {
        for (MObject in : ins) {
            MStatus elementStatus = in.getStatus();
            if (!CommitDependenciesAnalyser.isToScan(elementStatus)) continue;
            for (MObject elem : CmsNodeUtils.getAutomaticChildren(in)) {
                if (!this.isToCommit(elem, true)) continue;
                out.add(elem);
            }
        }
    }

    private void computeDependencies(Collection<MObject> selectedElements, RunState runState) throws ReverseFailedException, InvalidCmsStateException, InterruptedException {
        for (MObject e : selectedElements) {
            this.addDependencies(e, e, runState);
        }
    }

    private boolean isToCommit(MObject el, boolean includeNonVersioned) {
        return this.isToCommit(el.getStatus(), includeNonVersioned);
    }

    private boolean isToCommit(MStatus status, boolean includeNonVersioned) {
        if (status.isCmsManaged()) {
            return status.isCmsModified() || status.isDirty() || status.isDeleted() || status.isCmsToDelete() || status.isLockingNeeded() && !status.isCmsReadOnly();
        }
        if (!CommitDependenciesAnalyser.isToScan(status)) {
            return false;
        }
        return includeNonVersioned || status.isCmsToAdd() || status.isCmsToDelete();
    }

    private static boolean isToScan(MStatus status) {
        return !status.isRamc() && !status.isPersistedRemotely() && status.isUserWrite();
    }

    private static boolean isValid(MObject obj) {
        return obj != null && obj.isValid();
    }

    private void endReverseSession() {
        this.codeReversers.endReverseSession();
    }

    private void beginReverseSession() throws ReverseFailedException {
        try {
            this.codeReversers.beginReverseSession();
        }
        catch (RuntimeException e) {
            throw new ReverseFailedException((Throwable)e);
        }
    }

    private void computeDeletedElementDependencies(MRef deletedRef, MObject neededBy, RunState runState) throws InvalidCmsStateException, ReverseFailedException, InterruptedException {
        if (runState.walkedDeleted.add(deletedRef)) {
            ModelChangeKeeper changesKeeper = this.changesKeeperFactory.getModelChangeKeeper();
            MRef oldParentRef = changesKeeper.getDeletedParent(deletedRef);
            MObject oldParent = this.findByRef(oldParentRef);
            if (oldParent != null) {
                this.addDependencies(oldParent, neededBy, runState);
            } else {
                this.computeDeletedElementDependencies(oldParentRef, neededBy, runState);
            }
        }
    }

    private MObject findByRef(MRef ref) {
        if (ref == null) {
            return null;
        }
        return this.session.getModel().findByRef(ref);
    }

    private Collection<? extends MObject> getMetamodelDependencies(MObject cmsNode, RunState runState) {
        ICmsDependencyAnalyser svc = (ICmsDependencyAnalyser)this.depAnalyserMmExt.findService(cmsNode.getMClass());
        Collection<Object> otherDeps = svc != null ? svc.getCommitDependencies(cmsNode, runState.recursive) : CmsNodeUtils.getAutomaticChildren(cmsNode);
        return otherDeps;
    }

    private void addRepositoryRemoveDependencies(RunState runState, MRef removedNodeRef, MObject neededBy) throws InterruptedException, InvalidCmsStateException, ReverseFailedException {
        RemovalRecorder rec;
        CmsVersionedRepository fromRepo;
        if (runState.walkedRemovedFromRepo.add(removedNodeRef) && (fromRepo = (rec = RemovalRecorder.get(this.gproject)).getInitialRepository(removedNodeRef)) != null) {
            CommitConfigFragment commitFragment = this.getFragment(runState.commitDetail, (IRepository)fromRepo);
            commitFragment.addDeletedElement(removedNodeRef);
            MObject removedNode = this.findByRef(removedNodeRef);
            if (removedNode != null) {
                for (String blob : this.session.getBlobSupport().getRelatedBlobs(removedNode)) {
                    commitFragment.addDeletedBlob(blob);
                }
            }
            Collection<MRef> deps = this.getBaseDependencies(fromRepo, removedNodeRef);
            for (MRef depRef : deps) {
                MObject dep = this.findByRef(depRef);
                if (CommitDependenciesAnalyser.isValid(dep)) {
                    this.addDependencies(dep, neededBy, runState);
                    this.addRepositoryRemoveDependencies(runState, depRef, neededBy);
                    continue;
                }
                this.addRepositoryRemoveDependencies(runState, depRef, neededBy);
            }
        }
    }

    private Collection<MRef> getBaseDependencies(CmsVersionedRepository repo, MRef removedNodeRef) throws InvalidCmsStateException {
        CmsNodeStruct s = this.getComponentsFromBase(removedNodeRef, repo);
        ArrayList<MRef> ret = new ArrayList<MRef>(s.getComponents());
        if (s.getParent() != null) {
            ret.add(s.getParent());
        }
        return ret;
    }

    private CmsNodeStruct getComponentsFromBase(MRef ref, CmsVersionedRepository repo) throws InvalidCmsStateException {
        ICmsDriver driver = repo.getDriver();
        File filePath = driver.getFilesGeometry().getExmlFile(ref);
        try {
            Throwable throwable = null;
            Object var6_9 = null;
            try (ByteArrayOutputStream dst = new ByteArrayOutputStream();){
                driver.getFileContent(filePath, dst, "BASE");
                return new CmsNodeStruct().readFrom(new ByteArrayInputStream(dst.toByteArray()));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new InvalidCmsStateException(FileUtils.getLocalizedMessage((IOException)e), (Throwable)e);
        }
        catch (CmsDriverException e) {
            throw new InvalidCmsStateException(e.getLocalizedMessage(), (Throwable)((Object)e));
        }
    }

    private CommitConfigFragment getFragment(CommitConfiguration commitDetail, IRepository oldChildRepo) {
        for (IGModelFragment projectFragment : this.gproject.getParts(IGModelFragment.class)) {
            if (projectFragment.getRepository() != oldChildRepo) continue;
            return commitDetail.getFragment(projectFragment);
        }
        throw new IllegalArgumentException(oldChildRepo.toString());
    }

    private static class RunState {
        private String monitorPrefix = "";
        final boolean recursive;
        final CommitConfiguration commitDetail;
        final Set<MObject> walked = new HashSet<MObject>();
        final Set<MRef> walkedDeleted = new HashSet<MRef>();
        private final IModelioProgress monitor;
        final Set<MRef> walkedRemovedFromRepo = new HashSet<MRef>();

        public RunState(CommitConfiguration commitDetail, IModelioProgress monitor, boolean recursive) {
            this.commitDetail = commitDetail;
            this.monitor = monitor;
            this.recursive = recursive;
        }

        public void setMonitorPrefix(String monitorPrefix) {
            this.monitorPrefix = monitorPrefix;
        }

        public void reportProgress() throws InterruptedException {
            int nbCreated = 0;
            int nbDeleted = 0;
            int nbModified = 0;
            for (CommitConfigFragment cf : this.commitDetail.getFragments()) {
                nbCreated += cf.getCreatedElements().size();
                nbModified += cf.getModifiedElements().size();
                nbDeleted += cf.getDeletedElements().size();
            }
            this.monitor.subTask(ProjectSvn.I18N.getMessage("CommitDependenciesAnalyser.report", new Object[]{this.monitorPrefix, this.walked.size(), nbCreated, nbModified, nbDeleted}));
            if (this.monitor.isCanceled()) {
                throw new InterruptedException();
            }
        }
    }
}

