/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.cms.engine.commands.commit;

import com.modeliosoft.modelio.cms.api.ICommitDetail;
import com.modeliosoft.modelio.cms.api.ICommitResult;
import com.modeliosoft.modelio.cms.api.ICommitResultFragment;
import com.modeliosoft.modelio.cms.api.IElementMove;
import com.modeliosoft.modelio.cms.api.IElementMoveRef;
import com.modeliosoft.modelio.cms.api.ISymbolService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.stream.Stream;
import org.modelio.vcore.smkernel.mapi.MObject;
import org.modelio.vcore.smkernel.mapi.MRef;

class CommitResult
implements ICommitResult {
    private Collection<? extends ICommitResultFragment> fragments;
    private boolean batchMode;
    private ICommitDetail details;

    public CommitResult(ICommitDetail details, Collection<? extends ICommitResultFragment> fragments, boolean batchMode) {
        this.details = details;
        this.fragments = fragments;
        this.batchMode = batchMode;
    }

    @Deprecated
    public String getCommitAuthor() {
        return this.fragments.iterator().next().getCommitAuthor();
    }

    @Deprecated
    public Date getCommitDate() {
        return this.fragments.iterator().next().getCommitDate();
    }

    @Deprecated
    public String getCommittedRevision() {
        return this.fragments.iterator().next().getCommittedRevision();
    }

    @Deprecated
    public Collection<MObject> getAddedElements() {
        ArrayList<MObject> ret = new ArrayList<MObject>();
        for (ICommitResultFragment iCommitResultFragment : this.fragments) {
            ret.addAll(iCommitResultFragment.getAddedElements());
        }
        return ret;
    }

    @Deprecated
    public Collection<MRef> getDeletedElements() {
        ArrayList<MRef> ret = new ArrayList<MRef>();
        for (ICommitResultFragment iCommitResultFragment : this.fragments) {
            ret.addAll(iCommitResultFragment.getDeletedElements());
        }
        return ret;
    }

    @Deprecated
    public Collection<MObject> getModifiedElements() {
        ArrayList<MObject> ret = new ArrayList<MObject>();
        for (ICommitResultFragment iCommitResultFragment : this.fragments) {
            ret.addAll(iCommitResultFragment.getModifiedElements());
        }
        return ret;
    }

    public Collection<IElementMove> getMoves() {
        return this.details.getMoves();
    }

    @Deprecated
    public Map<MObject, MObject> getNeededNonVersionedElements() {
        return this.details.getNeededNonVersionedElements();
    }

    public ISymbolService getSymbolService() {
        return this.details.getSymbolService();
    }

    public boolean isEmpty() {
        if (this.fragments.isEmpty()) {
            return true;
        }
        for (ICommitResultFragment iCommitResultFragment : this.fragments) {
            if (iCommitResultFragment.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public Collection<? extends ICommitResultFragment> getFragments() {
        return this.fragments;
    }

    public boolean isBatchMode() {
        return this.batchMode;
    }

    public Collection<IElementMoveRef> getMoveReferences() {
        return this.details.getMoveReferences();
    }

    public Stream<MRef> deletedElements() {
        return this.fragments.stream().flatMap(f -> f.getDeletedElements().stream());
    }
}

