/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.cms.engine.commands.commit;

import com.modeliosoft.modelio.cms.api.ICmsUnlockResult;
import com.modeliosoft.modelio.cms.api.ICommitDetailFragment;
import com.modeliosoft.modelio.cms.api.ICommitEntry;
import com.modeliosoft.modelio.cms.api.ICommitResultFragment;
import com.modeliosoft.modelio.cms.api.IGetLockResult;
import com.modeliosoft.modelio.cms.driver.ICmsCommitResult;
import com.modeliosoft.modelio.cms.engine.commands.commit.CommitEntry;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.modelio.gproject.core.IGModelFragment;
import org.modelio.vcore.session.api.model.IModel;
import org.modelio.vcore.smkernel.mapi.MObject;
import org.modelio.vcore.smkernel.mapi.MRef;

class CommitResultFragment
implements ICommitResultFragment {
    private ICommitDetailFragment commitDetails;
    private Set<MObject> createdElements = new HashSet<MObject>();
    private Set<MObject> updatedElements = new HashSet<MObject>();
    private ICmsCommitResult cmsResult;
    private IGetLockResult lockResult;

    public CommitResultFragment(ICommitDetailFragment fragAnalysis, ICmsCommitResult cmsResult, IModel model, IGetLockResult lockResult) {
        MObject el;
        this.commitDetails = fragAnalysis;
        this.cmsResult = cmsResult;
        this.lockResult = lockResult;
        for (MRef ref : cmsResult.getAddedElements()) {
            el = model.findByRef(ref);
            this.createdElements.add(el);
        }
        for (MRef ref : cmsResult.getModifiedElements()) {
            el = model.findByRef(ref);
            this.updatedElements.add(el);
        }
    }

    public String getCommitAuthor() {
        return this.cmsResult.getAuthor();
    }

    public Date getCommitDate() {
        return this.cmsResult.getCommitDate();
    }

    public String getCommittedRevision() {
        return this.cmsResult.getRevision();
    }

    public Set<MObject> getAddedElements() {
        return this.createdElements;
    }

    public Collection<MRef> getDeletedElements() {
        return this.cmsResult.getDeletedElements();
    }

    public String getMessage() {
        return this.commitDetails.getMessage();
    }

    public Collection<MObject> getModifiedElements() {
        return this.updatedElements;
    }

    public boolean isEmpty() {
        return this.cmsResult.isEmpty();
    }

    public Collection<ICommitEntry> getEntries() {
        ArrayList<ICommitEntry> modifs = new ArrayList<ICommitEntry>();
        for (MObject mObject : this.getAddedElements()) {
            modifs.add(new CommitEntry(ICommitEntry.Type.ADD, mObject, null));
        }
        for (MObject mObject : this.getModifiedElements()) {
            modifs.add(new CommitEntry(ICommitEntry.Type.UPDATE, mObject, null));
        }
        for (MRef mRef : this.getDeletedElements()) {
            modifs.add(new CommitEntry(ICommitEntry.Type.REMOVE, null, mRef));
        }
        return modifs;
    }

    public IGModelFragment getProjectFragment() {
        return this.commitDetails.getProjectFragment();
    }

    public IGetLockResult getLockResult() {
        return this.lockResult;
    }

    public ICmsUnlockResult getUnlockResult() {
        return this.cmsResult.getUnlockResult();
    }

    public Collection<File> getOtherAddedFiles() {
        return this.cmsResult.getAddedFiles();
    }

    public Collection<File> getOtherModifiedFiles() {
        return this.cmsResult.getModifiedFiles();
    }

    public Collection<File> getOtherDeletedFiles() {
        return this.cmsResult.getDeletedFiles();
    }
}

