/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.cms.engine.commands.commit;

import com.modeliosoft.modelio.cms.api.CmsException;
import com.modeliosoft.modelio.cms.api.CmsUnlockException;
import com.modeliosoft.modelio.cms.api.ICommitResult;
import com.modeliosoft.modelio.cms.api.IRefResultEntry;
import com.modeliosoft.modelio.cms.api.IRepairCommand;
import com.modeliosoft.modelio.cms.api.ISymbolService;
import com.modeliosoft.modelio.cms.api.OutdatedElementsException;
import com.modeliosoft.modelio.cms.driver.CmsDriverException;
import com.modeliosoft.modelio.cms.driver.ICmsCommitResult;
import com.modeliosoft.modelio.cms.driver.ICmsDriver;
import com.modeliosoft.modelio.cms.driver.ICmsLockResult;
import com.modeliosoft.modelio.cms.engine.ICmsEngine;
import com.modeliosoft.modelio.cms.engine.ICmsFilesGetter;
import com.modeliosoft.modelio.cms.engine.commands.commit.CommitConfigFragment;
import com.modeliosoft.modelio.cms.engine.commands.commit.CommitConfiguration;
import com.modeliosoft.modelio.cms.engine.commands.commit.CommitResult;
import com.modeliosoft.modelio.cms.engine.commands.commit.CommitResultFragment;
import com.modeliosoft.modelio.gproject.svn.fragment.GSvnFragment;
import com.modeliosoft.modelio.gproject.svn.plugin.ProjectSvn;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.modelio.gproject.core.IGModelFragment;
import org.modelio.vbasic.progress.IModelioProgress;
import org.modelio.vbasic.progress.SubProgress;
import org.modelio.vcore.smkernel.mapi.MRef;

public class RepairCommand
implements IRepairCommand {
    private Set<MRef> refsToDelete = new HashSet<MRef>();
    private ICmsDriver cmsDriver;
    private ICmsEngine engine;
    private Set<MRef> refsToLockAndDelete = new HashSet<MRef>();
    private ISymbolService symbolService;
    private ICmsFilesGetter filesGetter;
    private GSvnFragment fragment;

    public RepairCommand(ICmsEngine engine, GSvnFragment fragment) {
        this.engine = engine;
        this.fragment = fragment;
        this.cmsDriver = fragment.getCmsDriver();
        this.symbolService = this.engine.createSymbolService();
        this.filesGetter = this.cmsDriver.getFilesGetter();
    }

    public void addElementsToDelete(Collection<MRef> values) {
        this.refsToDelete.addAll(values);
    }

    public void addElementsToLockAndDelete(Collection<MRef> values) {
        this.refsToLockAndDelete.addAll(values);
    }

    public ICommitResult execute(StringBuilder report, IModelioProgress monitor) throws CmsException, CmsUnlockException, OutdatedElementsException {
        SubProgress mon = SubProgress.convert((IModelioProgress)monitor, (int)220);
        CommitConfiguration commitDetail = new CommitConfiguration(this.engine.getProject(), this.symbolService);
        CommitConfigFragment commitFragment = commitDetail.getFragment((IGModelFragment)this.fragment);
        if (this.refsToLockAndDelete.size() > 0) {
            Collection<MRef> lockedEltsToDelete = this.lockElementsToDelete(report, (IModelioProgress)mon.newChild(50));
            this.refsToDelete.addAll(lockedEltsToDelete);
        }
        mon.setWorkRemaining(170);
        this.deleteElements(report, (IModelioProgress)mon.newChild(10), commitFragment);
        mon.subTask(ProjectSvn.I18N.getString("Monitor.CheckingRepository.CommittingRepairs"));
        Collection<File> filesToDelete = this.filesGetter.getRelatedRefFiles(this.refsToDelete);
        ICmsCommitResult cmsResult = this.cmsDriver.commit((IModelioProgress)mon.newChild(160), filesToDelete, false, "Repository repairs:\n\n" + report.toString());
        CommitResultFragment resFrag = new CommitResultFragment(commitFragment, cmsResult, this.engine.getCoreSession().getModel(), null);
        CommitResult commitResult = new CommitResult(commitDetail, Collections.singletonList(resFrag), false);
        return commitResult;
    }

    private Collection<MRef> lockElementsToDelete(StringBuilder report, IModelioProgress monitor) throws CmsException {
        ICmsLockResult lockResult;
        if (this.refsToLockAndDelete.isEmpty()) {
            return this.refsToLockAndDelete;
        }
        monitor.subTask(ProjectSvn.I18N.getString("Monitor.CheckingRepository.LockingElementsToDelete"));
        try {
            Collection<File> filesToLockAndDelete = this.filesGetter.getRelatedRefFiles(this.refsToLockAndDelete);
            lockResult = this.cmsDriver.lock(monitor, filesToLockAndDelete, true, "Removing orphans elements from repository.");
        }
        catch (CmsDriverException e) {
            StringBuilder log2 = new StringBuilder();
            log2.append("ERROR locking elements: \n  ");
            log2.append(e.getLocalizedMessage());
            log2.append("\n");
            report.append("\n ");
            report.append((CharSequence)log2);
            throw new CmsException(log2.toString(), (Throwable)((Object)e));
        }
        for (MRef ref : lockResult.getAlreadyLockedElements()) {
            report.append(" - ");
            report.append(this.symbolService.getFullName(ref));
            report.append(" {");
            report.append(ref.uuid);
            report.append("} is already locked elsewhere, cannot delete it.\n");
        }
        for (IRefResultEntry failure : lockResult.getLockFailures()) {
            MRef ref = failure.getRef();
            report.append(" - ");
            report.append(this.symbolService.getFullName(ref));
            report.append(" {");
            report.append(ref.uuid);
            report.append("} :");
            report.append(failure.getMessage());
            report.append("\n");
        }
        return lockResult.getLockedElements();
    }

    private void deleteElements(StringBuilder report, IModelioProgress monitor, CommitConfigFragment commitDetail) {
        SubProgress mon = SubProgress.convert((IModelioProgress)monitor, (int)this.refsToDelete.size());
        for (MRef ref : this.refsToDelete) {
            this.symbolService.cacheSymbol(ref);
            try {
                for (File f : this.filesGetter.getRelatedRefFiles(ref)) {
                    this.cmsDriver.delete(f);
                    Files.delete(f.toPath());
                }
                commitDetail.addDeletedElement(ref);
            }
            catch (CmsException e) {
                report.append("Failed removing from version ");
                report.append(this.symbolService.getFullName(ref));
                report.append(": ");
                report.append(e.getLocalizedMessage());
                report.append("\n");
            }
            catch (IOException e) {
                report.append("Failed deleting file of ");
                report.append(this.symbolService.getFullName(ref));
                report.append(": ");
                report.append(e.getLocalizedMessage());
                report.append("\n");
            }
            mon.worked(1);
        }
    }
}

