/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.cms.engine.commands.information;

import com.modeliosoft.modelio.cms.driver.CmsDriverException;
import com.modeliosoft.modelio.cms.driver.ICmsDriver;
import com.modeliosoft.modelio.cms.driver.ICmsStatus;
import com.modeliosoft.modelio.cms.driver.IStatusSnapshot;
import com.modeliosoft.modelio.cms.engine.ICmsEngine;
import com.modeliosoft.modelio.cms.engine.commands.information.InformationDetail;
import com.modeliosoft.modelio.cms.engine.recorder.ModelChangeKeeper;
import com.modeliosoft.modelio.cms.model.ModelGroup;
import com.modeliosoft.modelio.cms.model.ModelGroups;
import com.modeliosoft.modelio.cms.utils.CmsNodeUtils;
import com.modeliosoft.modelio.gproject.svn.plugin.ProjectSvn;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.modelio.vbasic.progress.IModelioProgress;
import org.modelio.vbasic.progress.SubProgress;
import org.modelio.vcore.session.api.ICoreSession;
import org.modelio.vcore.smkernel.mapi.MObject;
import org.modelio.vcore.smkernel.mapi.MRef;
import org.modelio.vcore.smkernel.mapi.MStatus;

public class InformationEngine {
    private ICmsEngine engine;
    private ICoreSession coreSession;

    public InformationEngine(ICmsEngine engine) {
        this.engine = engine;
        this.coreSession = engine.getCoreSession();
    }

    public InformationDetail execute(Collection<MObject> selectedElements, IModelioProgress aMonitor) throws CmsDriverException {
        ArrayList<MObject> all = new ArrayList<MObject>(selectedElements);
        for (MObject el : selectedElements) {
            all.addAll(CmsNodeUtils.getAllChildren(el));
        }
        ModelGroups grps = new ModelGroups(all);
        grps.assertSingle();
        grps.assertAllSvn();
        SubProgress monitor = SubProgress.convert((IModelioProgress)aMonitor, (String)"", (int)(all.size() + grps.size() * 50));
        InformationDetail detail = new InformationDetail();
        for (ModelGroup group : grps) {
            if (!group.isSvnFragment()) {
                for (MObject el : group.getElements()) {
                    detail.notVersionedElements.add(el);
                }
                continue;
            }
            ICmsDriver driver = group.getSvnFragment().getCmsDriver();
            monitor.subTask(ProjectSvn.I18N.getString("Monitor.Information.GetSnapShot"));
            IStatusSnapshot snap = driver.getStatusDriver().getStatusSnapShot((IModelioProgress)monitor.newChild(50), true);
            monitor.subTask(ProjectSvn.I18N.getMessage("Monitor.Information.Sorting", new Object[]{String.valueOf(all.size())}));
            for (MObject el : all) {
                MStatus status = el.getStatus();
                ICmsStatus cmsStatus = snap.get(new MRef(el));
                if (cmsStatus != null && status.isCmsManaged()) {
                    if (cmsStatus.getLock() == null) {
                        detail.notLockedElements.add(el);
                    } else if (cmsStatus.getLock().isSelf()) {
                        detail.lockedBySelfElements.put(el, cmsStatus.getLock());
                    } else {
                        detail.lockedByOtherElements.put(el, cmsStatus.getLock());
                    }
                    if (cmsStatus.needsUpdate()) {
                        detail.elementsToUpdate.add(el);
                    }
                } else if (status.isCmsToAdd()) {
                    detail.cmsAddedElements.add(el);
                } else {
                    detail.notVersionedElements.add(el);
                }
                this.addRefactoring(el, detail);
                monitor.worked(1);
            }
        }
        return detail;
    }

    private void addRefactoring(MObject aNode, InformationDetail detail) {
        ModelChangeKeeper changesKeeper = this.engine.getModelChangeKeeper();
        HashSet<MRef> deletedNodes = new HashSet<MRef>();
        HashSet<String> deletedBlobs = new HashSet<String>();
        MRef nodeRef = new MRef(aNode);
        changesKeeper.getAllDeleted(nodeRef, deletedNodes, deletedBlobs);
        for (MRef e : deletedNodes) {
            detail.deletedInModelElements.add(e);
        }
        changesKeeper.getMovesFrom(nodeRef, detail.elementMoves);
        changesKeeper.getMovesTo(nodeRef, detail.elementMoves);
        changesKeeper.getMoves(nodeRef, detail.elementMoves);
    }
}

