/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.cms.engine.commands.lock;

import com.modeliosoft.modelio.cms.api.CmsException;
import com.modeliosoft.modelio.cms.api.ICmsUnlockResult;
import com.modeliosoft.modelio.cms.api.IRefResultEntry;
import com.modeliosoft.modelio.cms.api.admin.IBreakLockCommand;
import com.modeliosoft.modelio.cms.api.admin.IBreakLockReporter;
import com.modeliosoft.modelio.cms.driver.CmsDriverException;
import com.modeliosoft.modelio.cms.driver.ICmsDriver;
import com.modeliosoft.modelio.cms.model.ModelGroup;
import com.modeliosoft.modelio.cms.model.ModelGroups;
import com.modeliosoft.modelio.gproject.svn.fragment.GSvnFragment;
import java.util.ArrayList;
import java.util.Collection;
import org.modelio.gproject.core.IGModelFragment;
import org.modelio.vbasic.progress.IModelioProgress;
import org.modelio.vcore.smkernel.mapi.MObject;
import org.modelio.vcore.smkernel.mapi.MRef;

public class BreakLockCommand
implements IBreakLockCommand {
    private GSvnFragment fragment;
    private Collection<MRef> refs = new ArrayList<MRef>();

    public void addRefs(IGModelFragment aFragment, Collection<MRef> toBreak) {
        if (this.fragment == null) {
            this.fragment = (GSvnFragment)aFragment;
        } else if (this.fragment != aFragment) {
            throw new IllegalArgumentException("Cannot mix many fragments.");
        }
        this.refs.addAll(toBreak);
    }

    public void addElements(Collection<MObject> el) {
        ModelGroups groups = new ModelGroups(el);
        groups.assertSingle();
        groups.assertAllSvn();
        for (ModelGroup group : groups) {
            if (this.fragment == null) {
                this.fragment = group.getSvnFragment();
                continue;
            }
            if (this.fragment == group.getSvnFragment()) continue;
            throw new IllegalArgumentException("Cannot mix many fragments.");
        }
        for (MObject o : el) {
            this.refs.add(new MRef(o));
        }
    }

    public void execute(IBreakLockReporter reporter, IModelioProgress monitor) {
        try {
            ICmsDriver driver = this.fragment.getCmsDriver();
            ICmsUnlockResult res = driver.unlock(monitor, driver.getFilesGetter().getRelatedRefFiles(this.refs), true);
            for (MRef ref : res.getLockedElseWhereElements()) {
                reporter.reportFailure(ref);
            }
            for (IRefResultEntry entry : res.getLockFailures()) {
                reporter.reportError(entry.getRef(), new CmsException(entry.getMessage()));
            }
            for (MRef ref : res.getUnlockedElements()) {
                reporter.reportSuccess(ref);
            }
        }
        catch (CmsDriverException e) {
            reporter.reportFatalError((CmsException)e);
        }
    }
}

