/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.cms.engine.commands.lock;

import com.modeliosoft.modelio.cms.api.CmsException;
import com.modeliosoft.modelio.cms.api.IGetLockCommand;
import com.modeliosoft.modelio.cms.api.IGetLockResult;
import com.modeliosoft.modelio.cms.api.IRefResultEntry;
import com.modeliosoft.modelio.cms.api.ISymbolService;
import com.modeliosoft.modelio.cms.api.contrib.IGetLockConfig;
import com.modeliosoft.modelio.cms.api.metadata.MetadataUtil;
import com.modeliosoft.modelio.cms.api.mmextension.ICmsDependencyAnalyser;
import com.modeliosoft.modelio.cms.driver.CmsDriverException;
import com.modeliosoft.modelio.cms.driver.ICmsDriver;
import com.modeliosoft.modelio.cms.driver.ICmsLock;
import com.modeliosoft.modelio.cms.driver.ICmsLockResult;
import com.modeliosoft.modelio.cms.driver.ICmsResultFileEntry;
import com.modeliosoft.modelio.cms.driver.ICmsStatus;
import com.modeliosoft.modelio.cms.driver.IStatusSnapshot;
import com.modeliosoft.modelio.cms.engine.ICmsEngine;
import com.modeliosoft.modelio.cms.engine.commands.lock.CanBeLockedFilter;
import com.modeliosoft.modelio.cms.engine.commands.lock.GetLockResult;
import com.modeliosoft.modelio.cms.model.ModelGroup;
import com.modeliosoft.modelio.cms.model.ModelGroups;
import com.modeliosoft.modelio.cms.utils.CmsNodeUtils;
import com.modeliosoft.modelio.gproject.svn.plugin.ProjectSvn;
import java.io.File;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.modelio.vbasic.progress.IModelioProgress;
import org.modelio.vbasic.progress.SubProgress;
import org.modelio.vcore.session.api.ICoreSession;
import org.modelio.vcore.session.api.model.IModel;
import org.modelio.vcore.session.api.transactions.ITransaction;
import org.modelio.vcore.smkernel.mapi.MObject;
import org.modelio.vcore.smkernel.mapi.MRef;
import org.modelio.vcore.smkernel.mapi.services.MetamodelExtensionPoint;

public class GetLockCommand
implements IGetLockCommand,
IGetLockConfig {
    private static final int GLOBAL_LOCK_THRESHOLD = 20;
    private boolean batchMode = true;
    private String comment = "";
    private boolean isRecursive = true;
    private boolean stealLocks = false;
    private boolean useProcessExtension = true;
    private ICoreSession coreSession;
    private Set<MObject> elements = new HashSet<MObject>();
    private ICmsEngine engine;
    private Collection<File> additionalFiles = new HashSet<File>();
    private MetamodelExtensionPoint<ICmsDependencyAnalyser> depAnalyserMmExt;

    public GetLockCommand(ICmsEngine engine) {
        this.engine = engine;
        this.coreSession = this.engine.getCoreSession();
        this.depAnalyserMmExt = this.engine.getMetamodelExtensions().getDependencyAnalyser();
    }

    public void addElement(MObject el) {
        this.elements.add(el);
    }

    public void addElements(Collection<MObject> el) {
        this.elements.addAll(el);
    }

    public IGetLockResult execute(IModelioProgress iMonitor) throws CmsException {
        if (!this.useProcessExtension()) {
            return this.doExecute(iMonitor);
        }
        SubProgress monitor = SubProgress.convert((IModelioProgress)iMonitor, (String)ProjectSvn.I18N.getString("Monitor.CheckOut"), (int)4);
        if (!this.engine.getHook().preGetLock((IModelioProgress)monitor.newChild(1), (IGetLockCommand)this)) {
            return null;
        }
        try {
            IGetLockResult result = this.doExecute((IModelioProgress)monitor);
            this.engine.getHook().postGetLock(result);
            return result;
        }
        catch (CmsException | RuntimeException e) {
            this.engine.getHook().postGetLockFailed((IGetLockCommand)this, (Exception)e);
            throw e;
        }
    }

    public String getComment() {
        return this.comment;
    }

    public IGetLockConfig getConfiguration() {
        return this;
    }

    public Set<MObject> getElements() {
        return Collections.unmodifiableSet(this.elements);
    }

    public boolean isBatchMode() {
        return this.batchMode;
    }

    public boolean isRecursive() {
        return this.isRecursive;
    }

    public void setBatch(boolean batchMode) {
        this.batchMode = batchMode;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public boolean setRecursive(boolean isRecursive) {
        boolean changed = this.isRecursive ^ isRecursive;
        this.isRecursive = isRecursive;
        return changed;
    }

    public void setStealLocks(boolean stealLocks) {
        this.stealLocks = stealLocks;
    }

    public void setUseProcessExtension(boolean val) {
        this.useProcessExtension = val;
    }

    public boolean useProcessExtension() {
        return this.useProcessExtension;
    }

    protected IGetLockResult doExecute(IModelioProgress iMonitor) throws CmsException {
        if (this.elements.isEmpty()) {
            return this.doExecuteEmpty();
        }
        ModelGroups sel = new ModelGroups(this.elements);
        if (!sel.areAllSvn()) {
            throw new IllegalArgumentException("Only versioned elements are allowed.");
        }
        SubProgress monitor = SubProgress.convert((IModelioProgress)iMonitor, (String)ProjectSvn.I18N.getString("Monitor.CheckOut"), (int)310);
        monitor.subTask(ProjectSvn.I18N.getString("Monitor.CheckOut.ComputingComponents"));
        Collection<MObject> elementsToLock = this.computeDependencies();
        monitor.worked(50);
        ModelGroups groups = new ModelGroups(elementsToLock);
        GetLockResult lockResult = new GetLockResult(this.engine.createSymbolService(), this.isBatchMode());
        monitor.setWorkRemaining(groups.size() + (this.additionalFiles.isEmpty() ? 0 : 6));
        String metaComment = this.addMetadataToComment(this.comment);
        for (ModelGroup g : groups.getGroups()) {
            SubProgress mon2 = SubProgress.convert((IModelioProgress)monitor.newChild(1), (int)110);
            List<MObject> toLock = g.getElements();
            Throwable throwable = null;
            Object var13_14 = null;
            try (ITransaction t = this.coreSession.getTransactionSupport().createTransaction("Get SVN lock.");){
                ICmsDriver cmsDriver = g.getSvnFragment().getCmsDriver();
                Collection<File> filesToLock = cmsDriver.getFilesGetter().getRelatedFiles(toLock);
                ICmsLockResult cmsLockResult = cmsDriver.lock((IModelioProgress)mon2.newChild(50), filesToLock, this.stealLocks, metaComment);
                this.fillGetLockResult((IModelioProgress)mon2.newChild(10), cmsLockResult, cmsDriver, lockResult);
                monitor.subTask(ProjectSvn.I18N.getString("Monitor.other.CommitTransaction"));
                t.commit();
                mon2.worked(50);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        if (!this.additionalFiles.isEmpty()) {
            ICmsDriver cmsDriver = this.engine.getCmsDriver(this.additionalFiles.iterator().next());
            ICmsLockResult cmsLockResult = cmsDriver.lock((IModelioProgress)monitor.newChild(5), this.additionalFiles, this.stealLocks, metaComment);
            this.fillGetLockResult((IModelioProgress)monitor.newChild(1), cmsLockResult, cmsDriver, lockResult);
        }
        return lockResult;
    }

    private String addMetadataToComment(String comments) {
        return MetadataUtil.addMetadata((MetadataUtil.SVNMetadata)MetadataUtil.SVNMetadata.PROJECT_NAME, (String)this.engine.getProject().getDescriptor().getName(), (String)comments);
    }

    private static ICmsLockResult callLock(IModelioProgress aMonitor, ICmsDriver cmsDriver, Collection<MObject> elementsToCheckOut, boolean stealLocks, String comment) throws CmsDriverException {
        Collection<File> filesToLock = cmsDriver.getFilesGetter().getRelatedFiles(elementsToCheckOut);
        return cmsDriver.lock(aMonitor, filesToLock, stealLocks, comment);
    }

    private IGetLockResult doExecuteEmpty() {
        GetLockResult ret = new GetLockResult(this.engine.createSymbolService(), this.isBatchMode());
        return ret;
    }

    private void fillGetLockResult(IModelioProgress aMonitor, ICmsLockResult cmsLockResult, ICmsDriver cmsDriver, GetLockResult lockDetails) {
        MObject element;
        IModel model = this.engine.getCoreSession().getModel();
        for (MRef ref : cmsLockResult.getLockedElements()) {
            try {
                element = model.findByRef(ref);
                if (element != null) {
                    lockDetails.lockedElements.add(element);
                    continue;
                }
                lockDetails.lockedUnresolved.put(ref, String.valueOf(ref) + " not found");
            }
            catch (IllegalArgumentException e) {
                lockDetails.lockedUnresolved.put(ref, e.toString());
                ProjectSvn.LOG.info("Locked an obsolete reference :" + String.valueOf(ref) + "(" + e.toString() + ")");
            }
        }
        if (!cmsLockResult.getOutdatedElements().isEmpty()) {
            for (MRef ref : cmsLockResult.getOutdatedElements()) {
                element = null;
                try {
                    element = model.findByRef(ref);
                }
                catch (IllegalArgumentException illegalArgumentException) {}
                if (element != null) {
                    lockDetails.outdatedElements.add(element);
                    continue;
                }
                lockDetails.outdatedUnresolvedReferences.add(ref);
            }
        }
        if (!cmsLockResult.getAlreadyLockedElements().isEmpty() || !cmsLockResult.getAlreadyLockedFiles().isEmpty()) {
            try {
                aMonitor.subTask(ProjectSvn.I18N.getString("Monitor.other.GettingStatusSnaphot"));
                IStatusSnapshot snapshot = null;
                if (cmsLockResult.getAlreadyLockedElements().size() < 20) {
                    Collection<File> relatedRefFiles = cmsDriver.getFilesGetter().getRelatedRefFiles(cmsLockResult.getAlreadyLockedElements());
                    snapshot = cmsDriver.getStatusDriver().asyncGetStatusBatch(relatedRefFiles, true).get();
                } else {
                    snapshot = cmsDriver.getStatusDriver().getStatusSnapShot(aMonitor, true);
                }
                ISymbolService symb = this.engine.createSymbolService();
                for (MRef ref : cmsLockResult.getAlreadyLockedElements()) {
                    ICmsLock lockStatus;
                    MObject element2 = null;
                    try {
                        element2 = model.findByRef(ref);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                    ICmsStatus cmsStatus = snapshot.get(ref);
                    if (cmsStatus == null) {
                        for (File file : cmsDriver.getFilesGetter().getRelatedRefFiles(ref)) {
                            cmsStatus = snapshot.get(file);
                            if (cmsStatus != null) break;
                        }
                    }
                    ICmsLock iCmsLock = lockStatus = cmsStatus == null ? null : cmsStatus.getLock();
                    if (lockStatus != null) {
                        String ownerLabel;
                        boolean selfLock;
                        boolean bl = selfLock = lockStatus.isLocal() && lockStatus.getOwner().equals(cmsDriver.getUser());
                        if (element2 == null) {
                            if (selfLock) {
                                lockDetails.lockedUnresolved.put(ref, String.valueOf(ref) + " not found");
                                continue;
                            }
                            ownerLabel = this.engine.getUserLabelProvider().getUserLabel(lockStatus.getOwner());
                            lockDetails.failuresOnUnresolved.put(ref, ProjectSvn.I18N.getMessage("CheckOut.LockedBy", new Object[]{symb.getName(ref), ownerLabel, DateFormat.getDateTimeInstance().format(lockStatus.getDate()), MetadataUtil.getMetadata((MetadataUtil.SVNMetadata)MetadataUtil.SVNMetadata.PROJECT_NAME, (String)lockStatus.getReason()), MetadataUtil.getOriginalComment((String)lockStatus.getReason())}));
                            continue;
                        }
                        if (selfLock) {
                            lockDetails.lockedElements.add(element2);
                            continue;
                        }
                        ownerLabel = this.engine.getUserLabelProvider().getUserLabel(lockStatus.getOwner());
                        lockDetails.failures.put(element2, ProjectSvn.I18N.getMessage("CheckOut.LockedBy", new Object[]{symb.getName(element2), ownerLabel, DateFormat.getDateTimeInstance().format(lockStatus.getDate()), MetadataUtil.getMetadata((MetadataUtil.SVNMetadata)MetadataUtil.SVNMetadata.PROJECT_NAME, (String)lockStatus.getReason()), MetadataUtil.getOriginalComment((String)lockStatus.getReason())}));
                        continue;
                    }
                    if (element2 == null) {
                        lockDetails.failuresOnUnresolved.put(ref, ProjectSvn.I18N.getMessage("CheckOut.LockedBy", new Object[]{symb.getName(ref), "<unknown>", "<unknown>", "", ""}));
                        continue;
                    }
                    lockDetails.failures.put(element2, ProjectSvn.I18N.getMessage("CheckOut.LockedBy", new Object[]{symb.getName(element2), "<unknown>", "<unknown>", "", ""}));
                }
                for (File file : cmsLockResult.getAlreadyLockedFiles()) {
                    ICmsLock lockStatus;
                    ICmsStatus cmsStatus = snapshot.get(file);
                    ICmsLock iCmsLock = lockStatus = cmsStatus == null ? null : cmsStatus.getLock();
                    if (lockStatus != null) {
                        boolean selfLock;
                        boolean bl = selfLock = lockStatus.isLocal() && lockStatus.getOwner().equals(cmsDriver.getUser());
                        if (selfLock) {
                            lockDetails.lockedAdditional.add(file);
                            continue;
                        }
                        String ownerLabel = this.engine.getUserLabelProvider().getUserLabel(lockStatus.getOwner());
                        lockDetails.failuresOnAdditional.put(file, ProjectSvn.I18N.getMessage("CheckOut.LockedBy", new Object[]{file, ownerLabel, DateFormat.getDateTimeInstance().format(lockStatus.getDate()), MetadataUtil.getMetadata((MetadataUtil.SVNMetadata)MetadataUtil.SVNMetadata.PROJECT_NAME, (String)lockStatus.getReason()), MetadataUtil.getOriginalComment((String)lockStatus.getReason())}));
                        continue;
                    }
                    lockDetails.failuresOnAdditional.put(file, ProjectSvn.I18N.getMessage("CheckOut.LockedBy", new Object[]{file, "<unknown>", "<unknown>", "", ""}));
                }
            }
            catch (CmsDriverException | InterruptedException | ExecutionException e) {
                ProjectSvn.LOG.error((Throwable)e);
                MRef ref = cmsLockResult.getAlreadyLockedElements().iterator().next();
                element = model.findByRef(ref);
                lockDetails.failures.put(element, ((Throwable)e).toString());
            }
        }
        for (IRefResultEntry failure : cmsLockResult.getLockFailures()) {
            element = model.findByRef(failure.getRef());
            lockDetails.failures.put(element, failure.getMessage());
        }
        for (ICmsResultFileEntry entry : cmsLockResult.getFileLockFailures()) {
            lockDetails.failuresOnAdditional.put(entry.getFile(), entry.getMessage());
        }
    }

    private Collection<MObject> computeDependencies() {
        ArrayList<MObject> elementsToLock;
        CanBeLockedFilter filter = new CanBeLockedFilter();
        if (this.isRecursive()) {
            elementsToLock = CmsNodeUtils.collectAll(this.elements, filter, o -> CmsNodeUtils.getChildren(o), this::getMetamodelDependencies);
            elementsToLock.addAll(this.elements);
        } else {
            elementsToLock = new ArrayList(this.elements.size());
            for (MObject el : this.elements) {
                if (!filter.accept(el)) continue;
                elementsToLock.add(el);
                for (MObject mObject : this.getMetamodelDependencies(el)) {
                    if (!filter.accept(mObject)) continue;
                    elementsToLock.add(mObject);
                }
            }
        }
        return elementsToLock;
    }

    public void addFiles(Collection<File> f) {
        this.additionalFiles.addAll(f);
    }

    public Collection<File> getAdditionalFiles() {
        return Collections.unmodifiableCollection(this.additionalFiles);
    }

    private Collection<? extends MObject> getMetamodelDependencies(MObject el) {
        ICmsDependencyAnalyser svc = (ICmsDependencyAnalyser)this.depAnalyserMmExt.findService(el.getMClass());
        if (svc == null) {
            return CmsNodeUtils.getAutomaticChildren(el);
        }
        return svc.getLockingDependencies(el, this.isRecursive);
    }
}

