/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.cms.engine.commands.lock;

import com.modeliosoft.modelio.cms.api.IGetLockResult;
import com.modeliosoft.modelio.cms.api.ISymbolService;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.modelio.vcore.smkernel.mapi.MObject;
import org.modelio.vcore.smkernel.mapi.MRef;

class GetLockResult
implements IGetLockResult {
    Map<MObject, String> failures = new HashMap<MObject, String>();
    Map<MRef, String> lockedUnresolved = new HashMap<MRef, String>();
    Map<MRef, String> failuresOnUnresolved = new HashMap<MRef, String>();
    Map<File, String> failuresOnAdditional = new HashMap<File, String>();
    private final boolean batchMode;
    Collection<MObject> lockedElements = new ArrayList<MObject>();
    ISymbolService symbolService;
    Collection<MObject> outdatedElements = new ArrayList<MObject>();
    Collection<MRef> outdatedUnresolvedReferences = new ArrayList<MRef>();
    Collection<File> lockedAdditional = new ArrayList<File>();
    Collection<File> outdatedAdditional = new ArrayList<File>();

    GetLockResult(ISymbolService symbolService, boolean batchMode) {
        this.symbolService = symbolService;
        this.batchMode = batchMode;
    }

    public Map<MObject, String> getLockFailures() {
        return this.failures;
    }

    public Map<MRef, String> getUnresolvedLockFailures() {
        return this.failuresOnUnresolved;
    }

    public Collection<MObject> getLockedElements() {
        return this.lockedElements;
    }

    public Map<MRef, String> getLockedUnresolvedReferences() {
        return this.lockedUnresolved;
    }

    public ISymbolService getSymbolService() {
        return this.symbolService;
    }

    public Collection<MObject> getOutdatedElements() {
        return this.outdatedElements;
    }

    public Collection<MRef> getOutdatedUnresolvedReferences() {
        return this.outdatedUnresolvedReferences;
    }

    public void merge(IGetLockResult src) {
        this.failures.putAll(src.getLockFailures());
        this.lockedElements.addAll(src.getLockedElements());
        this.lockedUnresolved.putAll(src.getLockedUnresolvedReferences());
        this.outdatedElements.addAll(src.getOutdatedElements());
        this.outdatedUnresolvedReferences.addAll(src.getOutdatedUnresolvedReferences());
        this.failuresOnUnresolved.putAll(src.getUnresolvedLockFailures());
    }

    public boolean hasFailures() {
        return !this.failures.isEmpty() || !this.outdatedElements.isEmpty() || !this.outdatedUnresolvedReferences.isEmpty() || !this.failuresOnUnresolved.isEmpty();
    }

    public boolean isBatchMode() {
        return this.batchMode;
    }

    public Collection<File> getAdditionalLockedFiles() {
        return this.lockedAdditional;
    }

    public Map<File, String> getAdditionalLockFailures() {
        return this.failuresOnAdditional;
    }

    public Collection<File> getAdditionalOutdatedFiles() {
        return this.outdatedAdditional;
    }
}

