/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.cms.engine.commands.merge;

import com.modeliosoft.modelio.cms.api.CmsException;
import com.modeliosoft.modelio.cms.api.CmsRevisionRange;
import com.modeliosoft.modelio.cms.api.IMergeCommand;
import com.modeliosoft.modelio.cms.api.IUpdateDetails;
import com.modeliosoft.modelio.cms.api.contrib.IMergeConfig;
import com.modeliosoft.modelio.cms.driver.ICmsUpdateResult;
import com.modeliosoft.modelio.cms.engine.ICmsEngine;
import com.modeliosoft.modelio.cms.engine.commands.update.UpdateResult;
import com.modeliosoft.modelio.gproject.svn.fragment.GSvnFragment;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.modelio.gproject.core.IGModelFragment;
import org.modelio.vbasic.progress.IModelioProgress;
import org.modelio.vcore.session.api.model.IModel;
import org.modelio.vcore.smkernel.mapi.MObject;

public class MergeCommand
implements IMergeCommand,
IMergeConfig {
    private String mergeSourceUrl;
    private boolean useProcessExtension = true;
    private boolean batchMode = true;
    private ICmsEngine engine;
    private GSvnFragment targetFragment;
    private List<CmsRevisionRange> revisions = new ArrayList<CmsRevisionRange>();

    public String getMergeSourceUrl() {
        return this.mergeSourceUrl;
    }

    public void setMergeSourceUrl(String aSvnUrl) {
        this.mergeSourceUrl = aSvnUrl;
    }

    public List<CmsRevisionRange> getRevisions() {
        return this.revisions;
    }

    public MergeCommand(ICmsEngine engine) {
        this.engine = engine;
    }

    public void setFragment(IGModelFragment fragment) {
        this.targetFragment = (GSvnFragment)fragment;
    }

    public IUpdateDetails execute(IModelioProgress iMonitor) throws CmsException {
        assert (this.targetFragment != null);
        assert (this.mergeSourceUrl != null && !this.mergeSourceUrl.isEmpty());
        ICmsUpdateResult updateResult = this.targetFragment.getCmsDriver().merge(iMonitor, this.mergeSourceUrl, null, this.getRevisions());
        IModel imodel = this.engine.getCoreSession().getModel();
        return new UpdateResult(imodel, this.engine.createSymbolService(), false).add(updateResult);
    }

    public boolean isBatchMode() {
        return this.batchMode;
    }

    public void setUseProcessExtension(boolean val) {
        this.useProcessExtension = val;
    }

    public void setBatch(boolean batchMode) {
        this.batchMode = batchMode;
    }

    public boolean useProcessExtension() {
        return this.useProcessExtension;
    }

    public IMergeConfig getConfiguration() {
        return this;
    }

    public GSvnFragment getTargetFragment() {
        return this.targetFragment;
    }

    public Collection<MObject> getElements() {
        return Collections.unmodifiableCollection(this.targetFragment.getRoots());
    }
}

