/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.cms.engine.commands.remove;

import com.modeliosoft.modelio.cms.api.CmsException;
import com.modeliosoft.modelio.cms.api.IRemoveCommand;
import com.modeliosoft.modelio.cms.api.contrib.IRemoveConfig;
import com.modeliosoft.modelio.cms.driver.ICmsDriver;
import com.modeliosoft.modelio.cms.engine.ICmsEngine;
import com.modeliosoft.modelio.cms.model.ModelGroup;
import com.modeliosoft.modelio.cms.model.ModelGroups;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.modelio.vbasic.progress.IModelioProgress;
import org.modelio.vcore.session.api.ICoreSession;
import org.modelio.vcore.session.api.transactions.ITransaction;
import org.modelio.vcore.smkernel.mapi.MObject;

public class RemoveCommand
implements IRemoveCommand,
IRemoveConfig {
    private boolean batchMode = true;
    private boolean useProcessExtension = true;
    private ICmsEngine engine;
    private ICoreSession coreSession;
    private Collection<MObject> selectedElements = new HashSet<MObject>();
    private Collection<File> additionalFilesToRemove = new HashSet<File>();

    public RemoveCommand(ICmsEngine engine) {
        this.engine = engine;
        this.coreSession = this.engine.getCoreSession();
    }

    public void execute(List<MObject> elementsToRemove, IModelioProgress iMonitor) throws CmsException {
        this.addElements(elementsToRemove);
        this.execute(iMonitor);
    }

    public void setBatch(boolean batchMode) {
        this.batchMode = batchMode;
    }

    public boolean isBatchMode() {
        return this.batchMode;
    }

    public void setUseProcessExtension(boolean val) {
        this.useProcessExtension = val;
    }

    public boolean useProcessExtension() {
        return this.useProcessExtension;
    }

    public void execute(IModelioProgress monitor) throws CmsException {
        ModelGroups sel = new ModelGroups(this.selectedElements);
        sel.assertAllSvn();
        sel.assertSingle();
        Throwable throwable = null;
        Object var4_5 = null;
        try (ITransaction t = this.coreSession.getTransactionSupport().createTransaction("Remove element from version");){
            for (ModelGroup grp : ModelGroups.makeSvnGroups(this.selectedElements)) {
                ICmsDriver cmsDriver = grp.getSvnFragment().getCmsDriver();
                for (File f : cmsDriver.getFilesGetter().getRelatedFiles(grp.getElements())) {
                    cmsDriver.delete(f);
                }
                grp.getSvnFragment().getCmsRepository().refreshStatus(grp.getElements());
            }
            t.commit();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        if (!this.additionalFilesToRemove.isEmpty()) {
            ICmsDriver cmsDriver = this.engine.getCmsDriver(this.additionalFilesToRemove.iterator().next());
            cmsDriver.delete(monitor, this.additionalFilesToRemove);
        }
    }

    public IRemoveConfig getConfiguration() {
        return this;
    }

    public Collection<MObject> getElements() {
        return Collections.unmodifiableCollection(this.selectedElements);
    }

    public void addElements(Collection<MObject> elementsToRemove) {
        this.selectedElements.addAll(elementsToRemove);
    }

    public void addFiles(Collection<File> files) {
        this.additionalFilesToRemove.addAll(files);
    }

    public void addElement(MObject elementToRemove) {
        this.selectedElements.add(elementToRemove);
    }
}

