/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.cms.engine.commands.revert;

import com.modeliosoft.modelio.cms.api.IRevertDetail;
import com.modeliosoft.modelio.cms.api.IRevertFragmentDetail;
import com.modeliosoft.modelio.cms.driver.CmsDriverException;
import com.modeliosoft.modelio.cms.driver.ICmsDriver;
import com.modeliosoft.modelio.cms.driver.ICmsStatus;
import com.modeliosoft.modelio.cms.engine.ICmsEngine;
import com.modeliosoft.modelio.cms.engine.commands.revert.RevertFragmentDetails;
import com.modeliosoft.modelio.cms.engine.recorder.AssociatedFileChangeRecorder;
import java.io.File;
import java.util.Map;
import org.modelio.vcore.smkernel.mapi.MObject;
import org.modelio.vcore.smkernel.mapi.MRef;

class RevertAssociatedFilesAnalyser {
    private AssociatedFileChangeRecorder recorder;
    private ICmsEngine engine;

    public RevertAssociatedFilesAnalyser(ICmsEngine engine) {
        this.engine = engine;
        this.recorder = engine.getModelChangeKeeper().getFilesRecorder();
    }

    public void run(IRevertDetail revertDetail) throws CmsDriverException {
        for (IRevertFragmentDetail irfDetail : revertDetail.getFragments()) {
            MRef ref;
            final RevertFragmentDetails rfDetail = (RevertFragmentDetails)irfDetail;
            AssociatedFileChangeRecorder.MoveHandler moveHandler = new AssociatedFileChangeRecorder.MoveHandler(){

                @Override
                public void handle(MRef ref, String key, File oldFile, File newFile) throws CmsDriverException {
                    rfDetail.addAssociatedFile(ref, oldFile);
                }
            };
            for (MRef ref2 : irfDetail.getUndeletedElements()) {
                this.addFiles(ref2, this.recorder.getAllFileDeletions(ref2), rfDetail);
                this.addFiles(ref2, this.recorder.getAllFileModifs(ref2), rfDetail);
                this.recorder.forAllFileMoves(ref2, moveHandler);
            }
            for (MObject obj : irfDetail.getDeletedElements()) {
                ref = new MRef(obj);
                this.addFiles(ref, this.recorder.getAllFileDeletions(ref), rfDetail);
                this.addFiles(ref, this.recorder.getAllFileModifs(ref), rfDetail);
                this.recorder.forAllFileMoves(ref, moveHandler);
            }
            for (MObject obj : irfDetail.getModifiedElements()) {
                ref = new MRef(obj);
                this.addFiles(ref, this.recorder.getAllFileDeletions(ref), rfDetail);
                this.addFiles(ref, this.recorder.getAllFileModifs(ref), rfDetail);
                this.recorder.forAllFileMoves(ref, moveHandler);
            }
        }
    }

    private void addFiles(MRef ref, Map<String, File> m, RevertFragmentDetails conf) throws CmsDriverException {
        for (Map.Entry<String, File> entry : m.entrySet()) {
            this.addFile(ref, conf, entry.getKey(), entry.getValue());
        }
    }

    private void addToCreatedOrModified(MRef ref, Map<String, File> m, RevertFragmentDetails conf) throws CmsDriverException {
        for (Map.Entry<String, File> entry : m.entrySet()) {
            this.addFile(ref, conf, entry.getKey(), entry.getValue());
        }
    }

    protected void addFile(MRef ref, RevertFragmentDetails conf, String key, File file) throws CmsDriverException {
        ICmsDriver cmsDriver = this.engine.getCmsDriver(file);
        ICmsStatus st = cmsDriver.getStatusDriver().getStatus(file, false);
        if (st != null && (st.isToAdd() || st.isVersioned() || st.isToDelete())) {
            conf.addAssociatedFile(ref, file);
        }
    }

    public void cleanFilesRecorder(IRevertDetail revertDetail) {
        for (IRevertFragmentDetail irfDetail : revertDetail.getFragments()) {
            MRef ref;
            for (MRef ref2 : irfDetail.getUndeletedElements()) {
                this.recorder.popAllFileDeletions(ref2);
                this.recorder.popAllFileModifs(ref2);
                this.recorder.popAllFileMoves(ref2);
            }
            for (MObject obj : irfDetail.getDeletedElements()) {
                ref = new MRef(obj);
                this.recorder.popAllFileDeletions(ref);
                this.recorder.popAllFileModifs(ref);
                this.recorder.popAllFileMoves(ref);
            }
            for (MObject obj : irfDetail.getModifiedElements()) {
                ref = new MRef(obj);
                this.recorder.popAllFileDeletions(ref);
                this.recorder.popAllFileModifs(ref);
                this.recorder.popAllFileMoves(ref);
            }
        }
    }
}

