/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.cms.engine.commands.revert;

import com.modeliosoft.modelio.cms.api.CmsException;
import com.modeliosoft.modelio.cms.api.ICmsUnlockResult;
import com.modeliosoft.modelio.cms.api.IElementMove;
import com.modeliosoft.modelio.cms.api.IRefResultEntry;
import com.modeliosoft.modelio.cms.api.IRevertCommand;
import com.modeliosoft.modelio.cms.api.IRevertDetail;
import com.modeliosoft.modelio.cms.api.IRevertFragmentDetail;
import com.modeliosoft.modelio.cms.api.IRevertFragmentResult;
import com.modeliosoft.modelio.cms.api.IRevertResult;
import com.modeliosoft.modelio.cms.api.ISymbolService;
import com.modeliosoft.modelio.cms.api.TransactionStillOpenException;
import com.modeliosoft.modelio.cms.api.contrib.IRevertConfig;
import com.modeliosoft.modelio.cms.api.mmextension.ICmsDependencyAnalyser;
import com.modeliosoft.modelio.cms.driver.CmsDriverException;
import com.modeliosoft.modelio.cms.driver.ICmsDriver;
import com.modeliosoft.modelio.cms.engine.ICmsEngine;
import com.modeliosoft.modelio.cms.engine.ICmsFilesGetter;
import com.modeliosoft.modelio.cms.engine.commands.revert.RevertAssociatedFilesAnalyser;
import com.modeliosoft.modelio.cms.engine.commands.revert.RevertDependenciesAnalyser;
import com.modeliosoft.modelio.cms.engine.commands.revert.RevertFragmentResult;
import com.modeliosoft.modelio.cms.engine.commands.revert.RevertResult;
import com.modeliosoft.modelio.cms.engine.recorder.ModelChangeKeeper;
import com.modeliosoft.modelio.cms.model.ModelGroups;
import com.modeliosoft.modelio.cms.repository.CmsVersionedRepository;
import com.modeliosoft.modelio.cms.utils.SubversionUtils;
import com.modeliosoft.modelio.gproject.svn.fragment.recorder.RemovalRecorder;
import com.modeliosoft.modelio.gproject.svn.plugin.ProjectSvn;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.modelio.metamodel.mmextensions.standard.facilities.CompositionInitializer;
import org.modelio.vbasic.files.FileUtils;
import org.modelio.vbasic.log.Log;
import org.modelio.vbasic.progress.IModelioProgress;
import org.modelio.vbasic.progress.SubProgress;
import org.modelio.vcore.session.api.ICoreSession;
import org.modelio.vcore.session.api.blob.BlobChangeEvent;
import org.modelio.vcore.session.api.blob.IBlobChangeEvent;
import org.modelio.vcore.session.api.blob.IBlobInfo;
import org.modelio.vcore.session.api.model.IModel;
import org.modelio.vcore.session.api.repository.BasicRepositoryChangeEvent;
import org.modelio.vcore.session.api.repository.BlobServices;
import org.modelio.vcore.session.api.repository.IRepository;
import org.modelio.vcore.session.api.repository.IRepositoryChangeEvent;
import org.modelio.vcore.session.api.transactions.ConcurrentTransactionException;
import org.modelio.vcore.session.api.transactions.ITransaction;
import org.modelio.vcore.session.api.transactions.ITransactionSupport;
import org.modelio.vcore.session.api.transactions.TransactionForbiddenException;
import org.modelio.vcore.smkernel.AccessDeniedException;
import org.modelio.vcore.smkernel.SmObjectImpl;
import org.modelio.vcore.smkernel.mapi.MObject;
import org.modelio.vcore.smkernel.mapi.MRef;
import org.modelio.vcore.smkernel.mapi.services.MetamodelExtensionPoint;
import org.modelio.vstore.exml.resource.ExmlFileAccess;

public final class RevertCommand
implements IRevertCommand,
IRevertConfig {
    private boolean isRecursive;
    private boolean releaseLocks = true;
    private boolean batchMode = true;
    private boolean useProcessExtension = true;
    private final ICmsEngine engine;
    private final IModel iModel;
    private final RevertDependenciesAnalyser dependenciesAnalyser;
    private IRevertDetail revertDetails = null;
    private Collection<MObject> selection = new HashSet<MObject>();
    private RevertResult result;
    private final ISymbolService symbolService;
    private final ITransactionSupport tm;
    private Collection<File> additionalFilesToRevert = new HashSet<File>();

    public RevertCommand(ICmsEngine engine) {
        ICoreSession coreSession = engine.getCoreSession();
        this.engine = engine;
        this.iModel = coreSession.getModel();
        this.tm = coreSession.getTransactionSupport();
        this.symbolService = this.engine.createSymbolService();
        this.dependenciesAnalyser = new RevertDependenciesAnalyser(coreSession, this.engine, this.symbolService, (MetamodelExtensionPoint<ICmsDependencyAnalyser>)this.engine.getMetamodelExtensions().getDependencyAnalyser());
    }

    private IRevertResult doExecute(IModelioProgress aMonitor) throws CmsException, TransactionStillOpenException {
        this.engine.checkTransactionStack();
        if (!this.getDetails().getFatalErrors().isEmpty()) {
            IllegalStateException ex = new IllegalStateException("Fatal errors occurred during dependency analysis");
            for (Throwable t : this.getDetails().getFatalErrors()) {
                ex.addSuppressed(t);
            }
            throw ex;
        }
        ModelGroups sel = new ModelGroups(this.getSelection());
        sel.assertAllSvn();
        SubProgress monitor = SubProgress.convert((IModelioProgress)aMonitor, (int)60);
        Log.trace((String)("Running " + String.valueOf(this)));
        RevertAssociatedFilesAnalyser revertAssociatedFilesAnalyser = new RevertAssociatedFilesAnalyser(this.engine);
        revertAssociatedFilesAnalyser.run(this.getDetails());
        monitor.worked(5);
        Throwable throwable = null;
        Object var6_10 = null;
        try (ICmsEngine.ILEnabler cl = this.engine.suspendModelListeners();){
            IRepository repository;
            this.result = new RevertResult(this.iModel, this.symbolService, this.isBatchMode());
            this.result.init(this.revertDetails);
            HashSet<IBlobInfo> allModifiedBlobs = new HashSet<IBlobInfo>();
            HashSet<IBlobInfo> allUndeletedBlobs = new HashSet<IBlobInfo>();
            HashSet<IBlobInfo> allDeletedBlobs = new HashSet<IBlobInfo>();
            for (IRevertFragmentDetail fragmentDetail : this.getDetails().getFragments()) {
                repository = fragmentDetail.getRepository();
                if (repository instanceof CmsVersionedRepository) {
                    this.doRevert(monitor, fragmentDetail, revertAssociatedFilesAnalyser, allModifiedBlobs, allUndeletedBlobs, allDeletedBlobs);
                    continue;
                }
                RevertFragmentResult resultFrag = this.result.getFragment(repository);
                for (MObject obj : fragmentDetail.getDeletedElements()) {
                    resultFrag.addErrorOn(new MRef(obj), ProjectSvn.I18N.getMessage("RevertCommand.unsupported.deleted", new Object[]{obj, repository}));
                }
                for (MObject obj : fragmentDetail.getModifiedElements()) {
                    resultFrag.addErrorOn(new MRef(obj), ProjectSvn.I18N.getMessage("RevertCommand.unsupported.modified", new Object[]{obj, repository}));
                }
                for (MRef ref : fragmentDetail.getUndeletedElements()) {
                    resultFrag.addErrorOn(ref, ProjectSvn.I18N.getMessage("RevertCommand.unsupported.undeleted", new Object[]{ref, repository}));
                }
            }
            for (IRevertFragmentDetail fragmentDetail : this.getDetails().getFragments()) {
                for (MObject todel : fragmentDetail.getDeletedElements()) {
                    SmObjectImpl smobjToDel = (SmObjectImpl)todel;
                    smobjToDel.getRepositoryObject().unload(smobjToDel);
                }
            }
            for (IRevertFragmentDetail fragmentDetail : this.getDetails().getFragments()) {
                repository = fragmentDetail.getRepository();
                if (!(repository instanceof CmsVersionedRepository)) continue;
                ArrayList<MObject> toReload = new ArrayList<MObject>(fragmentDetail.getModifiedElements());
                CmsVersionedRepository r = (CmsVersionedRepository)repository;
                r.refreshModel(toReload, Collections.emptyList(), fragmentDetail.getUndeletedElements());
                r.refreshStatus(toReload);
                ArrayList<MObject> undeletedEls = new ArrayList<MObject>(fragmentDetail.getUndeletedElements().size());
                for (MRef ref : fragmentDetail.getUndeletedElements()) {
                    MObject o = this.engine.getCoreSession().getModel().findByRef(ref);
                    if (o == null) continue;
                    undeletedEls.add(o);
                }
                r.refreshStatus(undeletedEls);
                BasicRepositoryChangeEvent event = new BasicRepositoryChangeEvent((IRepository)r, IRepositoryChangeEvent.Granularity.CMSNODE);
                event.getCreatedElements().addAll(fragmentDetail.getUndeletedElements());
                event.getModifiedElements().addAll(RevertCommand.toMRef(fragmentDetail.getModifiedElements()));
                event.getDeletedElements().addAll(RevertCommand.toMRef(fragmentDetail.getDeletedElements()));
                event.getCreatedBlobs().addAll(fragmentDetail.getUndeletedBlobs());
                event.getDeletedBlobs().addAll(this.findBlobs(fragmentDetail.getDeletedElements()));
                event.getModifiedBlobs().addAll(this.findBlobs(fragmentDetail.getModifiedElements()));
                r.getModelLoaderProvider().fireRepositoryChange((IRepositoryChangeEvent)event);
            }
            this.saveModelChangeKeeper();
            try {
                this.engine.getCoreSession().save((IModelioProgress)monitor.newChild(5));
            }
            catch (IOException e) {
                ProjectSvn.LOG.error(e);
                MRef ref = new MRef(this.selection.iterator().next());
                this.result.addErrorOn(ref, FileUtils.getLocalizedMessage((IOException)e));
            }
            SubversionUtils.deduplicate(allUndeletedBlobs, allDeletedBlobs, allModifiedBlobs);
            BlobChangeEvent blobEvent = new BlobChangeEvent(allUndeletedBlobs, allDeletedBlobs, allModifiedBlobs);
            this.result.setBlobChanges((IBlobChangeEvent)blobEvent);
            this.engine.getCoreSession().getBlobSupport().fireBlobsChanged((IBlobChangeEvent)blobEvent);
            return this.result;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static boolean isValid(MObject el) {
        return !el.isDeleted() && !el.isShell();
    }

    private void doUnlock(Collection<File> filesToUnlock, boolean breakLock, ICmsDriver cmsDriver, SubProgress subMonitor) {
        subMonitor.setWorkRemaining(filesToUnlock.size());
        try {
            ICmsUnlockResult cmsResult = cmsDriver.unlock((IModelioProgress)subMonitor, filesToUnlock, breakLock);
            for (MRef errRef : cmsResult.getLockedElseWhereElements()) {
                this.result.addErrorOn(errRef, "Locked by someone");
            }
            for (IRefResultEntry entry : cmsResult.getLockFailures()) {
                this.result.addErrorOn(entry.getRef(), entry.getMessage());
            }
        }
        catch (CmsDriverException e) {
            this.result.addFatalError(e);
        }
    }

    private boolean callPreRevert(IModelioProgress monitor) {
        return this.engine.getHook().preRevert(monitor, (IRevertCommand)this);
    }

    public void addElements(Collection<MObject> elementsToAdd, IModelioProgress monitor) {
        this.selection.addAll(elementsToAdd);
        this.revertDetails = this.dependenciesAnalyser.execute(this.selection, this.isRecursive(), monitor);
    }

    public boolean doReleaseLocks() {
        return this.releaseLocks;
    }

    public IRevertDetail getDetails() {
        return this.revertDetails;
    }

    public Collection<MObject> getSelection() {
        return Collections.unmodifiableCollection(this.selection);
    }

    public boolean isRecursive() {
        return this.isRecursive;
    }

    public void setRecursive(boolean isRecursive, IModelioProgress monitor) {
        if (this.isRecursive != isRecursive) {
            this.isRecursive = isRecursive;
            this.revertDetails = this.dependenciesAnalyser.execute(this.selection, this.isRecursive, monitor);
        }
    }

    public void setReleaseLocks(boolean releaseLocks) {
        this.releaseLocks = releaseLocks;
    }

    private void saveModelChangeKeeper() {
        try {
            ModelChangeKeeper changeKeeper = this.engine.getModelChangeKeeper();
            changeKeeper.removeMoves(this.revertDetails.getMoveReferences());
            changeKeeper.removeAllDeletedRef(this.revertDetails.getFragments().stream().flatMap(f -> f.getUndeletedElements().stream()));
            changeKeeper.save();
            RemovalRecorder rec = RemovalRecorder.get(this.engine.getProject());
            for (IRevertFragmentResult rf : this.result.getFragments()) {
                Stream<MRef> toclean = Stream.concat(rf.getDeletedElements().stream(), rf.getCreatedElements().stream().map(obj -> new MRef(obj)));
                rec.removeRecords(toclean);
            }
        }
        catch (IOException e) {
            this.result.addFatalError(new CmsException((Throwable)e));
        }
    }

    private Collection<String> findBlobs(Collection<MObject> elements) {
        ArrayList<String> ret = new ArrayList<String>(elements.size() * 2);
        for (MObject obj : elements) {
            ret.addAll(this.engine.getCoreSession().getBlobSupport().getRelatedBlobs(obj));
        }
        return ret;
    }

    @Deprecated
    private boolean revertMovedOutElements() {
        boolean ok = true;
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (ITransaction t = this.tm.createTransaction("Revert moved out elements");){
                for (IElementMove move : this.getDetails().getMoves()) {
                    String msg;
                    SmObjectImpl moved = (SmObjectImpl)move.getMoved();
                    SmObjectImpl oldParent = (SmObjectImpl)move.getOldParent();
                    if (moved == null || oldParent == null) continue;
                    try {
                        new CompositionInitializer(oldParent).execute(moved, null);
                    }
                    catch (AccessDeniedException e) {
                        msg = ProjectSvn.I18N.getMessage("RevertCommand.CannotMoveBack", new Object[]{this.symbolService.getName((MObject)moved), this.symbolService.getFullName((MObject)oldParent), this.symbolService.getFullName(move.getNewParent()), e.getLocalizedMessage()});
                        this.result.addErrorOn(new MRef((MObject)moved), msg);
                        ok = false;
                    }
                    catch (RuntimeException e) {
                        msg = ProjectSvn.I18N.getMessage("RevertCommand.CannotMoveBack", new Object[]{this.symbolService.getName((MObject)moved), this.symbolService.getFullName((MObject)oldParent), this.symbolService.getFullName(move.getNewParent()), e.toString()});
                        this.result.addErrorOn(new MRef((MObject)moved), msg);
                        ok = false;
                    }
                }
                if (ok) {
                    t.commit();
                } else {
                    t.rollback();
                }
                return ok;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (ConcurrentTransactionException | TransactionForbiddenException e) {
            Log.error((Throwable)e);
            this.result.addFatalError(new CmsException(e.getLocalizedMessage(), e));
            return false;
        }
    }

    public void addFiles(Collection<File> filesToRevert) {
        this.additionalFilesToRevert.addAll(filesToRevert);
    }

    public IRevertConfig getConfiguration() {
        return this;
    }

    public IRevertResult execute(IModelioProgress monitor) throws CmsException, TransactionStillOpenException {
        SubProgress mon = SubProgress.convert((IModelioProgress)monitor, (int)40);
        if (this.useProcessExtension() && !this.callPreRevert((IModelioProgress)mon.newChild(1))) {
            return null;
        }
        IRevertResult aresult = this.doExecute((IModelioProgress)mon);
        if (this.useProcessExtension()) {
            this.engine.getHook().postRevert(aresult);
        }
        return aresult;
    }

    public void setBatch(boolean batchMode) {
        this.batchMode = batchMode;
    }

    public boolean isBatchMode() {
        return this.batchMode;
    }

    public void setUseProcessExtension(boolean val) {
        this.useProcessExtension = val;
    }

    public boolean useProcessExtension() {
        return this.useProcessExtension;
    }

    private static Collection<MRef> toMRef(Collection<MObject> lobj) {
        return lobj.stream().map(o -> new MRef(o)).collect(Collectors.toList());
    }

    public String toString() {
        try {
            return this.getClass().getSimpleName() + ": " + this.getDetails().toString();
        }
        catch (RuntimeException e) {
            return this.getClass().getSimpleName() + ": " + e.toString();
        }
    }

    private void doRevert(SubProgress monitor, IRevertFragmentDetail fragmentDetail, RevertAssociatedFilesAnalyser revertAssociatedFilesAnalyser, Collection<IBlobInfo> allModifiedBlobs, Collection<IBlobInfo> allUndeletedBlobs, Collection<IBlobInfo> allDeletedBlobs) throws CmsDriverException {
        CmsVersionedRepository repo = (CmsVersionedRepository)fragmentDetail.getRepository();
        ICmsDriver cmsDriver = repo.getDriver();
        ICmsFilesGetter filesGetter = cmsDriver.getFilesGetter();
        ExmlFileAccess geom = cmsDriver.getFilesGeometry();
        HashSet elementsToRevert = new HashSet();
        elementsToRevert.addAll(fragmentDetail.getDeletedElements());
        elementsToRevert.addAll(fragmentDetail.getModifiedElements());
        monitor.worked(5);
        Collection<String> modifiedBlobKeys = this.findBlobs(fragmentDetail.getModifiedElements());
        Collection<String> deletedBlobKeys = this.findBlobs(fragmentDetail.getDeletedElements());
        Set undeletedBlobKeys = fragmentDetail.getUndeletedBlobs();
        HashSet<File> filesToRevert = new HashSet<File>(elementsToRevert.size());
        for (MObject el : elementsToRevert) {
            MRef ref = new MRef(el);
            filesToRevert.add(geom.getExmlFile(el));
            this.symbolService.cacheSymbol(ref);
        }
        Collection deletedBlobs = BlobServices.loadBlobInfos(deletedBlobKeys, (IRepository)repo);
        filesToRevert.addAll(filesGetter.getExmlFiles(fragmentDetail.getUndeletedElements()));
        filesToRevert.addAll(filesGetter.getBlobFiles(modifiedBlobKeys));
        filesToRevert.addAll(filesGetter.getBlobFiles(deletedBlobKeys));
        filesToRevert.addAll(filesGetter.getBlobFiles(undeletedBlobKeys));
        filesToRevert.addAll(fragmentDetail.getAssociatedFiles());
        filesToRevert.addAll(this.additionalFilesToRevert);
        monitor.worked(5);
        monitor.subTask(ProjectSvn.I18N.getMessage("Monitor.Revert.RevertFiles", new Object[]{filesToRevert.size()}));
        cmsDriver.revert((IModelioProgress)monitor.newChild(15), filesToRevert);
        revertAssociatedFilesAnalyser.cleanFilesRecorder(this.revertDetails);
        if (this.doReleaseLocks() && !filesToRevert.isEmpty()) {
            this.doUnlock(filesToRevert, false, cmsDriver, monitor.newChild(15));
        }
        Collection modifiedBlobs = BlobServices.loadBlobInfos(modifiedBlobKeys, (IRepository)repo);
        Collection undeletedBlobs = BlobServices.loadBlobInfos((Collection)undeletedBlobKeys, (IRepository)repo);
        allModifiedBlobs.addAll(modifiedBlobs);
        allDeletedBlobs.addAll(deletedBlobs);
        allUndeletedBlobs.addAll(undeletedBlobs);
        BlobChangeEvent blobEvent = new BlobChangeEvent(undeletedBlobs, deletedBlobs, modifiedBlobs);
        this.result.getFragment(fragmentDetail.getRepository()).setBlobChanges((IBlobChangeEvent)blobEvent);
    }
}

