/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.cms.engine.commands.revert;

import com.modeliosoft.modelio.cms.api.CmsException;
import com.modeliosoft.modelio.cms.api.IElementMoveRef;
import com.modeliosoft.modelio.cms.api.IRevertDetail;
import com.modeliosoft.modelio.cms.api.ISymbolService;
import com.modeliosoft.modelio.cms.api.mmextension.ICmsDependencyAnalyser;
import com.modeliosoft.modelio.cms.driver.CmsDriverException;
import com.modeliosoft.modelio.cms.driver.ICmsDriver;
import com.modeliosoft.modelio.cms.driver.parse.CmsNodeStruct;
import com.modeliosoft.modelio.cms.engine.IModelChangeKeeperFactory;
import com.modeliosoft.modelio.cms.engine.commands.revert.RevertDetails;
import com.modeliosoft.modelio.cms.engine.commands.revert.RevertFragmentDetails;
import com.modeliosoft.modelio.cms.engine.recorder.ModelChangeKeeper;
import com.modeliosoft.modelio.cms.repository.CmsVersionedRepository;
import com.modeliosoft.modelio.cms.utils.CmsNodeUtils;
import com.modeliosoft.modelio.gproject.svn.fragment.recorder.RemovalRecorder;
import com.modeliosoft.modelio.gproject.svn.plugin.ProjectSvn;
import com.modeliosoft.modelio.gproject.svn.plugin.ProjectSvnLogger;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.modelio.vbasic.files.FileUtils;
import org.modelio.vbasic.progress.IModelioProgress;
import org.modelio.vbasic.progress.SubProgress;
import org.modelio.vcore.session.api.ICoreSession;
import org.modelio.vcore.session.api.blob.IBlobSupport;
import org.modelio.vcore.session.api.repository.IRepository;
import org.modelio.vcore.session.api.repository.IRepositorySupport;
import org.modelio.vcore.smkernel.DeadObjectException;
import org.modelio.vcore.smkernel.SmObjectImpl;
import org.modelio.vcore.smkernel.mapi.MObject;
import org.modelio.vcore.smkernel.mapi.MRef;
import org.modelio.vcore.smkernel.mapi.MStatus;
import org.modelio.vcore.smkernel.mapi.services.MetamodelExtensionPoint;
import org.modelio.vstore.exml.versioned.VersionedNodeDependencies;

final class RevertDependenciesAnalyser {
    private static final boolean TRACE = false;
    private boolean isHierarchic;
    private final IModelChangeKeeperFactory changesKeeperFactory;
    private RevertDetails result;
    private final ISymbolService symbolService;
    private final Map<MObject, VersionedNodeDependencies> directDepsCache = new HashMap<MObject, VersionedNodeDependencies>();
    private final ProjectSvnLogger logger;
    private final IRepositorySupport repositorySupport;
    private final IBlobSupport blobSupport;
    private MetamodelExtensionPoint<ICmsDependencyAnalyser> depAnalyserMmExt;
    private final ICoreSession session;

    RevertDependenciesAnalyser(ICoreSession session, IModelChangeKeeperFactory changesKeeperFactory, ISymbolService symbolService, MetamodelExtensionPoint<ICmsDependencyAnalyser> depAnalyserMmExt) {
        this.depAnalyserMmExt = depAnalyserMmExt;
        this.repositorySupport = session.getRepositorySupport();
        this.blobSupport = session.getBlobSupport();
        this.changesKeeperFactory = changesKeeperFactory;
        this.symbolService = symbolService;
        this.logger = ProjectSvn.LOG;
        this.session = session;
    }

    public Collection<MObject> computeComponents(Collection<MObject> cmsNodes) {
        ArrayList<MObject> components = new ArrayList<MObject>(cmsNodes.size() * 10);
        for (MObject elem : cmsNodes) {
            this.computeComponents(elem, components);
        }
        return components;
    }

    public IRevertDetail execute(Collection<MObject> cmsNodes, boolean isHierarchic_, IModelioProgress iMonitor) {
        this.isHierarchic = isHierarchic_;
        this.result = new RevertDetails(this.symbolService, this.session);
        if (cmsNodes.isEmpty()) {
            return this.result;
        }
        try {
            SubProgress monitor = SubProgress.convert((IModelioProgress)iMonitor, (int)20);
            if (this.isHierarchic) {
                monitor.subTask(ProjectSvn.I18N.getString("RevertDependenciesAnalyser.ComputingComponents"));
                Collection<MObject> components = this.computeComponents(cmsNodes);
                monitor.worked(10);
                this.computeDependencies(components, (IModelioProgress)monitor.newChild(10));
            } else {
                ProjectSvn.I18N.getString("RevertDependenciesAnalyser.ComputingComponents");
                HashSet<MObject> components = new HashSet<MObject>(cmsNodes);
                for (MObject node : cmsNodes) {
                    this.computeMetamodelDependencies(node, components);
                }
                monitor.worked(10);
                this.computeDependencies(components, (IModelioProgress)monitor.newChild(10));
            }
            monitor.done();
        }
        catch (CmsException | InterruptedException e) {
            this.result.addFatalError(e);
        }
        return this.result;
    }

    private boolean computeDependencies(MObject cmsNode, RunState runState) throws CmsException, InterruptedException {
        if (!runState.neededNodes.add(cmsNode)) {
            return false;
        }
        if (runState.monitor.isCanceled()) {
            throw new InterruptedException();
        }
        runState.reportProgress();
        VersionedNodeDependencies directDeps = this.getDirectDeps(cmsNode);
        MStatus status = cmsNode.getStatus();
        RevertFragmentDetails resultFragment = this.result.getFragment(cmsNode);
        if (status.isCmsToAdd()) {
            if (!status.isDeleted()) {
                resultFragment.addDeletedElement(cmsNode);
                MObject parentNode = directDeps.getParentNode();
                if (parentNode != null && this.computeDependencies(parentNode, runState)) {
                    // empty if block
                }
            }
        } else {
            resultFragment.addModifiedElement(cmsNode);
        }
        this.addDependenciesByMove(cmsNode, runState);
        this.addRepositoryRemoveDependencies(new MRef(cmsNode), runState);
        Stream children = Stream.concat(directDeps.getCompManagedNodes().stream(), directDeps.getCompManagedNodes().stream());
        for (MObject child : children::iterator) {
            MStatus childStatus = child.getStatus();
            if ((childStatus.isCmsToAdd() || childStatus.isCmsToDelete() || childStatus.isShell()) && !this.computeDependencies(child, runState)) continue;
        }
        for (MObject neededNode : directDeps.getUsedNodes()) {
            if (this.isDepToRevert(neededNode) && !this.computeDependencies(neededNode, runState)) continue;
        }
        return true;
    }

    private Collection<MObject> computeComponents(MObject in, Collection<MObject> out) {
        if (RevertDependenciesAnalyser.isCompToRevert(in)) {
            out.add(in);
        }
        Collection<MObject> children = CmsNodeUtils.getChildren(in);
        for (MObject elem : children) {
            this.computeComponents(elem, out);
        }
        this.computeMetamodelDependencies(in, out);
        return out;
    }

    private void computeDependencies(Collection<MObject> selectedElements, IModelioProgress monitor) throws CmsException, InterruptedException {
        RunState runState = new RunState(monitor);
        runState.setMonitorPrefix(ProjectSvn.I18N.getString("RevertDependenciesAnalyser.ComputingDependencies"));
        for (MObject e : selectedElements) {
            this.computeDependencies(e, runState);
        }
    }

    private void computeMetamodelDependencies(MObject in, Collection<MObject> out) {
        MStatus elementStatus = in.getStatus();
        if (!elementStatus.isRamc()) {
            ICmsDependencyAnalyser svc = (ICmsDependencyAnalyser)this.depAnalyserMmExt.findService(in.getMClass());
            Collection<Object> moreDeps = svc != null ? svc.getRevertDependencies(in, this.isHierarchic) : CmsNodeUtils.getAutomaticChildren(in);
            for (MObject elem : moreDeps) {
                if (!RevertDependenciesAnalyser.isCompToRevert(elem)) continue;
                out.add(elem);
            }
        }
    }

    private void addDependenciesByMove(MObject aNode, RunState runState) throws CmsException, InterruptedException {
        ModelChangeKeeper changesKeeper = this.changesKeeperFactory.getModelChangeKeeper();
        RevertFragmentDetails aNodeResultFragment = this.result.getFragment(aNode);
        HashSet<MRef> deletedNodes = new HashSet<MRef>();
        HashSet<String> deletedBlobs = new HashSet<String>();
        MRef aNodeRef = new MRef(aNode);
        changesKeeper.getAllDeleted(aNodeRef, deletedNodes, deletedBlobs);
        for (MRef e : deletedNodes) {
            aNodeResultFragment.addUndeletedRef(e);
        }
        aNodeResultFragment.addUndeletedBlobs(deletedBlobs);
        HashSet<IElementMoveRef> elementMoves = new HashSet<IElementMoveRef>();
        changesKeeper.getMovesFrom(aNodeRef, elementMoves);
        changesKeeper.getMovesTo(aNodeRef, elementMoves);
        changesKeeper.getMoves(aNodeRef, elementMoves);
        this.result.addMoves(elementMoves);
        for (IElementMoveRef move : elementMoves) {
            MRef newParentRef = move.getNewParent();
            MRef oldParentRef = move.getOldParent();
            MRef movedNodeRef = move.getMoved();
            MObject newParent = this.findByRef(newParentRef);
            MObject oldParent = this.findByRef(oldParentRef);
            MObject movedNode = this.findByRef(movedNodeRef);
            if (!RevertDependenciesAnalyser.isValid(newParent)) {
                this.computeDeletedElementDependencies(newParentRef, runState);
            } else if (this.isDepToRevert(newParent)) {
                this.computeDependencies(newParent, runState);
            }
            if (!RevertDependenciesAnalyser.isValid(oldParent)) {
                this.computeDeletedElementDependencies(oldParentRef, runState);
            } else if (this.isDepToRevert(oldParent)) {
                this.computeDependencies(oldParent, runState);
            }
            if (!RevertDependenciesAnalyser.isValid(movedNode) || !movedNode.getMClass().isCmsNode() || !this.isDepToRevert(movedNode)) continue;
            this.computeDependencies(movedNode, runState);
            for (MObject comp : this.computeComponents(movedNode, new ArrayList<MObject>())) {
                if (!this.isDepToRevert(comp)) continue;
                this.computeDependencies(comp, runState);
            }
        }
    }

    private VersionedNodeDependencies getDirectDeps(MObject el) {
        VersionedNodeDependencies ret = this.directDepsCache.get(el);
        if (ret == null) {
            ret = new VersionedNodeDependencies((SmObjectImpl)el);
            this.directDepsCache.put(el, ret);
        }
        return ret;
    }

    private boolean isDepToRevert(MObject el) {
        MStatus status = el.getStatus();
        if (status.isCmsToDelete()) {
            return true;
        }
        if (status.isCmsToAdd()) {
            return false;
        }
        if (status.isCmsManaged() && !status.isCmsReadOnly()) {
            return status.isCmsModified() || status.isDirty();
        }
        return false;
    }

    private static boolean isCompToRevert(MObject el) {
        block5: {
            MStatus status;
            block6: {
                block4: {
                    try {
                        status = el.getStatus();
                        if (!status.isCmsToAdd() && !status.isCmsToDelete() && !status.isShell()) break block4;
                        return true;
                    }
                    catch (DeadObjectException deadObjectException) {
                        return false;
                    }
                }
                if (!status.isCmsManaged()) break block5;
                if (!status.isCmsModified() && !status.isDirty() && !status.isCmsConflict()) break block6;
                return true;
            }
            return status.isLockingNeeded() && !status.isCmsReadOnly();
        }
        return false;
    }

    private static boolean isValid(MObject el) {
        return el != null && el.isValid();
    }

    private void computeDeletedElementDependencies(MRef deletedRef, RunState runState) throws CmsException, InterruptedException {
        ModelChangeKeeper changesKeeper = this.changesKeeperFactory.getModelChangeKeeper();
        MRef oldParentRef = changesKeeper.getDeletedParent(deletedRef);
        MObject oldParent = this.findByRef(oldParentRef);
        if (oldParent != null) {
            this.computeDependencies(oldParent, runState);
        } else {
            this.computeDeletedElementDependencies(oldParentRef, runState);
        }
    }

    private MObject findByRef(MRef ref) {
        if (ref == null) {
            return null;
        }
        return this.session.getModel().findByRef(ref);
    }

    private void addRepositoryRemoveDependencies(MRef aNodeRef, RunState runState) throws InterruptedException, CmsException {
        RemovalRecorder rec;
        CmsVersionedRepository initalRepo;
        if (runState.walkedRemovedFromRepo.add(aNodeRef) && (initalRepo = (rec = RemovalRecorder.get(this.session)).getInitialRepository(aNodeRef)) != null) {
            RevertFragmentDetails initRevertFragment = this.result.getFragment((IRepository)initalRepo);
            initRevertFragment.addUndeletedRef(aNodeRef);
            MObject removedNode = this.findByRef(aNodeRef);
            if (removedNode != null) {
                IRepository curRepo = this.repositorySupport.getRepository(removedNode);
                RevertFragmentDetails curRevertFragment = this.result.getFragment(curRepo);
                initRevertFragment.addUndeletedBlobs(this.session.getBlobSupport().getRelatedBlobs(removedNode));
                curRevertFragment.addDeletedElement(removedNode);
            }
            Collection<MRef> deps = this.getBaseDependencies(initalRepo, aNodeRef);
            for (MRef depRef : deps) {
                this.addRepositoryRemoveDependencies(depRef, runState);
                MObject dep = this.findByRef(depRef);
                if (!RevertDependenciesAnalyser.isValid(dep)) continue;
                this.computeDependencies(dep, runState);
            }
        }
    }

    private Collection<MRef> getBaseDependencies(CmsVersionedRepository repo, MRef removedNodeRef) throws CmsException {
        CmsNodeStruct s = this.getComponentsFromBase(removedNodeRef, repo);
        ArrayList<MRef> ret = new ArrayList<MRef>(s.getComponents());
        if (s.getParent() != null) {
            ret.add(s.getParent());
        }
        return ret;
    }

    private CmsNodeStruct getComponentsFromBase(MRef ref, CmsVersionedRepository repo) throws CmsException {
        ICmsDriver driver = repo.getDriver();
        File filePath = driver.getFilesGeometry().getExmlFile(ref);
        try {
            Throwable throwable = null;
            Object var6_9 = null;
            try (ByteArrayOutputStream dst = new ByteArrayOutputStream();){
                driver.getFileContent(filePath, dst, "BASE");
                return new CmsNodeStruct().readFrom(new ByteArrayInputStream(dst.toByteArray()));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new CmsException(FileUtils.getLocalizedMessage((IOException)e), (Throwable)e);
        }
        catch (CmsDriverException e) {
            throw new CmsDriverException(e.getLocalizedMessage(), (Throwable)((Object)e));
        }
    }

    private static class RunState {
        private String monitorPrefix = "";
        private final IModelioProgress monitor;
        final Set<MObject> neededNodes = new HashSet<MObject>();
        final Set<MRef> walkedRemovedFromRepo = new HashSet<MRef>();

        public RunState(IModelioProgress monitor) {
            this.monitor = monitor;
        }

        public void setMonitorPrefix(String monitorPrefix) {
            this.monitorPrefix = monitorPrefix;
        }

        public void reportProgress() throws InterruptedException {
            this.monitor.subTask(ProjectSvn.I18N.getMessage("RevertDependenciesAnalyser.report", new Object[]{this.monitorPrefix, this.neededNodes.size()}));
            if (this.monitor.isCanceled()) {
                throw new InterruptedException();
            }
        }
    }
}

