/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.cms.engine.commands.revert;

import com.modeliosoft.modelio.cms.api.IElementMove;
import com.modeliosoft.modelio.cms.api.IElementMoveRef;
import com.modeliosoft.modelio.cms.api.IRevertDetail;
import com.modeliosoft.modelio.cms.api.IRevertFragmentDetail;
import com.modeliosoft.modelio.cms.api.ISymbolService;
import com.modeliosoft.modelio.cms.engine.commands.revert.RevertFragmentDetails;
import com.modeliosoft.modelio.cms.engine.recorder.ElementMove;
import com.modeliosoft.modelio.gproject.svn.plugin.ProjectSvn;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.modelio.vcore.session.api.ICoreSession;
import org.modelio.vcore.session.api.model.IModel;
import org.modelio.vcore.session.api.repository.IRepository;
import org.modelio.vcore.smkernel.mapi.MObject;
import org.modelio.vcore.smkernel.mapi.MRef;

class RevertDetails
implements IRevertDetail {
    private final ISymbolService symbolService;
    private final Set<IElementMoveRef> moveRefs;
    private final IModel model;
    private final Map<IRepository, IRevertFragmentDetail> fragmentDetails = new HashMap<IRepository, IRevertFragmentDetail>(5);
    private final ICoreSession session;
    private final Collection<Throwable> fatalErrors = new ArrayList<Throwable>(1);

    public RevertDetails(ISymbolService symbolService, ICoreSession session) {
        this.session = session;
        this.model = this.session.getModel();
        this.moveRefs = new HashSet<IElementMoveRef>();
        this.symbolService = symbolService;
    }

    public Set<MObject> getDeletedElements() {
        Set<MRef> undeleted = this.getUndeletedElements();
        return this.getFragments().stream().flatMap(f -> f.getDeletedElements().stream()).filter(obj -> !undeleted.contains(new MRef(obj))).collect(Collectors.toSet());
    }

    public Set<MRef> getUndeletedElements() {
        return this.getFragments().stream().flatMap(f -> f.getUndeletedElements().stream()).collect(Collectors.toSet());
    }

    public Set<MObject> getModifiedElements() {
        return this.getFragments().stream().flatMap(f -> f.getModifiedElements().stream()).collect(Collectors.toSet());
    }

    public Set<IElementMove> getMoves() {
        HashSet<IElementMove> moves = new HashSet<IElementMove>();
        for (IElementMoveRef moveRef : this.getMoveReferences()) {
            ElementMove m = new ElementMove(this.model.findByRef(moveRef.getMoved()), this.model.findByRef(moveRef.getOldParent()), this.model.findByRef(moveRef.getNewParent()));
            moves.add(m);
        }
        return moves;
    }

    void addMoves(Set<IElementMoveRef> elementMoves) {
        this.moveRefs.addAll(elementMoves);
    }

    public ISymbolService getSymbolService() {
        return this.symbolService;
    }

    public Set<String> getUndeletedBlobs() {
        return this.getFragments().stream().flatMap(f -> f.getUndeletedBlobs().stream()).collect(Collectors.toSet());
    }

    public Collection<File> getAssociatedFiles() {
        return this.getFragments().stream().flatMap(f -> f.getAssociatedFiles().stream()).collect(Collectors.toSet());
    }

    public Collection<IElementMoveRef> getMoveReferences() {
        return this.moveRefs;
    }

    public Collection<IRevertFragmentDetail> getFragments() {
        return this.fragmentDetails.values();
    }

    public RevertFragmentDetails getFragment(IRepository r) {
        RevertFragmentDetails ret = (RevertFragmentDetails)this.fragmentDetails.get(r);
        if (ret == null) {
            ret = new RevertFragmentDetails(r, this.getSymbolService(), this.model);
            this.fragmentDetails.put(r, ret);
        }
        return ret;
    }

    RevertFragmentDetails getFragment(MObject obj) {
        return this.getFragment(this.session.getRepositorySupport().getRepository(obj));
    }

    public void addFatalError(Throwable e) {
        this.fatalErrors.add(e);
    }

    public Collection<Throwable> getFatalErrors() {
        return this.fatalErrors;
    }

    public String toString() {
        StringBuilder content = new StringBuilder();
        for (IRevertFragmentDetail rf : this.getFragments()) {
            content.append("- ");
            content.append(rf.getRepository());
            content.append(":\n");
            ((RevertFragmentDetails)rf).dump(content, "    ");
        }
        if (!this.getMoveReferences().isEmpty()) {
            content.append(ProjectSvn.I18N.getString("RevertDetails.Details.MovesToRevert"));
            content.append("\n");
            for (IElementMoveRef s : this.getMoveReferences()) {
                content.append(" - ");
                content.append(this.symbolService.getName(s.getMoved()));
                content.append(" :\n");
                content.append("      from : ");
                content.append(this.symbolService.getFullName(s.getOldParent()));
                content.append("\n");
                content.append("      to : ");
                content.append(this.symbolService.getFullName(s.getNewParent()));
                content.append("\n");
            }
            content.append("\n");
        }
        return content.toString();
    }
}

