/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.cms.engine.commands.revert;

import com.modeliosoft.modelio.cms.api.IElementMove;
import com.modeliosoft.modelio.cms.api.IElementMoveRef;
import com.modeliosoft.modelio.cms.api.IRevertFragmentDetail;
import com.modeliosoft.modelio.cms.api.ISymbolService;
import com.modeliosoft.modelio.cms.engine.recorder.ElementMove;
import com.modeliosoft.modelio.gproject.svn.plugin.ProjectSvn;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.modelio.vcore.session.api.model.IModel;
import org.modelio.vcore.session.api.repository.IRepository;
import org.modelio.vcore.smkernel.mapi.MObject;
import org.modelio.vcore.smkernel.mapi.MRef;

class RevertFragmentDetails
implements IRevertFragmentDetail {
    private final Set<String> undeletedBlobs;
    private final Set<MObject> deletedElements;
    private final Set<MObject> modifiedElements;
    private ISymbolService symbolService;
    private final Set<MRef> undeletedElements;
    private final Collection<File> files;
    private final Set<IElementMoveRef> moveRefs;
    private final IModel model;
    private IRepository repository;

    public RevertFragmentDetails(IRepository repository, ISymbolService symbolService, IModel model) {
        this.repository = repository;
        this.symbolService = symbolService;
        this.model = model;
        this.deletedElements = new HashSet<MObject>();
        this.undeletedElements = new HashSet<MRef>();
        this.modifiedElements = new HashSet<MObject>();
        this.moveRefs = new HashSet<IElementMoveRef>();
        this.undeletedBlobs = new HashSet<String>();
        this.files = new HashSet<File>();
    }

    void addDeletedElement(MObject el) {
        this.deletedElements.add(el);
    }

    void addModifiedElement(MObject el) {
        this.modifiedElements.add(el);
    }

    void addUndeletedRef(MRef ref) {
        this.undeletedElements.add(ref);
        this.symbolService.cacheSymbol(ref);
    }

    public Set<MObject> getDeletedElements() {
        return this.deletedElements;
    }

    public Set<MRef> getUndeletedElements() {
        return this.undeletedElements;
    }

    public Set<MObject> getModifiedElements() {
        return this.modifiedElements;
    }

    public Set<IElementMove> getMoves() {
        HashSet<IElementMove> moves = new HashSet<IElementMove>();
        for (IElementMoveRef moveRef : this.getMoveReferences()) {
            ElementMove m = new ElementMove(this.model.findByRef(moveRef.getMoved()), this.model.findByRef(moveRef.getOldParent()), this.model.findByRef(moveRef.getNewParent()));
            moves.add(m);
        }
        return moves;
    }

    void addMoves(Set<IElementMoveRef> elementMoves) {
        this.moveRefs.addAll(elementMoves);
    }

    public ISymbolService getSymbolService() {
        return this.symbolService;
    }

    public Set<String> getUndeletedBlobs() {
        return this.undeletedBlobs;
    }

    public void addUndeletedBlobs(Collection<String> blobs) {
        this.undeletedBlobs.addAll(blobs);
    }

    void addAssociatedFile(MRef ref, File file) {
        this.files.add(file);
    }

    public Collection<File> getAssociatedFiles() {
        return this.files;
    }

    public Collection<IElementMoveRef> getMoveReferences() {
        return this.moveRefs;
    }

    public IRepository getRepository() {
        return this.repository;
    }

    public void dump(StringBuilder out, String indent) {
        if (!this.getUndeletedElements().isEmpty()) {
            out.append(indent);
            out.append(ProjectSvn.I18N.getString("RevertDetails.Details.ToRecreate"));
            out.append("\n");
            for (MRef mRef : this.getUndeletedElements()) {
                out.append(indent);
                out.append(" - ");
                out.append(this.symbolService.getFullName(mRef));
                out.append("\n");
            }
            out.append("\n");
        }
        if (!this.getModifiedElements().isEmpty()) {
            out.append(indent);
            out.append(ProjectSvn.I18N.getString("RevertDetails.Details.ToRevert"));
            out.append("\n");
            for (MObject mObject : this.getModifiedElements()) {
                out.append(indent);
                out.append(" - ");
                out.append(this.symbolService.getFullName(mObject));
                out.append("\n");
            }
            out.append("\n");
        }
        if (!this.getDeletedElements().isEmpty()) {
            out.append(indent);
            out.append(ProjectSvn.I18N.getString("RevertDetails.Details.ToDelete"));
            out.append("\n");
            for (MObject mObject : this.getDeletedElements()) {
                out.append(indent);
                out.append(" - ");
                out.append(this.symbolService.getFullName(mObject));
                out.append("\n");
            }
            out.append("\n");
        }
        if (!this.getMoveReferences().isEmpty()) {
            out.append(indent);
            out.append(ProjectSvn.I18N.getString("RevertDetails.Details.MovesToRevert"));
            out.append("\n");
            for (IElementMoveRef iElementMoveRef : this.getMoveReferences()) {
                out.append(indent);
                out.append(" - ");
                out.append(this.symbolService.getName(iElementMoveRef.getMoved()));
                out.append(" :\n");
                out.append(indent);
                out.append("      from : ");
                out.append(this.symbolService.getFullName(iElementMoveRef.getOldParent()));
                out.append("\n");
                out.append(indent);
                out.append("      to : ");
                out.append(this.symbolService.getFullName(iElementMoveRef.getNewParent()));
                out.append("\n");
            }
            out.append("\n");
        }
    }
}

