/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.cms.engine.commands.revert;

import com.modeliosoft.modelio.cms.api.CmsException;
import com.modeliosoft.modelio.cms.api.IRevertFragmentDetail;
import com.modeliosoft.modelio.cms.api.IRevertFragmentResult;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.modelio.vcore.session.api.blob.IBlobChangeEvent;
import org.modelio.vcore.session.api.model.IModel;
import org.modelio.vcore.session.api.repository.IRepository;
import org.modelio.vcore.smkernel.mapi.MObject;
import org.modelio.vcore.smkernel.mapi.MRef;

class RevertFragmentResult
implements IRevertFragmentResult {
    private final Map<MRef, String> elementErrors;
    private boolean batchMode;
    private final List<MObject> modifiedElements;
    private List<MObject> undeletedElements;
    private final List<MRef> deletedElements;
    private CmsException fatalError;
    private IBlobChangeEvent blobEvent;
    private final IRepository repository;
    private final List<MRef> undeletedReferences;
    private final IModel model;

    RevertFragmentResult(IModel model, IRepository repository) {
        this.model = model;
        this.repository = repository;
        this.deletedElements = new ArrayList<MRef>();
        this.undeletedReferences = new ArrayList<MRef>();
        this.modifiedElements = new ArrayList<MObject>();
        this.elementErrors = new HashMap<MRef, String>();
    }

    public List<MObject> getModifiedElements() {
        return this.modifiedElements;
    }

    public List<MObject> getCreatedElements() {
        if (this.undeletedElements == null) {
            this.undeletedElements = new ArrayList<MObject>(this.undeletedReferences.size());
            for (MRef ref : this.undeletedReferences) {
                MObject obj = this.model.findByRef(ref);
                if (obj != null) {
                    this.undeletedElements.add(obj);
                    continue;
                }
                this.addErrorOn(ref, "Undeleted " + String.valueOf(ref) + " not found.");
            }
        }
        return this.undeletedElements;
    }

    public List<MRef> getDeletedElements() {
        return this.deletedElements;
    }

    public void addErrorOn(MRef ref, String error) {
        this.elementErrors.put(ref, error);
    }

    public Map<MRef, String> getElementErrors() {
        return this.elementErrors;
    }

    void init(IRevertFragmentDetail revertDetails) {
        for (MObject d : revertDetails.getDeletedElements()) {
            this.deletedElements.add(new MRef(d));
        }
        this.undeletedReferences.addAll(revertDetails.getUndeletedElements());
        this.modifiedElements.addAll(revertDetails.getModifiedElements());
    }

    public void addFatalError(CmsException e) {
        this.fatalError = e;
    }

    public CmsException getFatalError() {
        return this.fatalError;
    }

    public void setBlobChanges(IBlobChangeEvent blobEvent) {
        this.blobEvent = blobEvent;
    }

    public IBlobChangeEvent getBlobChanges() {
        return this.blobEvent;
    }

    public IRepository getRepository() {
        return this.repository;
    }
}

