/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.cms.engine.commands.revert;

import com.modeliosoft.modelio.cms.api.CmsException;
import com.modeliosoft.modelio.cms.api.IElementMove;
import com.modeliosoft.modelio.cms.api.IElementMoveRef;
import com.modeliosoft.modelio.cms.api.IRevertDetail;
import com.modeliosoft.modelio.cms.api.IRevertFragmentDetail;
import com.modeliosoft.modelio.cms.api.IRevertFragmentResult;
import com.modeliosoft.modelio.cms.api.IRevertResult;
import com.modeliosoft.modelio.cms.api.ISymbolService;
import com.modeliosoft.modelio.cms.engine.commands.revert.RevertFragmentResult;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.modelio.gproject.core.IGModelFragment;
import org.modelio.vcore.session.api.blob.IBlobChangeEvent;
import org.modelio.vcore.session.api.model.IModel;
import org.modelio.vcore.session.api.repository.IRepository;
import org.modelio.vcore.smkernel.mapi.MObject;
import org.modelio.vcore.smkernel.mapi.MRef;

class RevertResult
implements IRevertResult {
    private final Map<MRef, String> elementErrors;
    private boolean batchMode;
    private final ISymbolService symbolService;
    private CmsException fatalError;
    private IBlobChangeEvent blobEvent;
    private final Map<IRepository, IRevertFragmentResult> fragmentResults = new HashMap<IRepository, IRevertFragmentResult>(5);
    private IModel model;
    private final Set<IElementMove> moves;
    private final Collection<IElementMoveRef> moveRefs;

    RevertResult(IModel model, ISymbolService symbolService, boolean batchMode) {
        this.model = model;
        this.batchMode = batchMode;
        this.elementErrors = new HashMap<MRef, String>();
        this.moves = new HashSet<IElementMove>();
        this.moveRefs = new HashSet<IElementMoveRef>();
        this.symbolService = symbolService;
    }

    public List<MObject> getModifiedElements() {
        return this.getFragments().stream().flatMap(rf -> rf.getModifiedElements().stream()).collect(Collectors.toList());
    }

    public List<MObject> getCreatedElements() {
        return this.getFragments().stream().flatMap(rf -> rf.getCreatedElements().stream()).collect(Collectors.toList());
    }

    public List<MRef> getDeletedElements() {
        Collection undeleted = this.getFragments().stream().flatMap(rf -> rf.getCreatedElements().stream()).map(o -> new MRef(o)).collect(Collectors.toList());
        return this.getFragments().stream().flatMap(rf -> rf.getDeletedElements().stream()).filter(ref -> !undeleted.contains(ref)).collect(Collectors.toList());
    }

    public ISymbolService getSymbolService() {
        return this.symbolService;
    }

    public void addErrorOn(MRef ref, String error) {
        this.elementErrors.put(ref, error);
    }

    public Map<MRef, String> getElementErrors() {
        return this.getFragments().stream().flatMap(rf -> rf.getElementErrors().entrySet().stream()).collect(Collectors.toMap(e -> (MRef)e.getKey(), e -> (String)e.getValue()));
    }

    public Set<IElementMove> getMoves() {
        return this.moves;
    }

    void init(IRevertDetail revertDetails) {
        for (IRevertFragmentDetail df : revertDetails.getFragments()) {
            this.getFragment(df.getRepository()).init(df);
        }
        this.moveRefs.addAll(revertDetails.getMoveReferences());
        this.moves.addAll(revertDetails.getMoves());
    }

    public void addFatalError(CmsException e) {
        this.fatalError = e;
    }

    public CmsException getFatalError() {
        return this.fatalError;
    }

    public void setBlobChanges(IBlobChangeEvent blobEvent) {
        this.blobEvent = blobEvent;
    }

    public IBlobChangeEvent getBlobChanges() {
        return this.blobEvent;
    }

    public boolean isBatchMode() {
        return this.batchMode;
    }

    public Collection<IElementMoveRef> getMoveReferences() {
        return this.moveRefs;
    }

    public Collection<IRevertFragmentResult> getFragments() {
        return this.fragmentResults.values();
    }

    public RevertFragmentResult getFragment(IRepository repository) {
        RevertFragmentResult ret = (RevertFragmentResult)this.fragmentResults.get(repository);
        if (ret == null) {
            ret = new RevertFragmentResult(this.model, repository);
            this.fragmentResults.put(repository, ret);
        }
        return ret;
    }

    public IRevertFragmentResult getFragment(IGModelFragment f) {
        return this.getFragment(f.getRepository());
    }
}

