/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.cms.engine.commands.update;

import com.modeliosoft.modelio.cms.api.CmsException;
import com.modeliosoft.modelio.cms.api.ISymbolService;
import com.modeliosoft.modelio.cms.api.IUpdateCommand;
import com.modeliosoft.modelio.cms.api.IUpdateDetails;
import com.modeliosoft.modelio.cms.api.TransactionStillOpenException;
import com.modeliosoft.modelio.cms.api.contrib.IUpdateConfig;
import com.modeliosoft.modelio.cms.driver.ICmsDriver;
import com.modeliosoft.modelio.cms.driver.ICmsUpdateResult;
import com.modeliosoft.modelio.cms.engine.ICmsEngine;
import com.modeliosoft.modelio.cms.engine.commands.update.UpdateResult;
import com.modeliosoft.modelio.gproject.svn.fragment.GSvnFragment;
import com.modeliosoft.modelio.gproject.svn.plugin.ProjectSvn;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.modelio.gproject.core.IGModelFragment;
import org.modelio.gproject.core.IGProject;
import org.modelio.vbasic.progress.IModelioProgress;
import org.modelio.vbasic.progress.SubProgress;
import org.modelio.vcore.session.api.blob.BlobChangeEvent;
import org.modelio.vcore.session.api.blob.IBlobChangeEvent;
import org.modelio.vcore.session.api.model.IModel;
import org.modelio.vcore.session.api.repository.BlobServices;
import org.modelio.vcore.session.api.repository.IRepository;
import org.modelio.vcore.smkernel.mapi.MObject;
import org.modelio.vcore.smkernel.mapi.MRef;

public class UpdateCommand
implements IUpdateCommand,
IUpdateConfig {
    private boolean batchMode = true;
    private boolean skipPreUpdate = false;
    private boolean useProcessExtension = true;
    private String revision;
    private final ICmsEngine engine;
    private final IModel iModel;
    private final Set<GSvnFragment> fragments = new HashSet<GSvnFragment>();
    private Collection<MObject> roots = new HashSet<MObject>();
    private final Collection<File> additionalFiles = new HashSet<File>();

    public UpdateCommand(ICmsEngine engine) {
        this.engine = engine;
        this.iModel = this.engine.getCoreSession().getModel();
    }

    protected IUpdateDetails doExecute(IModelioProgress iMonitor) throws IOException, CmsException {
        this.computeFragments();
        ISymbolService symbolService = this.engine.createSymbolService();
        UpdateResult globalUpdateResult = new UpdateResult(this.iModel, symbolService, this.isBatchMode());
        if (!this.fragments.isEmpty()) {
            SubProgress monitor = SubProgress.convert((IModelioProgress)iMonitor, (int)1000);
            IGProject gproject = this.engine.getProject();
            gproject.save((IModelioProgress)monitor.newChild(100));
            Throwable throwable = null;
            Object var7_8 = null;
            try (ICmsEngine.ILEnabler cl = this.engine.suspendModelListeners();){
                monitor.subTask(ProjectSvn.I18N.getString("Monitor.other.UpdatingWorkingCopy"));
                SubProgress m2 = monitor.newChild(850);
                m2.setWorkRemaining(this.fragments.size());
                for (GSvnFragment svnFragment : this.fragments) {
                    ICmsDriver cmsDriver = svnFragment.getCmsDriver();
                    ICmsUpdateResult cmsResult = cmsDriver.updateModel((IModelioProgress)m2.newChild(1), this.additionalFiles, this.revision);
                    UpdateResult localResult = new UpdateResult(this.iModel, symbolService, this.isBatchMode()).add(cmsResult);
                    globalUpdateResult.add(localResult);
                    this.fireBlobListeners(localResult, (IRepository)svnFragment.getRepository());
                    for (MRef ref : localResult.getDeletedElements()) {
                        symbolService.getFullName(ref);
                    }
                }
                this.engine.saveModelChangeKeeper();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        return globalUpdateResult;
    }

    public IUpdateDetails execute(IModelioProgress iMonitor) throws IOException, TransactionStillOpenException, CmsException {
        if (!this.useProcessExtension()) {
            return this.doExecute(iMonitor);
        }
        SubProgress monitor = SubProgress.convert((IModelioProgress)iMonitor, (String)ProjectSvn.I18N.getString("Monitor.Update"), (int)4);
        if (!this.engine.getHook().preUpdate((IModelioProgress)monitor.newChild(1), (IUpdateCommand)this)) {
            return null;
        }
        this.engine.checkTransactionStack();
        try {
            IUpdateDetails updateResult = this.doExecute((IModelioProgress)monitor);
            this.engine.getHook().postUpdate(updateResult);
            return updateResult;
        }
        catch (CmsException | IOException | RuntimeException e) {
            this.engine.getHook().postUpdateFailed((IUpdateCommand)this, (Exception)e);
            throw e;
        }
    }

    public IUpdateDetails switchRepository(IModelioProgress iMonitor, IGModelFragment fragment, String newPath) throws CmsException {
        SubProgress monitor = SubProgress.convert((IModelioProgress)iMonitor, (int)100);
        ICmsDriver cmsDriver = ((GSvnFragment)fragment).getCmsDriver();
        this.engine.disableModelListeners();
        try {
            ICmsUpdateResult updateResult = cmsDriver.switchWorkingCopy((IModelioProgress)monitor, newPath);
            UpdateResult updateResult2 = new UpdateResult(this.iModel, this.engine.createSymbolService(), this.isBatchMode()).add(updateResult);
            return updateResult2;
        }
        finally {
            this.engine.enableModelListeners();
        }
    }

    public Collection<MObject> getElements() {
        return this.roots;
    }

    private void fireBlobListeners(UpdateResult updateResult, IRepository repo) {
        if (updateResult.getCreatedBlobs().isEmpty() && updateResult.getDeletedBlobs().isEmpty() && updateResult.getUpdatedBlobs().isEmpty()) {
            return;
        }
        Collection createdBlobs = BlobServices.loadBlobInfos(updateResult.getCreatedBlobs(), (IRepository)repo);
        Collection deletedBlobs = BlobServices.loadBlobInfos(updateResult.getDeletedBlobs(), (IRepository)repo);
        Collection updatedBlobs = BlobServices.loadBlobInfos(updateResult.getUpdatedBlobs(), (IRepository)repo);
        BlobChangeEvent blobChanges = new BlobChangeEvent(createdBlobs, deletedBlobs, updatedBlobs);
        this.engine.getCoreSession().getBlobSupport().fireBlobsChanged((IBlobChangeEvent)blobChanges);
    }

    public void add(Collection<MObject> cmsNodes) {
        this.addElements(cmsNodes);
    }

    public IUpdateConfig getConfiguration() {
        return this;
    }

    public void addAdditionalFile(File toUpdate) {
        this.additionalFiles.add(toUpdate);
    }

    public Collection<File> getAdditionalFiles() {
        return this.additionalFiles;
    }

    public void setBatch(boolean batchMode) {
        this.batchMode = batchMode;
    }

    public boolean isBatchMode() {
        return this.batchMode;
    }

    public void setUseProcessExtension(boolean val) {
        this.useProcessExtension = val;
    }

    public boolean useProcessExtension() {
        return this.useProcessExtension;
    }

    private void computeFragments() {
        Collection<MObject> cmsNodes = this.roots;
        this.roots = new HashSet<MObject>();
        for (MObject obj : cmsNodes) {
            IGModelFragment f = this.engine.getProject().getFragment(obj);
            if (!(f instanceof GSvnFragment)) continue;
            this.fragments.add((GSvnFragment)f);
            this.roots.addAll(f.getRoots());
        }
    }

    public String getRevision() {
        return this.revision;
    }

    public void setRevision(String revision) {
        this.revision = revision;
    }

    public Collection<IGModelFragment> getFragments() {
        return Collections.unmodifiableCollection(this.fragments);
    }

    public void addFragment(IGModelFragment f) {
        if (!(f instanceof GSvnFragment)) {
            throw new IllegalArgumentException(String.valueOf(f) + " is not versioned.");
        }
        this.fragments.add((GSvnFragment)f);
    }

    public void addElement(MObject element) {
        IGModelFragment f = this.engine.getProject().getFragment(element);
        if (f instanceof GSvnFragment) {
            this.roots.addAll(f.getRoots());
        }
    }

    public void addElements(Collection<MObject> elements) {
        for (MObject obj : elements) {
            this.addElement(obj);
        }
    }

    public void skipPreUpdate(boolean skipPreUpdate) {
        this.skipPreUpdate = skipPreUpdate;
    }

    public boolean skipPreUpdate() {
        return this.skipPreUpdate;
    }
}

