/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.cms.engine.commands.update;

import com.modeliosoft.modelio.cms.api.ISymbolService;
import com.modeliosoft.modelio.cms.api.IUpdateDetails;
import com.modeliosoft.modelio.cms.driver.ICmsUpdateResult;
import com.modeliosoft.modelio.cms.utils.SubversionUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.modelio.vbasic.files.FileUtils;
import org.modelio.vbasic.log.Log;
import org.modelio.vcore.session.api.model.IModel;
import org.modelio.vcore.smkernel.mapi.MObject;
import org.modelio.vcore.smkernel.mapi.MRef;
import org.modelio.vstore.exml.resource.ExmlFileAccess;

public class UpdateResult
implements IUpdateDetails {
    private Collection<String> createdBlobs = new ArrayList<String>();
    private Collection<String> updatedBlobs = new ArrayList<String>();
    private Collection<String> conflictedBlobs = new ArrayList<String>();
    private Collection<String> deletedBlobs = new ArrayList<String>();
    private Collection<String> mergedBlobs = new ArrayList<String>();
    private Collection<String> unlockedBlobs = new ArrayList<String>();
    private boolean batchMode;
    private ISymbolService symbolService;
    private IModel imodel;
    private Collection<MRef> updatedRefs = new ArrayList<MRef>();
    private Collection<MRef> createdRefs = new ArrayList<MRef>();
    private Collection<MRef> deletedRefs = new ArrayList<MRef>();
    private Collection<MRef> conflictedRefs = new ArrayList<MRef>();
    private Collection<MRef> mergedRefs = new ArrayList<MRef>();
    private Collection<MRef> unlockedRefs = new ArrayList<MRef>();
    private Collection<File> updatedOthers = new ArrayList<File>();
    private Collection<File> createdOthers = new ArrayList<File>();
    private Collection<File> deletedOthers = new ArrayList<File>();
    private Collection<File> conflictedOthers = new ArrayList<File>();
    private Collection<File> mergedOthers = new ArrayList<File>();
    private Collection<File> unlockedOthers = new ArrayList<File>();
    private Throwable incompleteCause;

    public UpdateResult(IModel model, ISymbolService symbolService, boolean batchMode) {
        this.symbolService = symbolService;
        this.imodel = model;
        this.batchMode = batchMode;
    }

    public Collection<MObject> getCreatedElements() {
        return this.getElements(this.createdRefs, "Created %s reference not found in the model.");
    }

    public Collection<MRef> getDeletedElements() {
        return this.deletedRefs;
    }

    public ISymbolService getSymbolService() {
        return this.symbolService;
    }

    public Collection<MObject> getUpdatedElements() {
        return this.getElements(this.updatedRefs, "Updated %s reference not found in the model.");
    }

    public Collection<MObject> getConflictedElements() {
        return this.getElements(this.conflictedRefs, "Conflicted %s reference not found in the model.");
    }

    public Collection<MObject> getMergedElements() {
        return this.getElements(this.mergedRefs, "Merged %s reference not found in the model.");
    }

    public Throwable getIncompleteUpdateCause() {
        return this.incompleteCause;
    }

    public Collection<MObject> getUnlockedElements() {
        return this.getElements(this.unlockedRefs, "Unlocked %s reference not found in the model.");
    }

    public boolean isBatchMode() {
        return this.batchMode;
    }

    public UpdateResult add(UpdateResult other) {
        this.createdRefs.addAll(other.createdRefs);
        this.createdBlobs.addAll(other.createdBlobs);
        this.createdOthers.addAll(other.createdOthers);
        this.updatedBlobs.addAll(other.updatedBlobs);
        this.updatedRefs.addAll(other.updatedRefs);
        this.updatedOthers.addAll(other.updatedOthers);
        this.conflictedRefs.addAll(other.conflictedRefs);
        this.conflictedBlobs.addAll(other.conflictedBlobs);
        this.conflictedOthers.addAll(other.conflictedOthers);
        this.deletedRefs.addAll(other.deletedRefs);
        this.deletedBlobs.addAll(other.deletedBlobs);
        this.deletedOthers.addAll(other.deletedOthers);
        this.mergedRefs.addAll(other.mergedRefs);
        this.mergedBlobs.addAll(other.mergedBlobs);
        this.mergedOthers.addAll(other.mergedOthers);
        this.unlockedBlobs.addAll(other.unlockedBlobs);
        this.unlockedRefs.addAll(other.unlockedRefs);
        this.unlockedOthers.addAll(other.unlockedOthers);
        SubversionUtils.deduplicate(this.deletedRefs, this.createdRefs, this.updatedRefs);
        SubversionUtils.deduplicate(this.deletedBlobs, this.createdBlobs, this.updatedBlobs);
        SubversionUtils.deduplicate(this.deletedOthers, this.createdOthers, this.updatedOthers);
        this.joinIncompleteCause(other.incompleteCause);
        return this;
    }

    public UpdateResult add(ICmsUpdateResult cmsResult) {
        this.conflictedBlobs.addAll(cmsResult.getConflictedBlobs());
        this.conflictedOthers.addAll(cmsResult.getConflictedOtherFiles());
        this.conflictedRefs.addAll(cmsResult.getConflictedElements());
        this.createdBlobs.addAll(cmsResult.getCreatedBlobs());
        this.createdOthers.addAll(cmsResult.getCreatedOtherFiles());
        this.createdRefs.addAll(cmsResult.getCreatedElements());
        this.deletedBlobs.addAll(cmsResult.getDeletedBlobs());
        this.deletedOthers.addAll(cmsResult.getDeletedOtherFiles());
        this.deletedRefs.addAll(cmsResult.getDeletedElements());
        this.mergedBlobs.addAll(cmsResult.getMergedBlobs());
        this.mergedOthers.addAll(cmsResult.getMergedOtherFiles());
        this.mergedRefs.addAll(cmsResult.getMergedElements());
        this.unlockedBlobs.addAll(cmsResult.getUnlockedBlobs());
        this.unlockedOthers.addAll(cmsResult.getUnlockedOtherFiles());
        this.unlockedRefs.addAll(cmsResult.getUnlockedElements());
        this.updatedBlobs.addAll(cmsResult.getUpdatedBlobs());
        this.updatedOthers.addAll(cmsResult.getUpdatedOtherFiles());
        this.updatedRefs.addAll(cmsResult.getUpdatedElements());
        Throwable cause = cmsResult.getIncompleteUpdateCause();
        this.joinIncompleteCause(cause);
        return this;
    }

    private void joinIncompleteCause(Throwable cause) {
        if (cause != null) {
            if (this.incompleteCause == null) {
                this.incompleteCause = cause;
            } else if (this.incompleteCause.getClass() == MultipleFailures.class) {
                this.incompleteCause.addSuppressed(cause);
            } else {
                MultipleFailures t = new MultipleFailures();
                t.addSuppressed(cause);
                t.addSuppressed(this.incompleteCause);
                this.incompleteCause = t;
            }
        }
    }

    @Deprecated
    private void __dispatch(Collection<File> src, ExmlFileAccess geom, Collection<MRef> refs, Collection<String> blobs, Collection<File> others) {
        for (File file : src) {
            if (geom.isModelFile(file)) {
                MRef obRef = geom.getObRef(file);
                refs.add(obRef);
                continue;
            }
            if (geom.isBlobFile(file)) {
                String blobKey = geom.getBlobKey(file);
                blobs.add(blobKey);
                continue;
            }
            others.add(file);
        }
    }

    public Collection<MObject> getElements(Collection<MRef> refs, String errMsgFormat) {
        ArrayList<MObject> ret = new ArrayList<MObject>();
        for (MRef ref : refs) {
            MObject el = this.imodel.findByRef(ref);
            if (el != null) {
                ret.add(el);
                continue;
            }
            Log.warning((String)errMsgFormat, (Object[])new Object[]{ref});
        }
        return ret;
    }

    public Collection<File> getMergedFiles() {
        return this.mergedOthers;
    }

    public Collection<File> getConflictedFiles() {
        return this.conflictedOthers;
    }

    public Collection<File> getDeletedFiles() {
        return this.deletedOthers;
    }

    public Collection<File> getCreatedFiles() {
        return this.createdOthers;
    }

    public Collection<File> getUpdatedFiles() {
        return this.updatedOthers;
    }

    public Collection<File> getUnlockedFiles() {
        return this.unlockedOthers;
    }

    public Collection<String> getConflictedBlobs() {
        return this.conflictedBlobs;
    }

    public Collection<String> getCreatedBlobs() {
        return this.createdBlobs;
    }

    public Collection<String> getDeletedBlobs() {
        return this.deletedBlobs;
    }

    public Collection<String> getMergedBlobs() {
        return this.mergedBlobs;
    }

    public Collection<String> getUnlockedBlobs() {
        return this.unlockedBlobs;
    }

    public Collection<String> getUpdatedBlobs() {
        return this.updatedBlobs;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(1000);
        sb.append(this.getClass().getSimpleName());
        sb.append(":{");
        if (this.getIncompleteUpdateCause() != null) {
            sb.append(this.getIncompleteUpdateCause());
            sb.append("\n");
        }
        sb.append("\nUpdated :");
        for (MRef el : this.updatedRefs) {
            sb.append("\n    - ");
            sb.append(this.symbolService.getFullName(el));
        }
        for (String key : this.getUpdatedBlobs()) {
            sb.append("\n    - ");
            sb.append(key);
            sb.append(" blob");
        }
        for (File file : this.getUpdatedFiles()) {
            sb.append("\n    - ");
            sb.append(file);
        }
        sb.append("\nCreated :");
        for (MRef el : this.createdRefs) {
            sb.append("\n    - ");
            sb.append(this.symbolService.getFullName(el));
        }
        for (String key : this.getCreatedBlobs()) {
            sb.append("\n    - ");
            sb.append(key);
            sb.append(" blob");
        }
        for (File file : this.getCreatedFiles()) {
            sb.append("\n    - ");
            sb.append(file);
        }
        sb.append("\nDeleted :");
        for (MRef el : this.getDeletedElements()) {
            sb.append("\n    - ");
            sb.append(this.symbolService.getFullName(el));
        }
        for (String key : this.getCreatedBlobs()) {
            sb.append("\n    - ");
            sb.append(key);
            sb.append(" blob");
        }
        for (File file : this.getCreatedFiles()) {
            sb.append("\n    - ");
            sb.append(file);
        }
        this.getDeletedBlobs();
        this.getDeletedFiles();
        sb.append("\nConflicted:");
        for (MRef el : this.conflictedRefs) {
            sb.append("\n    - ");
            sb.append(this.symbolService.getFullName(el));
        }
        for (String key : this.getConflictedBlobs()) {
            sb.append("\n    - ");
            sb.append(key);
            sb.append(" blob");
        }
        for (File file : this.getConflictedFiles()) {
            sb.append("\n    - ");
            sb.append(file);
        }
        sb.append("\n").append("Merged:");
        for (MRef el : this.mergedRefs) {
            sb.append("\n    - ");
            sb.append(this.symbolService.getFullName(el));
        }
        for (String key : this.getMergedBlobs()) {
            sb.append("\n    - ");
            sb.append(key);
            sb.append(" blob");
        }
        for (File file : this.getMergedFiles()) {
            sb.append("\n    - ");
            sb.append(file);
        }
        sb.append("\n").append("Unlocked:");
        for (MRef el : this.unlockedRefs) {
            sb.append("\n    - ");
            sb.append(this.symbolService.getFullName(el));
        }
        for (String key : this.getUnlockedBlobs()) {
            sb.append("\n    - ");
            sb.append(key);
            sb.append(" blob");
        }
        for (File file : this.getUnlockedFiles()) {
            sb.append("\n    - ");
            sb.append(file);
        }
        sb.append("\n}");
        return sb.toString();
    }

    private static class MultipleFailures
    extends Exception {
        private static final long serialVersionUID = 1L;

        private MultipleFailures() {
        }

        @Override
        public String getMessage() {
            StringBuilder b = new StringBuilder();
            Throwable[] throwableArray = this.getSuppressed();
            int n = throwableArray.length;
            int n2 = 0;
            while (n2 < n) {
                Throwable t = throwableArray[n2];
                b.append(" - ");
                b.append(t.getMessage());
                b.append("\n");
                ++n2;
            }
            return b.toString();
        }

        @Override
        public String getLocalizedMessage() {
            StringBuilder b = new StringBuilder();
            Throwable[] throwableArray = this.getSuppressed();
            int n = throwableArray.length;
            int n2 = 0;
            while (n2 < n) {
                Throwable t = throwableArray[n2];
                b.append(" - ");
                if (t instanceof IOException) {
                    b.append(FileUtils.getLocalizedMessage((IOException)((IOException)t)));
                } else {
                    b.append(t.getLocalizedMessage());
                }
                b.append("\n");
                ++n2;
            }
            return b.toString();
        }
    }
}

