/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.cms.engine.pem;

import com.modeliosoft.modelio.cms.api.IAddCommand;
import com.modeliosoft.modelio.cms.api.IAddResult;
import com.modeliosoft.modelio.cms.api.ICommitCommand;
import com.modeliosoft.modelio.cms.api.ICommitResult;
import com.modeliosoft.modelio.cms.api.IGetLockCommand;
import com.modeliosoft.modelio.cms.api.IGetLockResult;
import com.modeliosoft.modelio.cms.api.IMergeCommand;
import com.modeliosoft.modelio.cms.api.IProcessExtension;
import com.modeliosoft.modelio.cms.api.IProcessExtensionGui;
import com.modeliosoft.modelio.cms.api.IRemoveCommand;
import com.modeliosoft.modelio.cms.api.IRevertCommand;
import com.modeliosoft.modelio.cms.api.IRevertResult;
import com.modeliosoft.modelio.cms.api.IUpdateCommand;
import com.modeliosoft.modelio.cms.api.IUpdateDetails;
import com.modeliosoft.modelio.cms.api.ModelChangesLoadingFailedException;
import com.modeliosoft.modelio.cms.api.contrib.CmsContributorVetoException;
import com.modeliosoft.modelio.cms.api.contrib.ICmsContributor;
import com.modeliosoft.modelio.cms.api.contrib.ICmsContributorHolder;
import com.modeliosoft.modelio.cms.api.contrib.IRemoveConfig;
import com.modeliosoft.modelio.cms.engine.pem.PemContributorHolder;
import com.modeliosoft.modelio.gproject.svn.plugin.ProjectSvn;
import java.util.concurrent.CompletableFuture;
import org.modelio.vbasic.log.Log;
import org.modelio.vbasic.progress.IModelioProgress;
import org.modelio.vbasic.progress.NullProgress;

public class AbstractProcessExtension
implements IProcessExtension {
    protected PemContributorHolder contribHolder = new PemContributorHolder();

    public void addContributor(ICmsContributor contrib) {
        this.contribHolder.addContributor(contrib);
    }

    public ICmsContributorHolder getContributorHolder() {
        return this.contribHolder;
    }

    public void onModelChangeKeeperError(ModelChangesLoadingFailedException e) {
        Log.error((String)"Model change keeper loading failed: ");
        Log.error((String)" Line number : %d ", (Object[])new Object[]{e.lineNumber});
        Log.error((String)" Note content :");
        String[] stringArray = e.failedNoteContent.split("\n");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String l = stringArray[n2];
            Log.error((String)(" > " + l));
            ++n2;
        }
        Log.error((String)" Error : %s", (Object[])new Object[]{e.getLocalizedMessage()});
        Log.error((Throwable)e);
    }

    public void postAdd(IAddResult result) {
        this.contribHolder.onAddSuccess(result);
    }

    public void postAddFailed(IAddCommand command, Exception cause) {
        this.contribHolder.onAddFailed(command.getConfiguration(), cause);
    }

    public void postCommit(ICommitResult commitResult) {
        this.contribHolder.onCommitSuccess(commitResult);
    }

    public void postCommitFailed(ICommitCommand command, Exception cause) {
        this.contribHolder.onCommitFailed(command.getConfiguration(), cause);
    }

    public void postGetLock(IGetLockResult lockResult) {
    }

    public void postGetLockFailed(IGetLockCommand command, Exception cause) {
        this.contribHolder.onGetLockFailed(command.getConfiguration(), cause);
    }

    public void postMerge(IMergeCommand command, IUpdateDetails result) {
        this.contribHolder.onMergeSuccess(command.getConfiguration(), result);
    }

    public void postMergeFailed(IMergeCommand command, Exception cause) {
        this.contribHolder.onMergeFailed(command.getConfiguration(), cause);
    }

    public void postRemove(IRemoveConfig result) {
        this.contribHolder.onRemoveSuccess(result);
    }

    public void postRemoveFailed(IRemoveCommand command, Exception cause) {
        this.contribHolder.onRemoveFailed(command.getConfiguration(), cause);
    }

    public void postRevert(IRevertResult result) {
        this.contribHolder.onRevertSuccess(result);
    }

    public void postRevertFailed(IRevertCommand command, Exception cause) {
        this.contribHolder.onRevertFailed(command.getConfiguration(), cause);
    }

    public void postUpdate(IUpdateDetails updateResult) {
        this.contribHolder.onUpdateSuccess(updateResult);
    }

    public void postUpdateFailed(IUpdateCommand command, Exception cause) {
        this.contribHolder.onUpdateFailed(command.getConfiguration(), cause);
    }

    public boolean preAdd(IModelioProgress monitor, IAddCommand command) {
        try {
            this.contribHolder.configAdd(monitor, command.getConfiguration());
        }
        catch (CmsContributorVetoException e) {
            ProjectSvn.LOG.warning(e);
            return false;
        }
        return true;
    }

    public boolean preCommit(IModelioProgress monitor, ICommitCommand command) {
        if (!this.preCommit(command)) {
            return false;
        }
        try {
            this.contribHolder.configCommit((IModelioProgress)new NullProgress(), command.getConfiguration());
        }
        catch (CmsContributorVetoException e) {
            ProjectSvn.LOG.warning(e);
            return false;
        }
        return true;
    }

    public boolean preGetLock(IModelioProgress monitor, IGetLockCommand command) {
        if (!this.preGetLock(command)) {
            return false;
        }
        try {
            this.contribHolder.configGetLock((IModelioProgress)new NullProgress(), command.getConfiguration());
        }
        catch (CmsContributorVetoException e) {
            ProjectSvn.LOG.warning(e);
            return false;
        }
        return true;
    }

    public boolean preMerge(IModelioProgress monitor, IMergeCommand command) {
        try {
            this.contribHolder.configMerge(monitor, command.getConfiguration());
        }
        catch (CmsContributorVetoException e) {
            ProjectSvn.LOG.warning(e);
            return false;
        }
        return true;
    }

    public boolean preRemove(IModelioProgress monitor, IRemoveCommand command) {
        try {
            this.contribHolder.configRemove(monitor, command.getConfiguration());
        }
        catch (CmsContributorVetoException e) {
            ProjectSvn.LOG.warning(e);
            return false;
        }
        return true;
    }

    public boolean preRevert(IModelioProgress monitor, IRevertCommand command) {
        if (!this.preRevert(command)) {
            return false;
        }
        try {
            this.contribHolder.configRevert(monitor, command.getConfiguration());
        }
        catch (CmsContributorVetoException e) {
            ProjectSvn.LOG.warning(e);
            return false;
        }
        return true;
    }

    public boolean preUpdate(IModelioProgress monitor, IUpdateCommand command) {
        if (!this.preUpdate(command)) {
            return false;
        }
        try {
            this.contribHolder.configUpdate(monitor, command.getConfiguration());
        }
        catch (CmsContributorVetoException e) {
            ProjectSvn.LOG.warning(e);
            return false;
        }
        return true;
    }

    public void removeContributor(ICmsContributor contrib) {
        this.contribHolder.removeContributor(contrib);
    }

    @Deprecated
    protected boolean preCommit(ICommitCommand command) {
        return true;
    }

    @Deprecated
    protected boolean preGetLock(IGetLockCommand getLockCommand) {
        return true;
    }

    @Deprecated
    protected boolean preRevert(IRevertCommand command) {
        return true;
    }

    @Deprecated
    protected boolean preUpdate(IUpdateCommand command) {
        return true;
    }

    public ICmsContributorHolder getPemContributorHolder() {
        return this.contribHolder;
    }

    public IProcessExtensionGui getGui() {
        return new EmptyGui();
    }

    public static class EmptyGui
    implements IProcessExtensionGui {
        public CompletableFuture<Void> displayCommitResult(ICommitResult result) {
            return CompletableFuture.completedFuture(null);
        }

        public CompletableFuture<Void> displayAddResult(IAddResult result) {
            return CompletableFuture.completedFuture(null);
        }

        public CompletableFuture<Void> displayMergeResult(IMergeCommand command, IUpdateDetails result) {
            return CompletableFuture.completedFuture(null);
        }

        public CompletableFuture<Void> displayGetLockResult(IGetLockResult result) {
            return CompletableFuture.completedFuture(null);
        }

        public CompletableFuture<Void> displayRemoveResult(IRemoveConfig result) {
            return CompletableFuture.completedFuture(null);
        }

        public CompletableFuture<Void> displayUpdateResult(IUpdateDetails result) {
            return CompletableFuture.completedFuture(null);
        }

        public CompletableFuture<Void> displayRevertResult(IRevertResult result) {
            return CompletableFuture.completedFuture(null);
        }

        public boolean displayPreRemove(IRemoveCommand command) {
            return true;
        }

        public boolean displayPreRevert(IRevertCommand command) {
            return true;
        }

        public boolean displayPreGetLock(IGetLockCommand command) {
            return true;
        }

        public boolean displayPreCommit(ICommitCommand command) {
            return true;
        }

        public boolean displayPreAdd(IAddCommand command) {
            return true;
        }

        public boolean displayPreUpdate(IUpdateCommand command) {
            return true;
        }

        public void displayModelChangeKeeperError(ModelChangesLoadingFailedException e) {
        }
    }
}

