/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.cms.engine.pem;

import com.modeliosoft.modelio.cms.api.IAddResult;
import com.modeliosoft.modelio.cms.api.ICommitResult;
import com.modeliosoft.modelio.cms.api.IGetLockResult;
import com.modeliosoft.modelio.cms.api.IRevertResult;
import com.modeliosoft.modelio.cms.api.IUpdateDetails;
import com.modeliosoft.modelio.cms.api.contrib.CmsContributorVetoException;
import com.modeliosoft.modelio.cms.api.contrib.IAddConfig;
import com.modeliosoft.modelio.cms.api.contrib.ICmsContributor;
import com.modeliosoft.modelio.cms.api.contrib.ICmsContributorHolder;
import com.modeliosoft.modelio.cms.api.contrib.ICommitConfig;
import com.modeliosoft.modelio.cms.api.contrib.IGetLockConfig;
import com.modeliosoft.modelio.cms.api.contrib.IMergeConfig;
import com.modeliosoft.modelio.cms.api.contrib.IRemoveConfig;
import com.modeliosoft.modelio.cms.api.contrib.IRevertConfig;
import com.modeliosoft.modelio.cms.api.contrib.IUpdateConfig;
import com.modeliosoft.modelio.gproject.svn.plugin.ProjectSvn;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.modelio.vbasic.progress.IModelioProgress;
import org.modelio.vbasic.progress.SubProgress;

public class PemContributorHolder
implements ICmsContributor,
ICmsContributorHolder {
    private final Map<String, ICmsContributor> contributors = new HashMap<String, ICmsContributor>();
    private final Map<ICmsContributorHolder.Action, List<String>> sortPostOrder = new HashMap<ICmsContributorHolder.Action, List<String>>();
    private final Map<ICmsContributorHolder.Action, List<String>> sortPreOrder = new HashMap<ICmsContributorHolder.Action, List<String>>();

    public void addContributor(ICmsContributor contributor) {
        if (this.contributors.get(contributor.getId()) != null) {
            throw new IllegalArgumentException(this.contributors.get(contributor.getId()).toString());
        }
        if (contributor.getId() == null) {
            throw new IllegalArgumentException(String.format("%s id is null", contributor.toString()));
        }
        this.contributors.put(contributor.getId(), contributor);
        ICmsContributorHolder.Action[] actionArray = ICmsContributorHolder.Action.values();
        int n = actionArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICmsContributorHolder.Action a = actionArray[n2];
            this.addContrib(a, contributor);
            ++n2;
        }
    }

    public void configAdd(IModelioProgress monitor, IAddConfig configuration) throws CmsContributorVetoException {
        List<ICmsContributor> contribs = this.getPreContributors(ICmsContributorHolder.Action.add);
        SubProgress mon = SubProgress.convert((IModelioProgress)monitor, (int)contribs.size());
        for (ICmsContributor c : contribs) {
            c.configAdd((IModelioProgress)mon.newChild(1), configuration);
        }
    }

    public void configCommit(IModelioProgress monitor, ICommitConfig configuration) throws CmsContributorVetoException {
        List<ICmsContributor> contribs = this.getPreContributors(ICmsContributorHolder.Action.commit);
        SubProgress mon = SubProgress.convert((IModelioProgress)monitor, (int)contribs.size());
        for (ICmsContributor c : contribs) {
            c.configCommit((IModelioProgress)mon.newChild(1), configuration);
        }
    }

    public void configGetLock(IModelioProgress monitor, IGetLockConfig configuration) throws CmsContributorVetoException {
        List<ICmsContributor> contribs = this.getPreContributors(ICmsContributorHolder.Action.getlock);
        SubProgress mon = SubProgress.convert((IModelioProgress)monitor, (int)contribs.size());
        for (ICmsContributor c : contribs) {
            c.configGetLock((IModelioProgress)mon.newChild(1), configuration);
        }
    }

    public void configMerge(IModelioProgress monitor, IMergeConfig configuration) throws CmsContributorVetoException {
        List<ICmsContributor> contribs = this.getPreContributors(ICmsContributorHolder.Action.merge);
        SubProgress mon = SubProgress.convert((IModelioProgress)monitor, (int)contribs.size());
        for (ICmsContributor c : contribs) {
            c.configMerge((IModelioProgress)mon.newChild(1), configuration);
        }
    }

    public void configRemove(IModelioProgress monitor, IRemoveConfig configuration) throws CmsContributorVetoException {
        List<ICmsContributor> contribs = this.getPreContributors(ICmsContributorHolder.Action.remove);
        SubProgress mon = SubProgress.convert((IModelioProgress)monitor, (int)contribs.size());
        for (ICmsContributor c : contribs) {
            c.configRemove((IModelioProgress)mon.newChild(1), configuration);
        }
    }

    public void configRevert(IModelioProgress monitor, IRevertConfig revertConfig) throws CmsContributorVetoException {
        List<ICmsContributor> contribs = this.getPreContributors(ICmsContributorHolder.Action.revert);
        SubProgress mon = SubProgress.convert((IModelioProgress)monitor, (int)contribs.size());
        for (ICmsContributor c : contribs) {
            c.configRevert((IModelioProgress)mon.newChild(1), revertConfig);
        }
    }

    public void configUpdate(IModelioProgress monitor, IUpdateConfig configuration) throws CmsContributorVetoException {
        List<ICmsContributor> contribs = this.getPreContributors(ICmsContributorHolder.Action.update);
        SubProgress mon = SubProgress.convert((IModelioProgress)monitor, (int)contribs.size());
        for (ICmsContributor c : contribs) {
            c.configUpdate((IModelioProgress)mon.newChild(1), configuration);
        }
    }

    public ICmsContributor getContributor(String id) {
        return this.contributors.get(id);
    }

    public String getId() {
        throw new UnsupportedOperationException();
    }

    public String getLabel() {
        return "CMS contributors holder";
    }

    public List<ICmsContributor> getPostContributors(ICmsContributorHolder.Action a) {
        List<String> ids = this.sortPostOrder.get(a);
        if (ids != null) {
            return this.getContributors(ids);
        }
        return Collections.emptyList();
    }

    public List<String> getPostOrder(ICmsContributorHolder.Action a) {
        List<String> l = this.sortPostOrder.get(a);
        return l != null ? new ArrayList<String>(l) : Collections.emptyList();
    }

    public List<ICmsContributor> getPreContributors(ICmsContributorHolder.Action a) {
        List<String> ids = this.sortPreOrder.get(a);
        if (ids != null) {
            return this.getContributors(ids);
        }
        return Collections.emptyList();
    }

    public List<String> getPreOrder(ICmsContributorHolder.Action a) {
        List<String> l = this.sortPreOrder.get(a);
        return l != null ? new ArrayList<String>(l) : Collections.emptyList();
    }

    public void loadFrom(Map<String, String> properties) {
        this.sortPreOrder.clear();
        this.sortPostOrder.clear();
        ICmsContributorHolder.Action[] actionArray = ICmsContributorHolder.Action.values();
        int n = actionArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICmsContributorHolder.Action a = actionArray[n2];
            String str = properties.get(a.name().concat(":pre"));
            if (str != null && !str.isEmpty()) {
                this.sortPreOrder.put(a, new ArrayList<String>(Arrays.asList(str.split(";"))));
            }
            if ((str = properties.get(a.name().concat(":post"))) != null && !str.isEmpty()) {
                this.sortPostOrder.put(a, new ArrayList<String>(Arrays.asList(str.split(";"))));
            }
            ++n2;
        }
    }

    public void onAddFailed(IAddConfig config, Throwable cause) {
        for (ICmsContributor c : this.getPostContributors(ICmsContributorHolder.Action.add)) {
            try {
                c.onAddFailed(config, cause);
            }
            catch (LinkageError | RuntimeException e) {
                this.logContributorCrash(c, e);
            }
        }
    }

    public void onAddSuccess(IAddResult details) {
        for (ICmsContributor c : this.getPostContributors(ICmsContributorHolder.Action.add)) {
            try {
                c.onAddSuccess(details);
            }
            catch (LinkageError | RuntimeException e) {
                this.logContributorCrash(c, e);
            }
        }
    }

    public void onCommitFailed(ICommitConfig config, Throwable cause) {
        for (ICmsContributor c : this.getPostContributors(ICmsContributorHolder.Action.commit)) {
            try {
                c.onCommitFailed(config, cause);
            }
            catch (LinkageError | RuntimeException e) {
                this.logContributorCrash(c, e);
            }
        }
    }

    public void onCommitSuccess(ICommitResult commitResult) {
        for (ICmsContributor c : this.getPostContributors(ICmsContributorHolder.Action.commit)) {
            try {
                c.onCommitSuccess(commitResult);
            }
            catch (LinkageError | RuntimeException e) {
                this.logContributorCrash(c, e);
            }
        }
    }

    public void onGetLockFailed(IGetLockConfig config, Throwable cause) {
        for (ICmsContributor c : this.getPostContributors(ICmsContributorHolder.Action.getlock)) {
            try {
                c.onGetLockFailed(config, cause);
            }
            catch (LinkageError | RuntimeException e) {
                this.logContributorCrash(c, e);
            }
        }
    }

    public void onGetLockSuccess(IGetLockResult lockResult) {
        for (ICmsContributor c : this.getPostContributors(ICmsContributorHolder.Action.getlock)) {
            try {
                c.onGetLockSuccess(lockResult);
            }
            catch (LinkageError | RuntimeException e) {
                this.logContributorCrash(c, e);
            }
        }
    }

    public void onMergeFailed(IMergeConfig config, Throwable cause) {
        for (ICmsContributor c : this.getPostContributors(ICmsContributorHolder.Action.merge)) {
            try {
                c.onMergeFailed(config, cause);
            }
            catch (LinkageError | RuntimeException e) {
                this.logContributorCrash(c, e);
            }
        }
    }

    public void onMergeSuccess(IMergeConfig config, IUpdateDetails mergeResult) {
        for (ICmsContributor c : this.getPostContributors(ICmsContributorHolder.Action.merge)) {
            try {
                c.onMergeSuccess(config, mergeResult);
            }
            catch (LinkageError | RuntimeException e) {
                this.logContributorCrash(c, e);
            }
        }
    }

    public void onRemoveFailed(IRemoveConfig config, Throwable cause) {
        for (ICmsContributor c : this.getPostContributors(ICmsContributorHolder.Action.remove)) {
            try {
                c.onRemoveFailed(config, cause);
            }
            catch (LinkageError | RuntimeException e) {
                this.logContributorCrash(c, e);
            }
        }
    }

    public void onRemoveSuccess(IRemoveConfig details) {
        for (ICmsContributor c : this.getPostContributors(ICmsContributorHolder.Action.remove)) {
            try {
                c.onRemoveSuccess(details);
            }
            catch (LinkageError | RuntimeException e) {
                this.logContributorCrash(c, e);
            }
        }
    }

    public void onRevertFailed(IRevertConfig config, Throwable cause) {
        for (ICmsContributor c : this.getPostContributors(ICmsContributorHolder.Action.revert)) {
            try {
                c.onRevertFailed(config, cause);
            }
            catch (LinkageError | RuntimeException e) {
                this.logContributorCrash(c, e);
            }
        }
    }

    public void onRevertSuccess(IRevertResult result) {
        for (ICmsContributor c : this.getPostContributors(ICmsContributorHolder.Action.revert)) {
            try {
                c.onRevertSuccess(result);
            }
            catch (LinkageError | RuntimeException e) {
                this.logContributorCrash(c, e);
            }
        }
    }

    public void onUpdateFailed(IUpdateConfig config, Throwable cause) {
        for (ICmsContributor c : this.getPostContributors(ICmsContributorHolder.Action.update)) {
            try {
                c.onUpdateFailed(config, cause);
            }
            catch (LinkageError | RuntimeException e) {
                this.logContributorCrash(c, e);
            }
        }
    }

    public void onUpdateSuccess(IUpdateDetails updateResult) {
        for (ICmsContributor c : this.getPostContributors(ICmsContributorHolder.Action.update)) {
            try {
                c.onUpdateSuccess(updateResult);
            }
            catch (LinkageError | RuntimeException e) {
                this.logContributorCrash(c, e);
            }
        }
    }

    public void removeContributor(ICmsContributor contributor) {
        this.contributors.remove(contributor.getId());
    }

    public void removeFromOrder(String contribId) {
        ICmsContributorHolder.Action[] actionArray = ICmsContributorHolder.Action.values();
        int n = actionArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICmsContributorHolder.Action a = actionArray[n2];
            this.removeContribId(a, contribId);
            ++n2;
        }
    }

    public void saveTo(Map<String, String> properties) {
        if (this.getPreOrder(ICmsContributorHolder.Action.add).isEmpty()) {
            return;
        }
        ICmsContributorHolder.Action[] actionArray = ICmsContributorHolder.Action.values();
        int n = actionArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICmsContributorHolder.Action a = actionArray[n2];
            StringBuilder s = new StringBuilder();
            for (String c : this.getPreOrder(a)) {
                if (s.length() > 0) {
                    s.append(";");
                }
                s.append(c);
            }
            properties.put(a.name().concat(":pre"), s.toString());
            s = new StringBuilder();
            for (String c : this.getPostOrder(a)) {
                if (s.length() > 0) {
                    s.append(";");
                }
                s.append(c);
            }
            properties.put(a.name().concat(":post"), s.toString());
            ++n2;
        }
    }

    public void setPostOrder(ICmsContributorHolder.Action a, List<String> ids) {
        this.sortPostOrder.put(a, ids);
    }

    public void setPreOrder(ICmsContributorHolder.Action a, List<String> ids) {
        this.sortPreOrder.put(a, ids);
    }

    private void addContrib(ICmsContributorHolder.Action category, ICmsContributor contributor) {
        List<String> l = this.sortPreOrder.get(category);
        if (l == null) {
            l = new ArrayList<String>();
            this.sortPreOrder.put(category, l);
        }
        if (!l.contains(contributor.getId())) {
            l.add(contributor.getId());
        }
        if ((l = this.sortPostOrder.get(category)) == null) {
            l = new ArrayList<String>();
            this.sortPostOrder.put(category, l);
        }
        if (!l.contains(contributor.getId())) {
            l.add(0, contributor.getId());
        }
    }

    private List<ICmsContributor> getContributors(List<String> ids) {
        ArrayList<ICmsContributor> newContribs = new ArrayList<ICmsContributor>(ids.size());
        for (String id : ids) {
            ICmsContributor c = this.getContributor(id);
            if (c == null) continue;
            newContribs.add(c);
        }
        return newContribs;
    }

    private void logContributorCrash(ICmsContributor c, Throwable e) {
        ProjectSvn.LOG.warning(e);
    }

    private void removeContribId(ICmsContributorHolder.Action category, String contribId) {
        List<String> l = this.sortPreOrder.get(category);
        if (l != null) {
            l.remove(contribId);
            if (l.isEmpty()) {
                this.sortPreOrder.remove(category);
            }
        }
        if ((l = this.sortPostOrder.get(category)) != null) {
            l.remove(contribId);
            if (l.isEmpty()) {
                this.sortPostOrder.remove(category);
            }
        }
    }
}

