/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.cms.engine.recorder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.modelio.vcore.smkernel.mapi.MRef;

class AssocFileMap<V> {
    private final Map<MRef, Map<String, V>> map = new HashMap<MRef, Map<String, V>>();

    public V get(MRef ref, String key) {
        Map<String, V> i = this.map.get(ref);
        if (i != null) {
            return i.get(key);
        }
        return null;
    }

    public Map<String, V> getAll(MRef ref) {
        return this.map.get(ref);
    }

    public Collection<V> getFiles(MRef ref) {
        return this.map.get(ref).values();
    }

    public void put(MRef ref, String key, V value) {
        Map<String, V> i = this.map.get(ref);
        if (i == null) {
            i = new HashMap<String, V>();
            this.map.put(ref, i);
        }
        i.put(key, value);
    }

    public V remove(MRef ref, String key) {
        Map<String, V> i = this.map.get(ref);
        if (i != null) {
            V ret = i.remove(key);
            if (i.isEmpty()) {
                this.map.remove(ref);
            }
            return ret;
        }
        return null;
    }

    public Map<String, V> removeAll(MRef ref) {
        return this.map.remove(ref);
    }

    public void dump(Handler<V> h) {
        for (Map.Entry<MRef, Map<String, V>> entry : this.map.entrySet()) {
            MRef ref = entry.getKey();
            Map<String, V> vs = entry.getValue();
            for (Map.Entry<String, V> entry2 : vs.entrySet()) {
                h.handle(ref, entry2.getKey(), entry2.getValue());
            }
        }
    }

    public boolean remove(MRef ref, String key, V value) {
        Map<String, V> i = this.map.get(ref);
        if (i != null && value.equals(i.get(key))) {
            V ret = i.remove(key);
            if (i.isEmpty()) {
                this.map.remove(ref);
            }
            return ret != null;
        }
        return false;
    }

    public String toString() {
        return this.getClass().getSimpleName() + String.valueOf(this.map);
    }

    Collection<AEntry<V>> getSnapshot() {
        final ArrayList<AEntry<V>> ret = new ArrayList<AEntry<V>>();
        this.dump(new Handler<V>(){

            @Override
            public void handle(MRef ref, String key, V val) {
                ret.add(new AEntry(ref, key, val));
            }
        });
        return ret;
    }

    public AssocFileMap() {
    }

    public AssocFileMap(AssocFileMap<V> other) {
        Handler copyHandler = new Handler<V>(){

            @Override
            public void handle(MRef ref, String key, V val) {
                AssocFileMap.this.put(ref, key, val);
            }
        };
        other.dump(copyHandler);
    }

    public static class AEntry<V> {
        private String key;
        private V value;
        private MRef ref;

        public MRef getRef() {
            return this.ref;
        }

        public String getKey() {
            return this.key;
        }

        public V getValue() {
            return this.value;
        }

        public AEntry(MRef ref, String key, V value) {
            this.ref = ref;
            this.key = key;
            this.value = value;
        }
    }

    public static interface Handler<V> {
        public void handle(MRef var1, String var2, V var3);
    }
}

