/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.cms.engine.recorder;

import com.modeliosoft.modelio.cms.api.files.IAssociatedFileMove;
import com.modeliosoft.modelio.cms.api.files.IFileChangesRecorder;
import com.modeliosoft.modelio.cms.driver.CmsDriverException;
import com.modeliosoft.modelio.cms.engine.recorder.AssocFileMap;
import com.modeliosoft.modelio.cms.engine.recorder.AssociatedFileMove;
import java.io.File;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.modelio.vcore.smkernel.mapi.MObject;
import org.modelio.vcore.smkernel.mapi.MRef;

public class AssociatedFileChangeRecorder
implements IFileChangesRecorder {
    final AssocFileMap<File> recordedFileDeletion;
    final AssocFileMap<File> recordedFiles;
    final AssocFileMap<AssociatedFileMove> recordedFileMoves;

    public Map<String, File> popAllFileDeletions(MRef ref) {
        Map<String, File> removed = this.recordedFileDeletion.removeAll(ref);
        if (removed == null) {
            removed = Collections.emptyMap();
        }
        return removed;
    }

    public Map<String, File> popAllFileModifs(MRef ref) {
        Map<String, File> removed = this.recordedFiles.removeAll(ref);
        if (removed == null) {
            removed = Collections.emptyMap();
        }
        return removed;
    }

    public Map<String, File> getAllFileDeletions(MRef ref) {
        Map<String, File> removed = this.recordedFileDeletion.getAll(ref);
        if (removed == null) {
            removed = Collections.emptyMap();
        }
        return removed;
    }

    public Map<String, File> getAllFileModifs(MRef ref) {
        Map<String, File> ret = this.recordedFiles.getAll(ref);
        if (ret == null) {
            ret = Collections.emptyMap();
        }
        return ret;
    }

    public Collection<? extends IAssociatedFileMove> getAllFileMoves(MRef ref) {
        Map<String, AssociatedFileMove> ret = this.recordedFileMoves.getAll(ref);
        if (ret == null) {
            ret = Collections.emptyMap();
        }
        return ret.values();
    }

    public void forAllFileMoves(MRef ref, MoveHandler handler) throws CmsDriverException {
        Map<String, AssociatedFileMove> l = this.recordedFileMoves.getAll(ref);
        if (l != null) {
            for (Map.Entry<String, AssociatedFileMove> entry : l.entrySet()) {
                AssociatedFileMove move = entry.getValue();
                handler.handle(ref, entry.getKey(), move.getOriginalFile(), move.getNewFile());
            }
        }
    }

    public File recordFile(MObject related, String key, File file) {
        AssociatedFileMove m;
        MRef ref = new MRef(related);
        this.recordedFileDeletion.remove(ref, key, file);
        File existing = this.recordedFiles.get(ref, key);
        if (existing == null && (m = this.recordedFileMoves.get(ref, key)) != null) {
            existing = m.getNewFile();
        }
        if (existing != null) {
            if (!existing.equals(file)) {
                return this.recordMove(ref, key, existing, file);
            }
            return existing;
        }
        this.recordedFiles.put(ref, key, file);
        return null;
    }

    public File recordFileMove(MObject related, String key, File oldFile, File newFile) {
        MRef ref = new MRef(related);
        this.recordedFileDeletion.remove(ref, key, newFile);
        return this.recordMove(ref, key, oldFile, newFile);
    }

    private File recordMove(MRef ref, String key, File oldFile, File newFile) {
        File ret = this.recordIndividualMove(ref, key, oldFile, newFile);
        if (oldFile.isDirectory() || newFile.isDirectory()) {
            this.recordDirectoryContentMove(ref, key, oldFile, newFile);
        }
        return ret;
    }

    public void recordDeletedFile(MObject related, String key, File file) {
        MRef ref = new MRef(related);
        File existing = this.recordedFiles.remove(ref, key);
        if (file == null) {
            if (existing != null) {
                this.recordedFileDeletion.put(ref, key, existing);
            }
        } else {
            this.recordedFileDeletion.put(ref, key, file);
        }
    }

    public File getRecordedFile(MObject related, String key) {
        AssociatedFileMove move;
        MRef ref = new MRef(related);
        File f = this.recordedFiles.get(ref, key);
        if (f == null && (move = this.recordedFileMoves.get(ref, key)) != null) {
            f = move.getNewFile();
        }
        return f;
    }

    public Collection<? extends IAssociatedFileMove> popAllFileMoves(MRef ref) {
        Map<String, AssociatedFileMove> l = this.recordedFileMoves.removeAll(ref);
        if (l != null) {
            return l.values();
        }
        return Collections.emptyList();
    }

    private File recordIndividualMove(MRef ref, String key, File oldFile, File newFile) {
        File ret = null;
        AssociatedFileMove m = this.recordedFileMoves.get(ref, key);
        if (m != null) {
            if (m.getOriginalFile().equals(newFile)) {
                this.recordedFileMoves.remove(ref, key);
            } else {
                ret = m.getNewFile();
                m.setNewFile(newFile);
            }
        } else {
            m = new AssociatedFileMove(ref, key, oldFile, newFile);
            this.recordedFileMoves.put(ref, key, m);
        }
        this.recordedFiles.remove(ref, key);
        return ret;
    }

    private void recordDirectoryContentMove(MRef ref, String key, File oldDir, File newDir) {
        final Path oldDirPath = oldDir.toPath();
        final Path newDirPath = newDir.toPath();
        this.recordedFiles.dump(new AssocFileMap.Handler<File>(){

            @Override
            public void handle(MRef ref, String key, File val) {
                Path entryCurPath = val.toPath();
                if (entryCurPath.startsWith(oldDirPath)) {
                    Path entryRelPath = oldDirPath.relativize(entryCurPath);
                    Path entryNewPath = newDirPath.resolve(entryRelPath);
                    AssociatedFileChangeRecorder.this.recordedFiles.put(ref, key, entryNewPath.toFile());
                }
            }
        });
        this.recordedFileMoves.dump(new AssocFileMap.Handler<AssociatedFileMove>(){

            @Override
            public void handle(MRef ref, String key, AssociatedFileMove val) {
                Path entryCurPath = val.getNewFile().toPath();
                if (entryCurPath.startsWith(oldDirPath)) {
                    Path entryRelPath = oldDirPath.relativize(entryCurPath);
                    Path entryNewPath = newDirPath.resolve(entryRelPath);
                    val.setNewFile(entryNewPath.toFile());
                }
            }
        });
    }

    public AssociatedFileChangeRecorder() {
        this.recordedFileDeletion = new AssocFileMap();
        this.recordedFiles = new AssocFileMap();
        this.recordedFileMoves = new AssocFileMap();
    }

    public AssociatedFileChangeRecorder(AssociatedFileChangeRecorder other) {
        this.recordedFileDeletion = new AssocFileMap<File>(other.recordedFileDeletion);
        this.recordedFiles = new AssocFileMap<File>(other.recordedFiles);
        this.recordedFileMoves = new AssocFileMap();
        other.recordedFileMoves.dump(new AssocFileMap.Handler<AssociatedFileMove>(){

            @Override
            public void handle(MRef ref, String key, AssociatedFileMove val) {
                AssociatedFileChangeRecorder.this.recordedFileMoves.put(ref, key, new AssociatedFileMove(val));
            }
        });
    }

    public static interface MoveHandler {
        public void handle(MRef var1, String var2, File var3, File var4) throws CmsDriverException;
    }
}

