/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.cms.engine.recorder;

import com.modeliosoft.modelio.cms.api.ModelChangesLoadingFailedException;
import com.modeliosoft.modelio.cms.engine.recorder.AssocFileMap;
import com.modeliosoft.modelio.cms.engine.recorder.AssociatedFileChangeRecorder;
import com.modeliosoft.modelio.cms.engine.recorder.AssociatedFileMove;
import com.modeliosoft.modelio.cms.engine.recorder.ElementMoveRef;
import com.modeliosoft.modelio.cms.engine.recorder.ModelChangeKeeper;
import com.modeliosoft.modelio.gproject.svn.plugin.ProjectSvn;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.InputMismatchException;
import java.util.NoSuchElementException;
import java.util.Scanner;
import org.modelio.vbasic.files.FileUtils;
import org.modelio.vbasic.log.Log;
import org.modelio.vcore.session.api.model.IModel;
import org.modelio.vcore.smkernel.mapi.MObject;
import org.modelio.vcore.smkernel.mapi.MRef;

class Loader {
    private static final Collection<String> OBSOLETE_CLASSES = Arrays.asList("DiagramContainer");
    private IModel imodel;

    public Loader(IModel imodel) {
        this.imodel = imodel;
    }

    private static String readLine(Scanner r) throws IOException {
        String s = r.next();
        if (r.ioException() != null) {
            throw r.ioException();
        }
        return s;
    }

    private static MRef readObRef(Scanner r) throws IOException {
        String mc = Loader.readLine(r);
        if (mc.equals("null")) {
            return null;
        }
        if (OBSOLETE_CLASSES.contains(mc)) {
            Loader.readLine(r);
            return null;
        }
        String uuid = Loader.readLine(r);
        return new MRef(mc, uuid);
    }

    private MObject readElement(Scanner r) throws IOException {
        MRef ref = Loader.readObRef(r);
        if (ref == null) {
            return null;
        }
        return this.imodel.findByRef(ref);
    }

    private ElementMoveRef readMove(Scanner r) throws IOException {
        MRef moved = Loader.readObRef(r);
        MRef oldParent = Loader.readObRef(r);
        MRef newParent = Loader.readObRef(r);
        if (moved == null) {
            return null;
        }
        return new ElementMoveRef(moved, oldParent, newParent);
    }

    private static int readInt(Scanner r) throws InputMismatchException, IOException, NoSuchElementException {
        int ret = r.nextInt();
        if (r.ioException() != null) {
            throw r.ioException();
        }
        return ret;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void read(ModelChangeKeeper keeper, Path path) throws ModelChangesLoadingFailedException {
        LineNumberReader ln = null;
        int line = -1;
        if (!Files.isRegularFile(path, new LinkOption[0])) {
            return;
        }
        try {
            Throwable throwable = null;
            Object var6_9 = null;
            try {
                BufferedReader is = Files.newBufferedReader(path, StandardCharsets.UTF_8);
                try {
                    block22: {
                        LineNumberReader lln = new LineNumberReader(is);
                        try {
                            try (Scanner r = new Scanner(lln);){
                                ln = lln;
                                r.useDelimiter("\n|\r\n");
                                this.read(r, keeper);
                            }
                            if (lln == null) break block22;
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            if (lln == null) throw throwable;
                            lln.close();
                            throw throwable;
                        }
                        lln.close();
                    }
                    if (is == null) return;
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                    } else if (throwable != throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    if (is == null) throw throwable;
                    ((Reader)is).close();
                    throw throwable;
                }
                ((Reader)is).close();
                return;
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                    throw throwable;
                }
                if (throwable == throwable4) throw throwable;
                throwable.addSuppressed(throwable4);
                throw throwable;
            }
        }
        catch (RuntimeException e) {
            if (ln == null) throw new ModelChangesLoadingFailedException((Throwable)e, this.getContent(path), line);
            line = ln.getLineNumber();
            throw new ModelChangesLoadingFailedException((Throwable)e, this.getContent(path), line);
        }
        catch (IOException e) {
            if (ln == null) throw new ModelChangesLoadingFailedException((Throwable)e, this.getContent(path), line);
            line = ln.getLineNumber();
            throw new ModelChangesLoadingFailedException((Throwable)e, this.getContent(path), line);
        }
    }

    private void read(Scanner r, ModelChangeKeeper ret) throws InputMismatchException, IOException, NoSuchElementException {
        this.imodel = ret.session.getModel();
        int nbMoves = Loader.readInt(r);
        int i = 0;
        while (i < nbMoves) {
            ElementMoveRef move = this.readMove(r);
            if (move != null) {
                ret.addMove(move);
            }
            ++i;
        }
        int nbDel = Loader.readInt(r);
        int i2 = 0;
        while (i2 < nbDel) {
            MRef parent = Loader.readObRef(r);
            int nb3 = Loader.readInt(r);
            int i3 = 0;
            while (i3 < nb3) {
                MRef deletedChild = Loader.readObRef(r);
                ret.addDeleted(deletedChild, parent);
                ++i3;
            }
            ++i2;
        }
        if (r.hasNextLine()) {
            this.readFileChanges(r, ret.getFilesRecorder());
        }
    }

    private void readFileChanges(Scanner r, AssociatedFileChangeRecorder ret) throws IOException {
        if (r.hasNext()) {
            this.readAssocFileMap(r, ret.recordedFileDeletion);
            this.readAssocFileMap(r, ret.recordedFiles);
            this.readAssociatedFileMoves(r, ret.recordedFileMoves);
        }
    }

    private void readAssocFileMap(Scanner r, AssocFileMap<File> m) throws IOException {
        String l = Loader.readLine(r);
        while (l.equals("+")) {
            MRef ref = Loader.readObRef(r);
            String key = Loader.readLine(r);
            String value = Loader.readLine(r);
            m.put(ref, key, new File(value));
            l = Loader.readLine(r);
        }
    }

    private void readAssociatedFileMoves(Scanner r, AssocFileMap<AssociatedFileMove> m) throws IOException {
        String l = Loader.readLine(r);
        while (l.equals("+")) {
            MRef ref = Loader.readObRef(r);
            String key = Loader.readLine(r);
            String oldFile = Loader.readLine(r);
            String newFile = Loader.readLine(r);
            m.put(ref, key, new AssociatedFileMove(ref, key, new File(oldFile), new File(newFile)));
            l = Loader.readLine(r);
        }
    }

    private String getContent(Path path) {
        try {
            return FileUtils.readWhole((Path)path, (String)StandardCharsets.UTF_8.name());
        }
        catch (IOException e) {
            return ProjectSvn.I18N.getMessage("recorder.Loader.IOException", new Object[]{path, FileUtils.getLocalizedMessage((IOException)e)});
        }
        catch (RuntimeException e) {
            Log.error((Throwable)e);
            return ProjectSvn.I18N.getMessage("recorder.Loader.RuntimeException", new Object[]{path, e.toString()});
        }
    }
}

