/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.cms.engine.recorder;

import com.modeliosoft.modelio.cms.api.IElementMoveRef;
import com.modeliosoft.modelio.cms.api.ModelChangesLoadingFailedException;
import com.modeliosoft.modelio.cms.engine.recorder.AssociatedFileChangeRecorder;
import com.modeliosoft.modelio.cms.engine.recorder.ElementMoveRef;
import com.modeliosoft.modelio.cms.engine.recorder.Loader;
import com.modeliosoft.modelio.cms.engine.recorder.Saver;
import com.modeliosoft.modelio.gproject.svn.plugin.ProjectSvn;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.modelio.vcore.session.api.ICoreSession;
import org.modelio.vcore.smkernel.mapi.MObject;
import org.modelio.vcore.smkernel.mapi.MRef;

public class ModelChangeKeeper {
    final Map<MRef, Set<MRef>> deletions;
    private final Map<MRef, Set<ElementMoveRef>> movesFromMap;
    private final Map<MRef, Set<ElementMoveRef>> movesToMap;
    final Map<MRef, ElementMoveRef> moveMap;
    private final transient Path savePoint;
    private final Map<MRef, MRef> deletedElements;
    final ICoreSession session;
    private final Map<MRef, Collection<String>> blobDeletions;
    private final AssociatedFileChangeRecorder filesRecorder;

    private ModelChangeKeeper(ICoreSession session, Path savePoint) {
        this.savePoint = savePoint;
        this.session = session;
        this.moveMap = new HashMap<MRef, ElementMoveRef>();
        this.deletedElements = new HashMap<MRef, MRef>();
        this.blobDeletions = new HashMap<MRef, Collection<String>>();
        this.filesRecorder = new AssociatedFileChangeRecorder();
        this.movesFromMap = new HashMap<MRef, Set<ElementMoveRef>>();
        this.movesToMap = new HashMap<MRef, Set<ElementMoveRef>>();
        this.deletions = new HashMap<MRef, Set<MRef>>();
    }

    void addDeleted(MRef deletedChild, MRef parent) {
        Set<MRef> v = this.deletions.get(parent);
        if (v == null) {
            v = new HashSet<MRef>();
            this.deletions.put(parent, v);
        }
        v.add(deletedChild);
        this.deletedElements.put(deletedChild, parent);
    }

    void addMove(ElementMoveRef move) {
        MRef oldParentRef = move.getOldParent();
        MRef newParent = move.getNewParent();
        MRef moved = move.getMoved();
        MObject oldParent = this.findByRef(oldParentRef);
        if (oldParent != null && oldParent.getStatus().isCmsManaged()) {
            this.addMoveFrom(oldParentRef, move);
        }
        if (newParent != null) {
            this.addMoveTo(newParent, move);
        }
        this.moveMap.put(moved, move);
    }

    public void recordDeleted(MObject deleted, MObject parent) {
        MObject oldParent;
        MRef deletedRef = MRef.withoutName((MObject)deleted);
        ElementMoveRef move = this.moveMap.get(deletedRef);
        if (move != null && move.getOldParent() != null) {
            MRef oldParentRef = move.getOldParent();
            oldParent = this.findByRef(oldParentRef);
        } else if (parent != null) {
            oldParent = parent;
        } else {
            try {
                ProjectSvn.LOG.warning("ModelChangeKeeper.recordDeleted(): " + deleted.toString() + " had no CMS node parent.");
            }
            catch (RuntimeException runtimeException) {
                ProjectSvn.LOG.warning("ModelChangeKeeper.recordDeleted(): {" + deleted.getUuid() + "} " + deleted.getMClass().getName() + " had no CMS node parent.");
            }
            oldParent = null;
        }
        if (oldParent != null && deleted.getMClass().isCmsNode() && oldParent.getStatus().isCmsManaged() && deleted.getStatus().isCmsManaged()) {
            this.addDeleted(deletedRef, new MRef(oldParent));
            this.recordDeletedBlobs(deletedRef, this.session.getBlobSupport().getRelatedBlobs(deleted));
        }
    }

    public void getAllDeleted(MRef parentNode, Set<MRef> ret, Collection<String> deletedBlobs) {
        Set<MRef> deletedChildren = this.deletions.get(parentNode);
        Collection<String> lblobDeletions = this.blobDeletions.get(parentNode);
        if (deletedChildren != null) {
            ret.addAll(deletedChildren);
            if (lblobDeletions != null) {
                deletedBlobs.addAll(lblobDeletions);
            }
            for (MRef deletedChild : deletedChildren) {
                this.getAllDeleted(deletedChild, ret, deletedBlobs);
            }
        }
    }

    public void recordMove(MObject moved, MObject oldParent, MObject newParent) {
        MRef newParentRef = new MRef(newParent);
        MRef movedRef = new MRef(moved);
        MRef firstParentRef = new MRef(oldParent);
        ElementMoveRef oldMove = this.moveMap.get(movedRef);
        if (oldMove != null) {
            this.removeMove(oldMove);
            firstParentRef = oldMove.getOldParent();
            if (firstParentRef != null && firstParentRef.equals((Object)newParentRef)) {
                this.removeDeleted(movedRef, true);
                return;
            }
        }
        ElementMoveRef move = new ElementMoveRef(movedRef, firstParentRef, newParentRef);
        MObject firstParent = this.session.getModel().findByRef(firstParentRef);
        if (firstParent != null && firstParent.getStatus().isCmsManaged()) {
            this.addMoveFrom(firstParentRef, move);
        }
        this.addMoveTo(newParentRef, move);
        this.moveMap.put(movedRef, move);
    }

    private void removeMove(IElementMoveRef oldMove) {
        this.moveMap.remove(oldMove.getMoved());
        Set<ElementMoveRef> v = this.movesToMap.get(oldMove.getNewParent());
        if (v != null) {
            v.remove(oldMove);
        }
        if ((v = this.movesFromMap.get(oldMove.getOldParent())) != null) {
            v.remove(oldMove);
        }
    }

    public void getMoves(MRef moved, Set<IElementMoveRef> elementMoves) {
        ElementMoveRef move = this.moveMap.get(moved);
        if (move != null) {
            elementMoves.add(move);
        }
    }

    public void getMovesTo(MRef node, Collection<IElementMoveRef> moveDependencies) {
        Set<ElementMoveRef> v = this.movesToMap.get(node);
        if (v != null) {
            moveDependencies.addAll(v);
        }
    }

    public void getMovesFrom(MRef oldParent, Collection<IElementMoveRef> movedElements) {
        Set<ElementMoveRef> v = this.movesFromMap.get(oldParent);
        if (v != null) {
            movedElements.addAll(v);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void save() throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try {
            BufferedWriter s = Files.newBufferedWriter(this.savePoint, StandardCharsets.UTF_8, new OpenOption[0]);
            try {
                try (PrintWriter p = new PrintWriter(s);){
                    Saver.write(this, p);
                }
                if (s == null) return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (s == null) throw throwable;
                ((Writer)s).close();
                throw throwable;
            }
            ((Writer)s).close();
            return;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    public void removeDeleted(MRef createdRef, boolean withAliveChild) {
        Set<MRef> deletedChilds;
        Set<MRef> parentDelChilds;
        MRef parentRef = this.deletedElements.remove(createdRef);
        if (parentRef != null && (parentDelChilds = this.deletions.get(parentRef)) != null) {
            parentDelChilds.remove(createdRef);
            if (parentDelChilds.isEmpty()) {
                this.deletions.remove(parentRef);
            }
        }
        this.blobDeletions.remove(createdRef);
        if (withAliveChild && (deletedChilds = this.deletions.get(createdRef)) != null) {
            for (MRef child : new ArrayList<MRef>(deletedChilds)) {
                MObject childEl = this.session.getModel().findByRef(child);
                if (childEl == null || childEl.isDeleted()) continue;
                this.removeDeleted(child, true);
            }
        }
    }

    public static ModelChangeKeeper load(ICoreSession session, Path savePath) throws ModelChangesLoadingFailedException {
        ModelChangeKeeper ret = new ModelChangeKeeper(session, savePath);
        new Loader(session.getModel()).read(ret, savePath);
        return ret;
    }

    public static ModelChangeKeeper createEmpty(ICoreSession iCoreSession, Path savePath) {
        return new ModelChangeKeeper(iCoreSession, savePath);
    }

    private void addMoveTo(MRef newParent, ElementMoveRef move) {
        Set<ElementMoveRef> v = this.movesToMap.get(newParent);
        if (v == null) {
            v = new HashSet<ElementMoveRef>();
            this.movesToMap.put(newParent, v);
        }
        v.add(move);
    }

    private void addMoveFrom(MRef oldParent, ElementMoveRef move) {
        Set<ElementMoveRef> v = this.movesFromMap.get(oldParent);
        if (v == null) {
            v = new HashSet<ElementMoveRef>();
            this.movesFromMap.put(oldParent, v);
        }
        v.add(move);
    }

    public boolean hasMoved(MRef moved) {
        return this.moveMap.containsKey(moved);
    }

    private void recordDeletedBlobs(MRef obj, Collection<String> blobs) {
        Collection<String> v = this.blobDeletions.get(obj);
        if (v == null) {
            v = new HashSet<String>();
            this.blobDeletions.put(obj, v);
        }
        v.addAll(blobs);
    }

    public AssociatedFileChangeRecorder getFilesRecorder() {
        return this.filesRecorder;
    }

    public MRef getDeletedParent(MRef deletedRef) {
        return this.deletedElements.get(deletedRef);
    }

    private MObject findByRef(MRef ref) {
        return this.session.getModel().findByRef(ref);
    }

    public void _removeAllDeletedRef(Collection<MRef> toForget) {
        for (MRef delNode : toForget) {
            this.removeDeleted(delNode, true);
        }
    }

    public void removeMoves(Collection<IElementMoveRef> toRemove) {
        for (IElementMoveRef move : toRemove) {
            this.removeMove(move);
        }
    }

    public void removeAllDeletedRef(Stream<MRef> toForget) {
        toForget.forEach(delNode -> this.removeDeleted((MRef)delNode, true));
    }
}

