/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.cms.engine.recorder;

import com.modeliosoft.modelio.cms.engine.recorder.AssocFileMap;
import com.modeliosoft.modelio.cms.engine.recorder.AssociatedFileChangeRecorder;
import com.modeliosoft.modelio.cms.engine.recorder.AssociatedFileMove;
import com.modeliosoft.modelio.cms.engine.recorder.ElementMoveRef;
import com.modeliosoft.modelio.cms.engine.recorder.ModelChangeKeeper;
import java.io.File;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Map;
import org.modelio.vcore.smkernel.mapi.MObject;
import org.modelio.vcore.smkernel.mapi.MRef;

class Saver {
    private Saver() {
    }

    public static void write(ModelChangeKeeper k, PrintWriter p) {
        p.println(k.moveMap.size());
        for (ElementMoveRef elementMoveRef : k.moveMap.values()) {
            Saver.write(elementMoveRef, p);
        }
        p.println(k.deletions.size());
        for (Map.Entry entry : k.deletions.entrySet()) {
            Saver.write((MRef)entry.getKey(), p);
            Saver.write((Collection)entry.getValue(), p);
        }
        Saver.writeFilesRecorder(k.getFilesRecorder(), p);
    }

    private static void write(Collection<MRef> set, PrintWriter p) {
        p.println(set.size());
        for (MRef ref : set) {
            Saver.write(ref, p);
        }
    }

    private static void write(MRef ref, PrintWriter w) {
        w.println(ref.mc);
        w.println(ref.uuid);
    }

    private static void write(MObject el, PrintWriter w) {
        if (el == null) {
            w.println("null");
        } else {
            w.println(el.getMClass().getName());
            w.println(el.getUuid());
        }
    }

    private static void write(ElementMoveRef move, PrintWriter w) {
        Saver.write(move.getMoved(), w);
        Saver.write(move.getOldParent(), w);
        Saver.write(move.getNewParent(), w);
    }

    public static void writeFilesRecorder(AssociatedFileChangeRecorder k, PrintWriter p) {
        Saver.write(k.recordedFileDeletion, p);
        Saver.write(k.recordedFiles, p);
        Saver.writeMoves(k.recordedFileMoves, p);
    }

    private static void writeMoves(AssocFileMap<AssociatedFileMove> m, final PrintWriter p) {
        m.dump(new AssocFileMap.Handler<AssociatedFileMove>(){

            @Override
            public void handle(MRef ref, String key, AssociatedFileMove val) {
                p.println('+');
                Saver.write(ref, p);
                p.println(key);
                p.println(val.getOriginalFile());
                p.println(val.getNewFile());
            }
        });
        p.println("---");
    }

    private static void write(AssocFileMap<File> m, final PrintWriter p) {
        m.dump(new AssocFileMap.Handler<File>(){

            @Override
            public void handle(MRef ref, String key, File val) {
                p.println('+');
                Saver.write(ref, p);
                p.println(key);
                p.println(val.toString());
            }
        });
        p.println("---");
    }
}

