/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.cms.model;

import com.modeliosoft.modelio.cms.model.ModelGroup;
import com.modeliosoft.modelio.gproject.svn.fragment.GSvnFragment;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.modelio.gproject.core.IGModelFragment;
import org.modelio.gproject.core.IGProject;
import org.modelio.gproject.project.AbstractGProject;
import org.modelio.vcore.smkernel.mapi.MObject;

public final class ModelGroups
implements Iterable<ModelGroup> {
    private List<ModelGroup> groups;

    public ModelGroups(Collection<? extends MObject> selection) {
        HashMap<IGModelFragment, ModelGroup> ret = new HashMap<IGModelFragment, ModelGroup>();
        for (MObject mObject : selection) {
            ModelGroup group;
            IGProject proj = AbstractGProject.getProject((MObject)mObject);
            IGModelFragment frag = null;
            if (proj != null) {
                frag = proj.getFragment(mObject);
            }
            if ((group = (ModelGroup)ret.get(frag)) == null) {
                group = new ModelGroup(frag);
                ret.put(frag, group);
            }
            group.add(mObject);
        }
        this.groups = new ArrayList(ret.values());
    }

    public List<ModelGroup> getGroups() {
        return this.groups;
    }

    public boolean areAllSvn() {
        for (ModelGroup g : this.groups) {
            if (g.getFragment() instanceof GSvnFragment) continue;
            return false;
        }
        return true;
    }

    public boolean isSingle() {
        return this.groups.size() <= 1;
    }

    @Override
    public Iterator<ModelGroup> iterator() {
        return this.groups.iterator();
    }

    public ModelGroup first() throws IndexOutOfBoundsException {
        return this.groups.get(0);
    }

    public int size() {
        return this.groups.size();
    }

    public static ModelGroups makeSvnGroups(Collection<MObject> els) {
        ModelGroups ret = new ModelGroups(els);
        Iterator<ModelGroup> it = ret.iterator();
        while (it.hasNext()) {
            if (it.next().getFragment() instanceof GSvnFragment) continue;
            it.remove();
        }
        return ret;
    }

    public void assertAllSvn() {
        if (!this.areAllSvn()) {
            throw new IllegalArgumentException("Only versioned elements are allowed.");
        }
    }

    public void assertSingle() {
        if (!this.isSingle()) {
            throw new IllegalArgumentException("Elements must belong to the same fragment.");
        }
    }
}

