/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.cms.repository;

import com.modeliosoft.modelio.cms.repository.CmsVersionedRepository;
import com.modeliosoft.modelio.cms.utils.CmsNodeUtils;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.modelio.vbasic.log.Log;
import org.modelio.vcore.session.impl.storage.IModelLoader;
import org.modelio.vcore.smkernel.SmObjectImpl;
import org.modelio.vcore.smkernel.StatusState;
import org.modelio.vcore.smkernel.mapi.MObject;
import org.modelio.vcore.smkernel.mapi.MStatus;
import org.modelio.vcore.smkernel.meta.SmDependency;
import org.modelio.vstore.exml.common.ExmlStorageHandler;
import org.modelio.vstore.exml.common.IExmlBase;
import org.modelio.vstore.exml.common.utils.ExmlUtils;

class CmsVersionedExmlStorageHandler
extends ExmlStorageHandler {
    private static final boolean TRACE = false;
    static final long STATUS_TO_ADD_LOCAL = 0x100000000000L;
    private static Action[][] moveActionsTable = new Action[][]{{Action.Nothing, Action.CmsAdd, Action.Nothing, Action.CmsAdd, Action.Nothing}, {Action.CancelCmsAdd, Action.Nothing, Action.CancelCmsAdd, Action.Nothing, Action.CancelCmsAdd}, {Action.Forbid, Action.Forbid, Action.Forbid, Action.Forbid, Action.Forbid}, {Action.Remove, Action.Nothing, Action.Forbid, Action.Nothing, Action.Remove}, {Action.Nothing, Action.Restore, Action.Forbid, Action.Restore, Action.Nothing}};
    private static final Object cmsStatusLock = new Object();
    private CompletableFuture<Void> cmsStatusFlagsLoadedFuture = new CompletableFuture();

    public CmsVersionedExmlStorageHandler(CmsVersionedRepository base, SmObjectImpl cmsNode, boolean isNodeLoaded) {
        super((IExmlBase)base, cmsNode, isNodeLoaded);
    }

    protected void onObjAttachedToThis(SmObjectImpl obj, boolean isNewObject) {
        super.onObjAttachedToThis(obj, isNewObject);
        boolean objIsCmsNode = obj.getMClass().isCmsNode();
        if (objIsCmsNode && isNewObject) {
            this.setToBeAdded(obj);
            this.setCmsStatusLoaded(true);
        }
        SmObjectImpl myCmsNode = this.getCmsNode();
        assert (myCmsNode != null);
        this.getBase().getHistoryHook().onAttachObject(obj, myCmsNode);
        if (objIsCmsNode) {
            if (myCmsNode.equals((Object)obj)) {
                if (!isNewObject) {
                    this.getBase().refreshStatus(Collections.singleton(obj));
                    MStatus refreshedStatus = obj.getStatus();
                    if (refreshedStatus.isCmsToDelete()) {
                        obj.setRStatus(0x8800000000L, 0x2000000000L, 0L);
                    }
                }
            } else {
                throw new IllegalStateException(String.format("%s is attached to %s instead of %s", new Object[]{obj, obj.getRepositoryObject(), this}));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCmsStatusLoaded(boolean newState) {
        Object object = cmsStatusLock;
        synchronized (object) {
            assert (this.cmsStatusFlagsLoadedFuture != null);
            if (newState == this.cmsStatusFlagsLoadedFuture.isDone()) {
                return;
            }
            if (!newState) {
                if (this.cmsStatusFlagsLoadedFuture.isDone()) {
                    CompletableFuture newFuture = new CompletableFuture();
                    Log.trace((String)"%s.setCmsStatusLoaded(%s) on %s : this.cmsStatusFlagsLoadedFuture : %s -> %s", (Object[])new Object[]{((Object)((Object)this)).getClass().getSimpleName(), newState, this.getCmsNodeId(), this.cmsStatusFlagsLoadedFuture, newFuture});
                    this.cmsStatusFlagsLoadedFuture = newFuture;
                }
            } else if (this.cmsStatusFlagsLoadedFuture != null) {
                this.cmsStatusFlagsLoadedFuture.complete(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCmsStatusLoaded() {
        Object object = cmsStatusLock;
        synchronized (object) {
            return this.cmsStatusFlagsLoadedFuture.isDone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isStatusFullyLoaded(SmObjectImpl obj) {
        Object object = cmsStatusLock;
        synchronized (object) {
            return this.isLoaded() && this.cmsStatusFlagsLoadedFuture.isDone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<Void> whenStatusFullyLoaded(SmObjectImpl obj) {
        CompletableFuture<Void> ret;
        boolean isStatusToLoad = false;
        boolean isObjLoaded = this.isLoaded();
        Object object = cmsStatusLock;
        synchronized (object) {
            if (this.isStatusFullyLoaded(obj)) {
                return CompletableFuture.completedFuture(null);
            }
            ret = this.cmsStatusFlagsLoadedFuture;
            if (!ret.isDone() && !isObjLoaded) {
                isStatusToLoad = true;
                if (!isObjLoaded) {
                    Log.trace((String)"%s.whenStatusFullyLoaded(%s) on %s : loaded=%s, future=%s", (Object[])new Object[]{((Object)((Object)this)).getClass().getSimpleName(), obj, this.getCmsNodeId(), isObjLoaded, this.cmsStatusFlagsLoadedFuture});
                }
            }
        }
        if (isStatusToLoad) {
            if (!isObjLoaded) {
                this.loadAtt(obj, obj.getClassOf().statusAtt());
            } else {
                this.getBase().refreshStatus(List.of(obj));
            }
        }
        return ret.copy();
    }

    public void loadStatus(SmObjectImpl obj) {
        if (this.isStatusFullyLoaded(obj)) {
            return;
        }
        this.load();
        SmObjectImpl cmsNode = this.getCmsNode();
        if (cmsNode == null) {
            String msg = String.format("ExmlStorageHandler.getCmsNode(): %s not found in %s. The node was probably deleted then unloaded", new Object[]{this.getCmsNodeId(), this.getBase()});
            throw new IllegalStateException(msg);
        }
        Throwable throwable = null;
        Object var4_6 = null;
        try (IModelLoader loader = this.getBase().getModelLoaderProvider().beginLoadSession();){
            this.getBase().getStatusInitializer().loadCmsNodeStatus(cmsNode, loader);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void depValAppended(SmObjectImpl obj, SmDependency dep, SmObjectImpl val) {
        if (ExmlUtils.isComposition((SmObjectImpl)obj, (SmDependency)dep, (SmObjectImpl)val)) {
            if (val.getMClass().isCmsNode()) {
                this.updateMovedObjState(this.getCmsNode(), val);
            } else {
                for (MObject childCmsNode : CmsNodeUtils.getChildren((MObject)val)) {
                    this.updateMovedObjState(this.getCmsNode(), (SmObjectImpl)childCmsNode);
                }
            }
        }
        super.depValAppended(obj, dep, val);
    }

    public void detach(SmObjectImpl obj) {
        this.getBase().getHistoryHook().onDetachObject(obj, this.getCmsNode());
        super.detach(obj);
        if (obj.getMClass().isCmsNode() && !obj.isDeleted()) {
            obj.setRStatus(0L, 21955872818176L, 0L);
        }
    }

    protected CmsVersionedRepository getBase() {
        return (CmsVersionedRepository)super.getBase();
    }

    private void updateMovedObjState(SmObjectImpl parent, SmObjectImpl moved) {
        CmsState newParentState = CmsVersionedExmlStorageHandler.getState(parent);
        CmsState movedState = CmsVersionedExmlStorageHandler.getState(moved);
        this.updateMovedObjectState(parent, moved, newParentState, movedState);
    }

    private void updateChildrenState(SmObjectImpl moved) {
        for (MObject child : CmsNodeUtils.getChildren((MObject)moved)) {
            SmObjectImpl smChild = (SmObjectImpl)child;
            if (smChild.getRepositoryObject().getRepositoryId() != this.getRepositoryId()) continue;
            this.updateMovedObjState(moved, smChild);
        }
    }

    private void setToBeAdded(SmObjectImpl obj) {
        long trueFlags = 0x101000000000L;
        long falseFlags = 0x2000000000L;
        if (this.getBase().isLockNeeded()) {
            trueFlags |= 0x20000000000L;
        } else {
            falseFlags |= 0x20000000000L;
        }
        obj.setRStatus(trueFlags, falseFlags, 0L);
    }

    private void updateMovedObjectState(SmObjectImpl newParent, SmObjectImpl moved, CmsState newParentState, CmsState movedState) {
        Action action = moveActionsTable[movedState.ordinal()][newParentState.ordinal()];
        switch (action) {
            case Nothing: {
                break;
            }
            case CmsAdd: {
                MStatus refreshedStatus = moved.getStatus();
                if (!refreshedStatus.isCmsManaged()) {
                    this.setToBeAdded(moved);
                } else if (refreshedStatus.isCmsToDelete()) {
                    moved.setRStatus(0x8800000000L, 0x2000000000L, 0L);
                }
                this.updateChildrenState(moved);
                break;
            }
            case CancelCmsAdd: {
                moved.setRStatus(0L, 0x121000000000L, 0L);
                this.updateChildrenState(moved);
                break;
            }
            case Remove: {
                moved.setRStatus(0x2000000000L, 0L, 0L);
                this.updateChildrenState(moved);
                break;
            }
            case Restore: {
                moved.setRStatus(0x8000000000L, 0x2000000000L, 0L);
                this.updateChildrenState(moved);
                break;
            }
            case Forbid: {
                throw new IllegalStateException("Cannot move " + String.valueOf(moved) + " in " + String.valueOf((Object)movedState) + " state \nto " + String.valueOf(newParent) + " in " + String.valueOf((Object)newParentState) + " state.");
            }
            default: {
                assert (false) : action;
                break;
            }
        }
    }

    private static CmsState getState(SmObjectImpl obj) {
        MStatus s = obj.getStatus();
        if (s.isCmsToAdd() || obj.getData().hasAnyStatus(0x100000000000L) == StatusState.TRUE) {
            return CmsState.CMS_ADDED;
        }
        if (s.isCmsToDelete()) {
            return CmsState.CMS_DELETED;
        }
        if (!s.isCmsManaged()) {
            return CmsState.NON_VERSIONED;
        }
        if (s.isCmsReadOnly()) {
            return CmsState.CHECKIN;
        }
        return CmsState.CHECKOUT;
    }

    private static enum Action {
        Nothing,
        CmsAdd,
        CancelCmsAdd,
        Remove,
        Restore,
        Forbid;

    }

    private static enum CmsState {
        NON_VERSIONED,
        CMS_ADDED,
        CHECKIN,
        CHECKOUT,
        CMS_DELETED;

    }
}

