/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.cms.repository;

import com.modeliosoft.modelio.cms.driver.CmsDriverException;
import com.modeliosoft.modelio.cms.driver.ICmsDriver;
import com.modeliosoft.modelio.cms.driver.ICmsStatus;
import com.modeliosoft.modelio.cms.driver.ICmsStatusDriver;
import com.modeliosoft.modelio.cms.engine.ICmsFilesGetter;
import com.modeliosoft.modelio.cms.repository.CmsVersionedExmlStorageHandler;
import com.modeliosoft.modelio.cms.repository.IHistoryHook;
import com.modeliosoft.modelio.cms.repository.ModelRefreshingCmsDriver;
import com.modeliosoft.modelio.cms.repository.StatusInitializer;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import org.modelio.vbasic.files.FileUtils;
import org.modelio.vbasic.log.Log;
import org.modelio.vbasic.progress.IModelioProgress;
import org.modelio.vbasic.progress.SubProgress;
import org.modelio.vcore.model.DuplicateObjectException;
import org.modelio.vcore.session.impl.storage.IModelLoader;
import org.modelio.vcore.session.impl.storage.IModelLoaderProvider;
import org.modelio.vcore.smkernel.IRepositoryObject;
import org.modelio.vcore.smkernel.SmObjectImpl;
import org.modelio.vcore.smkernel.SmStatus;
import org.modelio.vcore.smkernel.StatusState;
import org.modelio.vcore.smkernel.mapi.MObject;
import org.modelio.vcore.smkernel.mapi.MStatus;
import org.modelio.vstore.exml.common.ExmlStorageHandler;
import org.modelio.vstore.exml.resource.ExmlFileAccess;
import org.modelio.vstore.exml.resource.IExmlRepositoryGeometry;
import org.modelio.vstore.exml.resource.IExmlResourceProvider;
import org.modelio.vstore.exml.resource.LocalExmlResourceProvider;
import org.modelio.vstore.exml.versioned.IVersionStatusInitializer;
import org.modelio.vstore.exml.versioned.VersionedExmlBase;

public class CmsVersionedRepository
extends VersionedExmlBase {
    private boolean needLock;
    private final ICmsDriver refreshingCmsDriver;
    private final ICmsDriver lowLevelDriver;
    private StatusInitializer statusInitializer;
    private IHistoryHook removalHistory;
    private ExmlFileAccess exmlFileAccess;
    private final Path repositoryPath;

    public CmsVersionedRepository(String name, Path path, Path runtimePath, ICmsDriver cmsDriver, boolean needLock) {
        super((IExmlResourceProvider)new LocalExmlResourceProvider(path, runtimePath, name));
        this.needLock = needLock;
        this.lowLevelDriver = cmsDriver;
        this.repositoryPath = path;
        this.refreshingCmsDriver = new ModelRefreshingCmsDriver(this.lowLevelDriver, this);
    }

    public ICmsDriver getDriver() {
        return this.refreshingCmsDriver;
    }

    public synchronized void doReloadCmsNode(SmObjectImpl obj, IModelLoader modelLoader) throws DuplicateObjectException, IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (Closeable c = () -> this.statusInitializer.processDeferredStatusInit(modelLoader);){
            super.doReloadCmsNode(obj, modelLoader);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private IExmlRepositoryGeometry getGeometry() {
        return this.getResourceProvider().getGeometry();
    }

    public void open(IModelLoaderProvider modelLoadProvider, IModelioProgress monitor) throws IOException {
        SubProgress mon = SubProgress.convert((IModelioProgress)monitor, (int)5);
        this.statusInitializer = new StatusInitializer(this);
        super.open(modelLoadProvider, (IModelioProgress)mon.newChild(4));
        if (this.removalHistory != null) {
            String expectedStamp = this.getResourceProvider().getStamp();
            this.removalHistory.open((IModelioProgress)mon.newChild(1), expectedStamp);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void refreshStatus(Collection<MObject> cmsNodes) {
        if (cmsNodes.isEmpty()) {
            return;
        }
        for (MObject cmsNode : cmsNodes) {
            void h;
            SmObjectImpl smObject = (SmObjectImpl)cmsNode;
            IRepositoryObject iRepositoryObject = smObject.getRepositoryObject();
            if (!(iRepositoryObject instanceof CmsVersionedExmlStorageHandler)) continue;
            CmsVersionedExmlStorageHandler cfr_ignored_0 = (CmsVersionedExmlStorageHandler)iRepositoryObject;
            CmsVersionedExmlStorageHandler cfr_ignored_1 = (CmsVersionedExmlStorageHandler)iRepositoryObject;
            h.setCmsStatusLoaded(false);
        }
        this.getModelLoaderProvider().asyncRefreshModel(refresher -> {
            try {
                this.statusInitializer.refreshStatus(cmsNodes, (IModelLoader)refresher);
            }
            catch (CmsDriverException e) {
                this.getErrorSupport().fireError((Throwable)((Object)e));
            }
        });
    }

    public void setNeedLock(boolean needLock) {
        this.needLock = needLock;
    }

    public ICmsDriver getLowLevelDriver() {
        return this.lowLevelDriver;
    }

    protected void deleteCmsNodes(Collection<ExmlStorageHandler> toDelete, IModelioProgress monitor) {
        ArrayList<File> filesToRevert = new ArrayList<File>(toDelete.size() / 2);
        ArrayList<File> filesToDelete = new ArrayList<File>(toDelete.size() / 2);
        SubProgress mon = SubProgress.convert((IModelioProgress)monitor, (int)(toDelete.size() * 2));
        ICmsFilesGetter filesGetter = this.getFilesGetter();
        ICmsStatusDriver statusDriver = this.lowLevelDriver.getStatusDriver();
        for (ExmlStorageHandler exmlHandler : toDelete) {
            for (File file : filesGetter.getRelatedRefFiles(exmlHandler.getCmsNodeId().toMRef())) {
                try {
                    ICmsStatus status = statusDriver.getStatus(file, false);
                    if (status.isVersioned() || status.isToDelete()) {
                        filesToDelete.add(file);
                        continue;
                    }
                    if (!status.isToAdd() || !file.isFile()) continue;
                    filesToRevert.add(file);
                }
                catch (CmsDriverException e) {
                    this.getErrorSupport().fireWarning((Throwable)new IOException(String.format("Failed getting status of %s: %s", file, e.getLocalizedMessage()), (Throwable)((Object)e)));
                }
            }
        }
        try {
            this.lowLevelDriver.delete((IModelioProgress)mon.newChild(filesToDelete.size()), filesToDelete);
        }
        catch (CmsDriverException e) {
            this.getErrorSupport().fireWarning((Throwable)new IOException("Failed removing from version some files: " + e.getLocalizedMessage(), (Throwable)((Object)e)));
        }
        try {
            this.lowLevelDriver.revert((IModelioProgress)mon.newChild(filesToRevert.size()), filesToRevert);
        }
        catch (CmsDriverException e) {
            this.getErrorSupport().fireWarning((Throwable)new IOException("Failed cancelling add to version some files: " + e.getLocalizedMessage(), (Throwable)((Object)e)));
        }
        super.deleteCmsNodes(toDelete, (IModelioProgress)mon.newChild(toDelete.size()));
    }

    protected IVersionStatusInitializer getStatusInitializer() {
        return this.statusInitializer;
    }

    protected ExmlStorageHandler instantiateStorageHandler(SmObjectImpl cmsNode, boolean isNodeLoaded) {
        return new CmsVersionedExmlStorageHandler(this, cmsNode, isNodeLoaded);
    }

    protected void save(ExmlStorageHandler handler, IModelioProgress monitor) throws IOException {
        IModelioProgress progress = monitor;
        if (handler.isLoaded()) {
            SmObjectImpl cmsNode = handler.getCmsNode();
            boolean isToAdd = this.isAddFileToBeDone(cmsNode);
            boolean isToRemove = !isToAdd && this.isRemoveFileToBeDone(cmsNode);
            boolean isCancelRemove = !isToAdd && !isToRemove && this.isCancelRemoveToBeDone(cmsNode);
            ICmsFilesGetter filesGetter = this.getFilesGetter();
            if (isToRemove) {
                try {
                    for (File f : filesGetter.getRelatedFiles((MObject)cmsNode)) {
                        this.lowLevelDriver.delete(f);
                    }
                }
                catch (CmsDriverException e) {
                    this.getErrorSupport().fireWarning((Throwable)((Object)e));
                }
            } else if (isCancelRemove) {
                try {
                    SubProgress mon2 = SubProgress.convert((IModelioProgress)monitor, (int)2);
                    this.lowLevelDriver.cancelDelete((IModelioProgress)mon2.newChild(1), filesGetter.getRelatedFiles((MObject)cmsNode));
                    progress = mon2.newChild(1);
                }
                catch (CmsDriverException e) {
                    throw new IOException(e.getLocalizedMessage(), (Throwable)((Object)e));
                }
            }
            super.save(handler, progress);
            if (isToAdd) {
                try {
                    for (File f : filesGetter.getRelatedFiles((MObject)cmsNode)) {
                        this.lowLevelDriver.addFile(f);
                    }
                    cmsNode.getData().setRFlags(0L, 0x100000000000L, 0L);
                }
                catch (CmsDriverException e) {
                    this.getErrorSupport().fireWarning((Throwable)((Object)e));
                }
            } else if (!isToRemove) {
                boolean isCmsManaged;
                boolean bl = isCmsManaged = cmsNode.getData().hasAllStatus(0x8000000000L) == StatusState.TRUE;
                if (isCmsManaged) {
                    cmsNode.setRStatus(0x800000000L, 0L, 0L);
                }
            }
        }
    }

    private boolean isAddFileToBeDone(SmObjectImpl cmsNode) {
        boolean isCmsToAdd;
        boolean bl = isCmsToAdd = cmsNode.getData().hasAnyStatus(0x101000000000L) == StatusState.TRUE;
        if (isCmsToAdd) {
            try {
                File f = this.getExmlFileAccess().getExmlFile((MObject)cmsNode);
                ICmsStatus status = this.lowLevelDriver.getStatusDriver().getStatus(f, false);
                if (status == null || !status.isVersioned()) {
                    return true;
                }
            }
            catch (CmsDriverException e) {
                this.getErrorSupport().fireWarning((Throwable)((Object)e));
                return false;
            }
        }
        return false;
    }

    public boolean isLockNeeded() {
        return this.needLock;
    }

    public void save(IModelioProgress monitor) {
        super.save(monitor);
        try {
            String stamp = this.getResourceProvider().getStamp();
            this.getHistoryHook().onSave(stamp);
        }
        catch (IOException e) {
            Log.error((String)"Failed saving '%s' repository removed elements history: %s", (Object[])new Object[]{this.getURI(), FileUtils.getLocalizedMessage((IOException)e)});
            Log.error((Throwable)e);
        }
        this.refreshingCmsDriver.getStatusDriver().invalidateCaches();
    }

    private boolean isRemoveFileToBeDone(SmObjectImpl cmsNode) {
        boolean isCmsToDel;
        boolean bl = isCmsToDel = cmsNode.getData().hasAnyStatus(0x2000000040L) == StatusState.TRUE;
        if (isCmsToDel) {
            try {
                File f = this.getExmlFileAccess().getExmlFile((MObject)cmsNode);
                ICmsStatus status = this.lowLevelDriver.getStatusDriver().getStatus(f, false);
                return status != null && status.isVersioned() && !status.isToDelete();
            }
            catch (CmsDriverException e) {
                this.getErrorSupport().fireWarning((Throwable)((Object)e));
                return false;
            }
        }
        return false;
    }

    @Deprecated
    private void deleteCmsNode(SmObjectImpl object) {
        MStatus status = object.getStatus();
        if (status.isCmsManaged() || status.isCmsToDelete() || object.getRepositoryObject().getRepositoryId() != this.getRepositoryId()) {
            try {
                for (File f : this.getFilesGetter().getRelatedFiles((MObject)object)) {
                    this.lowLevelDriver.delete(f);
                }
            }
            catch (CmsDriverException e) {
                this.getErrorSupport().fireWarning((Throwable)new IOException("Failed removing from version " + String.valueOf(object) + ": " + e.getLocalizedMessage(), (Throwable)((Object)e)));
            }
        } else if (status.isCmsToAdd() && this.getExmlFileAccess().getExmlFile((MObject)object).isFile()) {
            try {
                this.lowLevelDriver.revert(null, this.getFilesGetter().getRelatedFiles((MObject)object));
            }
            catch (CmsDriverException e) {
                this.getErrorSupport().fireWarning((Throwable)new IOException("Failed cancelling add to version " + String.valueOf(object) + ": " + e.getLocalizedMessage(), (Throwable)((Object)e)));
            }
        }
    }

    private boolean isCancelRemoveToBeDone(SmObjectImpl cmsNode) {
        boolean isCmsToDel;
        boolean bl = isCmsToDel = cmsNode.getData().hasAnyStatus(0x2000000040L) == StatusState.TRUE;
        if (!isCmsToDel) {
            try {
                File f = this.getExmlFileAccess().getExmlFile((MObject)cmsNode);
                ICmsStatus status = this.lowLevelDriver.getStatusDriver().getStatus(f, false);
                return status != null && status.isToDelete();
            }
            catch (CmsDriverException e) {
                this.getErrorSupport().fireWarning((Throwable)((Object)e));
                return false;
            }
        }
        return false;
    }

    public synchronized void close() {
        super.close();
        this.lowLevelDriver.dispose();
        if (this.removalHistory != null) {
            this.removalHistory.onClose();
            this.removalHistory = null;
        }
    }

    public void registerHistoryHook(IHistoryHook hook) {
        this.removalHistory = hook;
    }

    public IHistoryHook getHistoryHook() {
        if (this.removalHistory == null) {
            return AbstractHistoryHook.instance;
        }
        return this.removalHistory;
    }

    private ICmsFilesGetter getFilesGetter() {
        return this.lowLevelDriver.getFilesGetter();
    }

    public final ExmlFileAccess getExmlFileAccess() {
        if (this.exmlFileAccess == null) {
            IExmlRepositoryGeometry geom = this.getGeometry();
            if (geom == null) {
                throw new IllegalStateException();
            }
            this.exmlFileAccess = new ExmlFileAccess(this.repositoryPath.toFile(), geom);
        }
        return this.exmlFileAccess;
    }

    private static class AbstractHistoryHook
    implements IHistoryHook {
        public static IHistoryHook instance = new AbstractHistoryHook();

        private AbstractHistoryHook() {
        }

        @Override
        public void open(IModelioProgress monitor, String expectedStamp) throws IOException {
        }

        @Override
        public void onSave(String stamp) throws IOException {
        }

        @Override
        public void onDetachObject(SmObjectImpl object, SmObjectImpl cmsNode) {
        }

        @Override
        public void onClose() {
        }

        @Override
        public void onAttachObject(SmObjectImpl obj, SmObjectImpl cmsNode) {
        }
    }

    static class StatusConf {
        public long on;
        public long off;
        public long undef;

        public StatusConf(long on, long off, long undef) {
            this.on = on;
            this.off = off;
            this.undef = undef;
        }

        public void set(long bitdef, boolean onOff) {
            if (onOff) {
                this.on |= bitdef;
            } else {
                this.off |= bitdef;
            }
        }

        public String toString() {
            return "on=" + SmStatus.flagsToString((long)this.on) + ", off=" + SmStatus.flagsToString((long)this.off) + ", undef=" + SmStatus.flagsToString((long)this.undef);
        }
    }
}

