/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.cms.repository;

import com.modeliosoft.modelio.cms.api.CmsRevisionRange;
import com.modeliosoft.modelio.cms.api.ConflictSide;
import com.modeliosoft.modelio.cms.api.ICmsUnlockResult;
import com.modeliosoft.modelio.cms.api.OutdatedElementsException;
import com.modeliosoft.modelio.cms.driver.CmsAuthenticationException;
import com.modeliosoft.modelio.cms.driver.CmsDriverException;
import com.modeliosoft.modelio.cms.driver.ICmsCommitResult;
import com.modeliosoft.modelio.cms.driver.ICmsDriver;
import com.modeliosoft.modelio.cms.driver.ICmsLockResult;
import com.modeliosoft.modelio.cms.driver.ICmsLog;
import com.modeliosoft.modelio.cms.driver.ICmsRepositoryProperties;
import com.modeliosoft.modelio.cms.driver.ICmsStatusDriver;
import com.modeliosoft.modelio.cms.driver.ICmsUpdateResult;
import com.modeliosoft.modelio.cms.driver.parse.StructureSnapshot;
import com.modeliosoft.modelio.cms.engine.ICmsFilesGetter;
import com.modeliosoft.modelio.cms.repository.CmsUpdateRepositoryChangeEvent;
import com.modeliosoft.modelio.cms.repository.CmsVersionedRepository;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.modelio.vbasic.auth.IAuthData;
import org.modelio.vbasic.log.Log;
import org.modelio.vbasic.progress.IModelioProgress;
import org.modelio.vbasic.progress.SubProgress;
import org.modelio.vcore.session.api.repository.IRepository;
import org.modelio.vcore.session.api.repository.IRepositoryChangeEvent;
import org.modelio.vcore.smkernel.SmObjectImpl;
import org.modelio.vcore.smkernel.mapi.MClass;
import org.modelio.vcore.smkernel.mapi.MMetamodel;
import org.modelio.vcore.smkernel.mapi.MObject;
import org.modelio.vcore.smkernel.mapi.MRef;
import org.modelio.vcore.smkernel.meta.SmClass;
import org.modelio.vcore.smkernel.meta.SmMetamodel;
import org.modelio.vstore.exml.resource.ExmlFileAccess;

class ModelRefreshingCmsDriver
implements ICmsDriver {
    private ICmsDriver driver;
    private CmsVersionedRepository repository;

    public ModelRefreshingCmsDriver(ICmsDriver driver, CmsVersionedRepository repo) {
        this.driver = driver;
        this.repository = repo;
    }

    @Override
    public void addFile(File file) throws CmsDriverException {
        this.driver.addFile(file);
        if (this.driver.getFilesGeometry().isModelFile(file)) {
            MRef ref = this.driver.getFilesGeometry().getObRef(file);
            this.repository.refreshStatus(this.getLoadedRefs(Collections.singleton(ref)));
        }
    }

    @Override
    public void checkout(IModelioProgress monitor) throws CmsDriverException {
        this.driver.checkout(monitor);
    }

    @Override
    public void cleanUpWorkingCopy(IModelioProgress monitor) throws CmsDriverException {
        this.driver.cleanUpWorkingCopy(monitor);
    }

    @Override
    public ICmsCommitResult commitAll(IModelioProgress monitor, String message) throws CmsDriverException {
        ICmsCommitResult ret = this.driver.commitAll(monitor, message);
        if (this.repository.isOpen()) {
            Collection<MObject> result = this.getAllLoadedCmsNodes();
            this.repository.refreshStatus(result);
        }
        return ret;
    }

    private Collection<MObject> getAllLoadedCmsNodes() {
        HashSet<MObject> result = new HashSet<MObject>(5000);
        for (SmClass c : this.getMetamodel().getRegisteredMClasses()) {
            if (!c.isCmsNode()) continue;
            this.repository.getLoadCache().findByClass((MClass)c, false, result);
        }
        return result;
    }

    @Override
    public ICmsCommitResult commit(IModelioProgress monitor, Collection<File> files, boolean keepLock, String message) throws CmsDriverException, OutdatedElementsException {
        try {
            ICmsCommitResult ret;
            ICmsCommitResult iCmsCommitResult = ret = this.driver.commit(monitor, files, keepLock, message);
            return iCmsCommitResult;
        }
        finally {
            this.repository.refreshStatus(this.getLoadedFiles(files));
        }
    }

    private Collection<MObject> getLoadedRefs(Collection<MRef> refs) {
        ArrayList<MObject> coll = new ArrayList<MObject>(refs.size());
        for (MRef ref : refs) {
            MObject lobj = this.repository.getLoadCache().findByRef(ref);
            if (lobj == null) continue;
            coll.add(lobj);
        }
        return coll;
    }

    @Override
    public void createBranch(String branchName, String message) throws CmsDriverException {
        this.driver.createBranch(branchName, message);
    }

    @Override
    public void createRepositoryStructure(IModelioProgress monitor, MMetamodel metamodel) throws CmsDriverException {
        this.driver.createRepositoryStructure(monitor, metamodel);
    }

    @Override
    public void createTag(String tagName, String message) throws CmsDriverException {
        this.driver.createTag(tagName, message);
    }

    @Override
    public void delete(File f) throws CmsDriverException {
        this.driver.delete(f);
    }

    @Override
    public ICmsUpdateResult exportRepository(IModelioProgress monitor, String label, String revision, File destPath) throws CmsDriverException, InterruptedException {
        return this.driver.exportRepository(monitor, label, revision, destPath);
    }

    @Override
    public ICmsLog getLog(IModelioProgress monitor, Collection<File> refs) throws CmsDriverException {
        return this.driver.getLog(monitor, refs);
    }

    @Override
    public URI getRepositoryUri() {
        return this.driver.getRepositoryUri();
    }

    @Override
    public ICmsStatusDriver getStatusDriver() {
        return this.driver.getStatusDriver();
    }

    @Override
    public boolean isVersioned(Path p) {
        return this.driver.isVersioned(p);
    }

    @Override
    public ICmsLockResult lock(IModelioProgress aMonitor, Collection<File> refsToLock, boolean stealLock, String lockComment) throws CmsDriverException {
        try {
            ICmsLockResult ret = this.driver.lock(aMonitor, refsToLock, stealLock, lockComment);
            this.repository.refreshStatus(this.getLoadedRefs(ret.getLockedElements()));
            return ret;
        }
        catch (CmsDriverException e) {
            this.repository.refreshStatus(this.getLoadedFiles(refsToLock));
            throw e;
        }
    }

    @Override
    public void relocateRepository(IModelioProgress monitor, String newRepositoryPath) throws CmsDriverException {
        this.driver.relocateRepository(monitor, newRepositoryPath);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void revert(IModelioProgress monitor, Collection<File> files) throws CmsDriverException {
        block9: {
            mon = SubProgress.convert((IModelioProgress)monitor, (int)100);
            absentFiles = new HashSet<File>();
            for (File f : files) {
                if (f.isFile()) continue;
                absentFiles.add(f);
            }
            try {
                this.driver.revert((IModelioProgress)mon.newChild(40), files);
                break block9;
            }
            catch (Throwable var5_7) {
                deletedFiles = new ArrayList<File>();
                createdFiles = new ArrayList<File>();
                modifiedFiles = new ArrayList<File>();
                ** for (f : files)
            }
lbl-1000:
            // 1 sources

            {
                if (!f.isFile()) {
                    if (absentFiles.contains(f)) continue;
                    deletedFiles.add(f);
                    continue;
                }
                if (absentFiles.contains(f)) {
                    createdFiles.add(f);
                    continue;
                }
                modifiedFiles.add(f);
                continue;
            }
lbl28:
            // 1 sources

            createdRefs = this.getRefs(createdFiles);
            modifiedRefs = this.getRefs(modifiedFiles);
            deletedRefs = this.getRefs(deletedFiles);
            this.repository.updateIndexes(createdRefs, modifiedRefs, deletedRefs, (IModelioProgress)mon.newChild(40));
            throw var5_7;
        }
        deletedFiles = new ArrayList<E>();
        createdFiles = new ArrayList<File>();
        modifiedFiles = new ArrayList<File>();
        for (File f : files) {
            if (!f.isFile()) {
                if (absentFiles.contains(f)) continue;
                deletedFiles.add(f);
                continue;
            }
            if (absentFiles.contains(f)) {
                createdFiles.add(f);
                continue;
            }
            modifiedFiles.add(f);
        }
        createdRefs = this.getRefs(createdFiles);
        modifiedRefs = this.getRefs(modifiedFiles);
        deletedRefs = this.getRefs(deletedFiles);
        this.repository.updateIndexes(createdRefs, modifiedRefs, deletedRefs, (IModelioProgress)mon.newChild(40));
    }

    @Override
    public ICmsUpdateResult switchWorkingCopy(IModelioProgress monitor, String newRepositoryPath) throws CmsDriverException {
        SubProgress mon = SubProgress.convert((IModelioProgress)monitor, (int)150);
        ICmsUpdateResult ret = this.driver.switchWorkingCopy((IModelioProgress)mon.newChild(50), newRepositoryPath);
        this.postUpdate((IModelioProgress)mon.newChild(100), ret);
        return ret;
    }

    @Override
    public ICmsUnlockResult unlock(IModelioProgress aMonitor, Collection<File> refsToUnlock, boolean breakLock) throws CmsDriverException {
        ICmsUnlockResult ret = this.driver.unlock(aMonitor, refsToUnlock, breakLock);
        this.repository.refreshStatus(this.getLoadedFiles(refsToUnlock));
        return ret;
    }

    @Override
    public int updateAdmin(IModelioProgress monitor) throws CmsDriverException {
        return this.driver.updateAdmin(monitor);
    }

    @Override
    public ICmsUpdateResult updateModel(IModelioProgress monitor, Collection<File> additionalUpdates, String revision) throws CmsDriverException {
        SubProgress mon = SubProgress.convert((IModelioProgress)monitor, (int)300);
        ICmsUpdateResult ret = this.driver.updateModel((IModelioProgress)mon.newChild(200), additionalUpdates, revision);
        this.postUpdate((IModelioProgress)mon.newChild(100), ret);
        return ret;
    }

    @Override
    public void updateRepositoryStructure(IModelioProgress monitor, MMetamodel metamodel) throws CmsDriverException {
        this.driver.updateRepositoryStructure(monitor, metamodel);
    }

    @Override
    public String getUser() {
        return this.driver.getUser();
    }

    @Override
    public StructureSnapshot getStructureSnapshot() {
        return this.driver.getStructureSnapshot();
    }

    @Override
    public ExmlFileAccess getFilesGeometry() {
        return this.driver.getFilesGeometry();
    }

    @Override
    public ICmsRepositoryProperties getAdminProperties() throws IOException {
        return this.driver.getAdminProperties();
    }

    @Override
    public IRepository buildConflictRepository(Path repoPath, Collection<MObject> conflictedElements, Collection<File> conflictedFiles, ConflictSide side) throws IOException {
        return this.driver.buildConflictRepository(repoPath, conflictedElements, conflictedFiles, side);
    }

    @Override
    public void setResolved(Collection<File> refs, ConflictSide side) throws CmsDriverException {
        this.driver.setResolved(refs, side);
        if (side != ConflictSide.MERGED) {
            SimpleUpdateResult cmsRes = new SimpleUpdateResult(new ArrayList<MRef>(this.getRefs(refs)));
            this.postUpdate(null, cmsRes);
        }
    }

    private Collection<MRef> getRefs(Collection<File> files) {
        ArrayList<MRef> coll = new ArrayList<MRef>(files.size());
        ExmlFileAccess geometry = this.getFilesGeometry();
        for (File f : files) {
            if (!geometry.isModelFile(f)) continue;
            coll.add(geometry.getObRef(f));
        }
        return coll;
    }

    private Collection<MObject> getLoadedFiles(Collection<File> files) {
        ArrayList<MObject> coll = new ArrayList<MObject>(files.size());
        ExmlFileAccess geometry = this.getFilesGeometry();
        for (File f : files) {
            if (!geometry.isModelFile(f)) continue;
            MRef ref = geometry.getObRef(f);
            MObject lobj = this.repository.getLoadCache().findByRef(ref);
            if (lobj == null) continue;
            coll.add(lobj);
        }
        return coll;
    }

    @Override
    public ICmsFilesGetter getFilesGetter() {
        return this.driver.getFilesGetter();
    }

    @Override
    public void initialize(ICmsFilesGetter filesGetter) {
        this.driver.initialize(filesGetter);
    }

    private Collection<String> getBlobs(Collection<File> files) {
        ArrayList<String> coll = null;
        ExmlFileAccess geometry = this.getFilesGeometry();
        for (File f : files) {
            if (!geometry.isBlobFile(f)) continue;
            if (coll == null) {
                coll = new ArrayList<String>(files.size() / 4 + 1);
            }
            coll.add(geometry.getBlobKey(f));
        }
        if (coll == null) {
            return Collections.emptyList();
        }
        return coll;
    }

    @Override
    public ICmsLog getLog(IModelioProgress monitor, String branchUrl, String fromRevision, Collection<File> files, boolean stopOnBranchStart) throws CmsDriverException {
        return this.driver.getLog(monitor, branchUrl, fromRevision, files, stopOnBranchStart);
    }

    @Override
    public ICmsUpdateResult merge(IModelioProgress monitor, String fromUrl, Collection<String> revisions) throws CmsDriverException {
        SubProgress mon = SubProgress.convert((IModelioProgress)monitor, (int)300);
        ICmsUpdateResult ret = this.driver.merge((IModelioProgress)mon.newChild(200), fromUrl, revisions);
        this.loadDeletedElements(ret);
        this.postUpdate((IModelioProgress)mon.newChild(100), ret);
        return ret;
    }

    private void postUpdate(IModelioProgress monitor, ICmsUpdateResult ret) {
        SubProgress mon = SubProgress.convert((IModelioProgress)monitor, (int)100);
        ArrayList<MRef> updatesAndConflicts = new ArrayList<MRef>(ret.getUpdatedElements());
        updatesAndConflicts.addAll(ret.getConflictedElements());
        updatesAndConflicts.addAll(ret.getMergedElements());
        this.repository.updateIndexes(ret.getCreatedElements(), updatesAndConflicts, ret.getDeletedElements(), (IModelioProgress)mon.newChild(50));
        HashSet<MObject> toRefresh = new HashSet<MObject>();
        ArrayList<MRef> toRestore = new ArrayList<MRef>(3);
        toRefresh.addAll(this.getLoadedRefs(updatesAndConflicts));
        SmMetamodel metamodel = this.repository.getModelLoaderProvider().getMetamodel();
        for (MRef createdRef : ret.getCreatedElements()) {
            SmClass cls = metamodel.getMClass(createdRef.mc);
            if (!cls.areOrphansAllowed()) continue;
            toRestore.add(createdRef);
            Log.trace((String)" %s potential composition root created in '%s' repository.", (Object[])new Object[]{createdRef, this.repository.getResourceProvider().getName()});
        }
        mon.worked(20);
        this.repository.refreshModel(toRefresh, this.getLoadedRefs(ret.getDeletedElements()), toRestore);
        toRefresh = new HashSet(ret.getUnlockedElements().size() + updatesAndConflicts.size());
        toRefresh.addAll(this.getLoadedRefs(ret.getUnlockedElements()));
        toRefresh.addAll(this.getLoadedRefs(updatesAndConflicts));
        if (!toRefresh.isEmpty()) {
            this.repository.refreshStatus(toRefresh);
        }
        CmsUpdateRepositoryChangeEvent event = new CmsUpdateRepositoryChangeEvent((IRepository)this.repository, ret);
        this.repository.getModelLoaderProvider().fireRepositoryChange((IRepositoryChangeEvent)event);
    }

    @Override
    public Collection<String> suggestMergeSources() throws CmsAuthenticationException, CmsDriverException {
        return this.driver.suggestMergeSources();
    }

    @Override
    public ICmsUpdateResult revertRevision(IModelioProgress monitor, String revision) throws CmsDriverException {
        SubProgress mon = SubProgress.convert((IModelioProgress)monitor, (int)300);
        ICmsUpdateResult ret = this.driver.revertRevision((IModelioProgress)mon.newChild(200), revision);
        this.loadDeletedElements(ret);
        this.postUpdate((IModelioProgress)mon.newChild(100), ret);
        return ret;
    }

    @Override
    public ICmsUpdateResult merge(IModelioProgress monitor, String fromUrl, String fromRevision, Collection<CmsRevisionRange> revisions) throws CmsDriverException {
        SubProgress mon = SubProgress.convert((IModelioProgress)monitor, (int)300);
        ICmsUpdateResult ret = this.driver.merge((IModelioProgress)mon.newChild(200), fromUrl, fromRevision, revisions);
        this.loadDeletedElements(ret);
        this.postUpdate((IModelioProgress)mon.newChild(100), ret);
        return ret;
    }

    private void loadDeletedElements(ICmsUpdateResult ret) {
        for (MRef ref : ret.getDeletedElements()) {
            SmObjectImpl deleted = this.repository.findById(this.getMetamodel().getMClass(ref.mc), ref.uuid);
            if (deleted != null) continue;
            Log.warning((String)("ModelRefreshingCmsDriver.merge(): cannot find " + String.valueOf(ref) + " to delete."));
        }
    }

    private SmMetamodel getMetamodel() {
        return this.repository.getModelLoaderProvider().getMetamodel();
    }

    @Override
    public void delete(IModelioProgress monitor, Collection<File> filesToDelete) throws CmsDriverException {
        this.driver.delete(monitor, filesToDelete);
    }

    @Override
    public void cancelDelete(IModelioProgress monitor, Collection<File> files) throws CmsDriverException {
        this.driver.cancelDelete(monitor, files);
    }

    @Override
    public void addFile(File file, Map<String, String> fileSvnProperties) throws CmsDriverException {
        this.driver.addFile(file, fileSvnProperties);
        if (this.driver.getFilesGeometry().isModelFile(file)) {
            MRef ref = this.driver.getFilesGeometry().getObRef(file);
            this.repository.refreshStatus(this.getLoadedRefs(Collections.singleton(ref)));
        }
    }

    @Override
    public void checkout(String url, File path, IAuthData auth, IModelioProgress monitor) throws CmsDriverException {
        this.driver.checkout(url, path, auth, monitor);
    }

    @Override
    public void moveFile(File oldPath, File newPath, boolean doMoveFile) throws CmsDriverException {
        this.driver.moveFile(oldPath, newPath, doMoveFile);
    }

    @Override
    public void getFileContent(File filePath, OutputStream dst, String revision) throws CmsDriverException {
        this.driver.getFileContent(filePath, dst, revision);
    }

    @Override
    public void copyFile(File oldPath, File newPath, boolean doFsOperation) throws CmsDriverException {
        this.driver.copyFile(oldPath, newPath, doFsOperation);
    }

    @Override
    public void exportDiffRepository(IModelioProgress monitor, Path runtimePath, String url, String revision) throws CmsDriverException, InterruptedException {
        this.driver.exportDiffRepository(monitor, runtimePath, url, revision);
    }

    @Override
    public void dispose() {
        this.driver.dispose();
    }

    private static final class SimpleUpdateResult
    implements ICmsUpdateResult {
        private final List<MRef> modelRefs;

        SimpleUpdateResult(List<MRef> modelRefs) {
            this.modelRefs = modelRefs;
        }

        @Override
        public List<MRef> getUpdatedElements() {
            return this.modelRefs;
        }

        @Override
        public Collection<String> getUpdatedBlobs() {
            return Collections.emptyList();
        }

        @Override
        public List<MRef> getUnlockedElements() {
            return Collections.emptyList();
        }

        @Override
        public List<MRef> getMergedElements() {
            return Collections.emptyList();
        }

        @Override
        public Throwable getIncompleteUpdateCause() {
            return null;
        }

        @Override
        public List<MRef> getDeletedElements() {
            return Collections.emptyList();
        }

        @Override
        public Collection<String> getDeletedBlobs() {
            return Collections.emptyList();
        }

        @Override
        public List<MRef> getCreatedElements() {
            return Collections.emptyList();
        }

        @Override
        public Collection<String> getCreatedBlobs() {
            return Collections.emptyList();
        }

        @Override
        public List<MRef> getConflictedElements() {
            return Collections.emptyList();
        }

        @Override
        public Collection<String> getConflictedBlobs() {
            return Collections.emptyList();
        }

        @Override
        public Collection<File> getCreatedOtherFiles() {
            return Collections.emptyList();
        }

        @Override
        public Collection<File> getDeletedOtherFiles() {
            return Collections.emptyList();
        }

        @Override
        public Collection<File> getUpdatedOtherFiles() {
            return Collections.emptyList();
        }

        @Override
        public Collection<File> getConflictedOtherFiles() {
            return Collections.emptyList();
        }

        @Override
        public Collection<File> getMergedOtherFiles() {
            return Collections.emptyList();
        }

        @Override
        public Collection<File> getUnlockedOtherFiles() {
            return Collections.emptyList();
        }

        @Override
        public Collection<String> getMergedBlobs() {
            return Collections.emptyList();
        }

        @Override
        public Collection<String> getUnlockedBlobs() {
            return Collections.emptyList();
        }
    }
}

